/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.IOException;
import java.io.InputStream;
import net.noderunner.http.HttpUtil;
import net.noderunner.http.MessageHeader;
import net.noderunner.http.MessageHeaders;
import net.noderunner.http.Request;
import net.noderunner.http.RequestLine;

public class ServerRequest
extends Request {
    private final InputStream is;

    public ServerRequest(InputStream is) throws IOException {
        super(ServerRequest.getRequestLine(is), MessageHeaders.readHeaders(is));
        this.is = is;
    }

    private static RequestLine getRequestLine(InputStream is) throws IOException {
        String line;
        while ((line = HttpUtil.readHttpLine(is)).length() == 0) {
        }
        return new RequestLine(line);
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public int readFully() throws IOException {
        boolean close;
        InputStream s = HttpUtil.wrapInputStream(this.getInputStream(), this.getHeaders());
        if (s != null && !(close = this.getHeaders().contains(MessageHeader.MH_CONNECTION_CLOSE))) {
            return HttpUtil.readFully(s);
        }
        return 0;
    }

    public String toString() {
        return super.toString() + " is=" + this.is;
    }
}

