/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestMessage
extends OAuthMessage {
    private final HttpServletRequest request;

    public HttpRequestMessage(HttpServletRequest request, String URL2) {
        super(request.getMethod(), URL2, HttpRequestMessage.getParameters(request));
        this.request = request;
        HttpRequestMessage.copyHeaders(request, this.getHeaders());
    }

    @Override
    public InputStream getBodyAsStream() throws IOException {
        return this.request.getInputStream();
    }

    @Override
    public String getBodyEncoding() {
        return this.request.getCharacterEncoding();
    }

    private static void copyHeaders(HttpServletRequest request, Collection<Map.Entry<String, String>> into) {
        Enumeration names = request.getHeaderNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                Enumeration values = request.getHeaders(name);
                if (values == null) continue;
                while (values.hasMoreElements()) {
                    into.add(new OAuth.Parameter(name, (String)values.nextElement()));
                }
            }
        }
    }

    public static List<OAuth.Parameter> getParameters(HttpServletRequest request) {
        ArrayList<OAuth.Parameter> list = new ArrayList<OAuth.Parameter>();
        Enumeration headers = request.getHeaders("Authorization");
        while (headers != null && headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            for (OAuth.Parameter parameter : OAuthMessage.decodeAuthorization(header)) {
                if ("realm".equalsIgnoreCase(parameter.getKey())) continue;
                list.add(parameter);
            }
        }
        Iterator iterator = request.getParameterMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = iterator.next();
            String name = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                list.add(new OAuth.Parameter(name, value));
                ++n2;
            }
        }
        return list;
    }
}

