/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.tcp.Attached;
import net.openhft.chronicle.tcp.SinkTcp;
import net.openhft.chronicle.tcp.VanillaSelectionKeySet;
import net.openhft.chronicle.tcp.VanillaSelector;

public class SinkTcpAcceptor
extends SinkTcp {
    public SinkTcpAcceptor(ChronicleQueueBuilder.ReplicaChronicleQueueBuilder builder) {
        super("sink-acceptor", builder);
    }

    @Override
    public SocketChannel openSocketChannel() throws IOException {
        ServerSocketChannel socketChannel = ServerSocketChannel.open();
        socketChannel.socket().setReuseAddress(true);
        socketChannel.socket().bind(this.builder.bindAddress());
        socketChannel.configureBlocking(false);
        VanillaSelector selector = new VanillaSelector().open().register(socketChannel, 16, new Attached());
        long selectTimeout = this.builder.selectTimeout();
        VanillaSelectionKeySet selectionKeys = selector.vanillaSelectionKeys();
        SocketChannel channel = null;
        while (this.running.get() && channel == null) {
            Object keys;
            int nbKeys = selector.select(0, selectTimeout);
            if (nbKeys <= 0) continue;
            if (selectionKeys != null) {
                keys = selectionKeys.keys();
                int size = selectionKeys.size();
                for (int k = 0; k < size; ++k) {
                    Object key = keys[k];
                    if (key == null || !((SelectionKey)key).isAcceptable()) continue;
                    channel = socketChannel.accept();
                    this.logger.info("Accepted connection from: " + channel.getRemoteAddress());
                }
                selectionKeys.clear();
                continue;
            }
            keys = selector.selectionKeys();
            Iterator i$ = keys.iterator();
            while (i$.hasNext()) {
                SelectionKey key = (SelectionKey)i$.next();
                if (!key.isAcceptable()) continue;
                channel = socketChannel.accept();
                this.logger.info("Accepted connection from: " + channel.getRemoteAddress());
            }
            keys.clear();
        }
        selector.close();
        socketChannel.close();
        return channel;
    }

    @Override
    public boolean isLocalhost() {
        return true;
    }
}

