/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.util.Date;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.User;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public final class Attachment
extends Resource {
    private User author = null;
    private String filename = null;
    private Date created = null;
    private int size = 0;
    private String mimeType = null;
    private String content = null;

    protected Attachment(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get("self"));
        this.id = Field.getString(map.get("id"));
        this.author = Field.getResource(User.class, map.get("author"), this.restclient);
        this.filename = Field.getString(map.get("filename"));
        this.created = Field.getDate(map.get("created"));
        this.size = Field.getInteger(map.get("size"));
        this.mimeType = Field.getString(map.get("mimeType"));
        this.content = Field.getString(map.get("content"));
    }

    public static Attachment get(RestClient restclient, String id) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get("/rest/api/2/attachment/" + id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve attachment " + id, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Attachment(restclient, (JSONObject)result);
    }

    public String toString() {
        return this.getContentUrl();
    }

    public User getAuthor() {
        return this.author;
    }

    public Date getCreatedDate() {
        return this.created;
    }

    public String getContentUrl() {
        return this.content;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getSize() {
        return this.size;
    }
}

