/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public final class Component
extends Resource {
    private String name = null;
    private boolean isAssigneeTypeValid = false;

    protected Component(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get("self"));
        this.id = Field.getString(map.get("id"));
        this.name = Field.getString(map.get("name"));
        this.isAssigneeTypeValid = Field.getBoolean(map.get("isAssigneeTypeValid"));
    }

    public static Component get(RestClient restclient, String id) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get("/rest/api/2/component/" + id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve component " + id, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Component(restclient, (JSONObject)result);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public boolean isAssigneeTypeValid() {
        return this.isAssigneeTypeValid;
    }
}

