/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.rcarz.jiraclient.Attachment;
import net.rcarz.jiraclient.Comment;
import net.rcarz.jiraclient.Component;
import net.rcarz.jiraclient.CustomFieldOption;
import net.rcarz.jiraclient.Issue;
import net.rcarz.jiraclient.IssueLink;
import net.rcarz.jiraclient.IssueType;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.LinkType;
import net.rcarz.jiraclient.Priority;
import net.rcarz.jiraclient.Project;
import net.rcarz.jiraclient.Resolution;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.Status;
import net.rcarz.jiraclient.TimeTracking;
import net.rcarz.jiraclient.User;
import net.rcarz.jiraclient.Version;
import net.rcarz.jiraclient.Votes;
import net.rcarz.jiraclient.Watches;
import net.rcarz.jiraclient.WorkLog;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Field {
    public static final String ASSIGNEE = "assignee";
    public static final String ATTACHMENT = "attachment";
    public static final String COMMENT = "comment";
    public static final String COMPONENTS = "components";
    public static final String DESCRIPTION = "description";
    public static final String DUE_DATE = "duedate";
    public static final String FIX_VERSIONS = "fixVersions";
    public static final String ISSUE_LINKS = "issuelinks";
    public static final String ISSUE_TYPE = "issuetype";
    public static final String LABELS = "labels";
    public static final String PRIORITY = "priority";
    public static final String PROJECT = "project";
    public static final String REPORTER = "reporter";
    public static final String RESOLUTION = "resolution";
    public static final String RESOLUTION_DATE = "resolutiondate";
    public static final String STATUS = "status";
    public static final String SUBTASKS = "subtasks";
    public static final String SUMMARY = "summary";
    public static final String TIME_TRACKING = "timetracking";
    public static final String VERSIONS = "versions";
    public static final String VOTES = "votes";
    public static final String WATCHES = "watches";
    public static final String WORKLOG = "worklog";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    private Field() {
    }

    public static boolean getBoolean(Object b) {
        boolean result = false;
        if (b instanceof Boolean) {
            result = (Boolean)b;
        }
        return result;
    }

    public static List<Comment> getComments(Object c, RestClient restclient) {
        List<Comment> results = new ArrayList<Comment>();
        if (c instanceof JSONObject && !((JSONObject)c).isNullObject()) {
            results = Field.getResourceArray(Comment.class, ((Map)c).get("comments"), restclient);
        }
        return results;
    }

    public static List<WorkLog> getWorkLogs(Object c, RestClient restclient) {
        List<WorkLog> results = new ArrayList<WorkLog>();
        if (c instanceof JSONObject && !((JSONObject)c).isNullObject()) {
            results = Field.getResourceArray(WorkLog.class, ((Map)c).get("worklogs"), restclient);
        }
        return results;
    }

    public static Date getDate(Object d) {
        Date result = null;
        if (d instanceof String) {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            result = df.parse((String)d, new ParsePosition(0));
        }
        return result;
    }

    public static int getInteger(Object i) {
        int result = 0;
        if (i instanceof Integer) {
            result = (Integer)i;
        }
        return result;
    }

    public static <TK, TV> Map<TK, TV> getMap(Class<TK> keytype, Class<TV> valtype, Object m) {
        HashMap result = new HashMap();
        if (m instanceof JSONObject && !((JSONObject)m).isNullObject()) {
            for (Object k : ((Map)m).keySet()) {
                Object v = ((Map)m).get(k);
                if (k.getClass() != keytype || v.getClass() != valtype) continue;
                result.put(k, v);
            }
        }
        return result;
    }

    public static <T extends Resource> T getResource(Class<T> type, Object r, RestClient restclient) {
        Resource result = null;
        if (r instanceof JSONObject && !((JSONObject)r).isNullObject()) {
            if (type == Attachment.class) {
                result = new Attachment(restclient, (JSONObject)r);
            } else if (type == Comment.class) {
                result = new Comment(restclient, (JSONObject)r);
            } else if (type == Component.class) {
                result = new Component(restclient, (JSONObject)r);
            } else if (type == CustomFieldOption.class) {
                result = new CustomFieldOption(restclient, (JSONObject)r);
            } else if (type == Issue.class) {
                result = new Issue(restclient, (JSONObject)r);
            } else if (type == IssueLink.class) {
                result = new IssueLink(restclient, (JSONObject)r);
            } else if (type == IssueType.class) {
                result = new IssueType(restclient, (JSONObject)r);
            } else if (type == LinkType.class) {
                result = new LinkType(restclient, (JSONObject)r);
            } else if (type == Priority.class) {
                result = new Priority(restclient, (JSONObject)r);
            } else if (type == Project.class) {
                result = new Project(restclient, (JSONObject)r);
            } else if (type == Resolution.class) {
                result = new Resolution(restclient, (JSONObject)r);
            } else if (type == Status.class) {
                result = new Status(restclient, (JSONObject)r);
            } else if (type == User.class) {
                result = new User(restclient, (JSONObject)r);
            } else if (type == Version.class) {
                result = new Version(restclient, (JSONObject)r);
            } else if (type == Votes.class) {
                result = new Votes(restclient, (JSONObject)r);
            } else if (type == Watches.class) {
                result = new Watches(restclient, (JSONObject)r);
            } else if (type == WorkLog.class) {
                result = new WorkLog(restclient, (JSONObject)r);
            }
        }
        return (T)result;
    }

    public static String getString(Object s) {
        String result = null;
        if (s instanceof String) {
            result = (String)s;
        }
        return result;
    }

    public static List<String> getStringArray(Object sa) {
        ArrayList<String> results = new ArrayList<String>();
        if (sa instanceof JSONArray) {
            for (Object s : (JSONArray)sa) {
                if (!(s instanceof String)) continue;
                results.add((String)s);
            }
        }
        return results;
    }

    public static <T extends Resource> List<T> getResourceArray(Class<T> type, Object ra, RestClient restclient) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        if (ra instanceof JSONArray) {
            for (Object v : (JSONArray)ra) {
                if (type == Attachment.class) {
                    results.add(new Attachment(restclient, (JSONObject)v));
                    continue;
                }
                if (type == Comment.class) {
                    results.add(new Comment(restclient, (JSONObject)v));
                    continue;
                }
                if (type == Component.class) {
                    results.add(new Component(restclient, (JSONObject)v));
                    continue;
                }
                if (type == CustomFieldOption.class) {
                    results.add(new CustomFieldOption(restclient, (JSONObject)v));
                    continue;
                }
                if (type == Issue.class) {
                    results.add(new Issue(restclient, (JSONObject)v));
                    continue;
                }
                if (type == IssueLink.class) {
                    results.add(new IssueLink(restclient, (JSONObject)v));
                    continue;
                }
                if (type == IssueType.class) {
                    results.add(new IssueType(restclient, (JSONObject)v));
                    continue;
                }
                if (type == LinkType.class) {
                    results.add(new LinkType(restclient, (JSONObject)v));
                    continue;
                }
                if (type == Priority.class) {
                    results.add(new Priority(restclient, (JSONObject)v));
                    continue;
                }
                if (type == Project.class) {
                    results.add(new Project(restclient, (JSONObject)v));
                    continue;
                }
                if (type == Resolution.class) {
                    results.add(new Resolution(restclient, (JSONObject)v));
                    continue;
                }
                if (type == Status.class) {
                    results.add(new Status(restclient, (JSONObject)v));
                    continue;
                }
                if (type == User.class) {
                    results.add(new User(restclient, (JSONObject)v));
                    continue;
                }
                if (type == Version.class) {
                    results.add(new Version(restclient, (JSONObject)v));
                    continue;
                }
                if (type == Votes.class) {
                    results.add(new Votes(restclient, (JSONObject)v));
                    continue;
                }
                if (type == Watches.class) {
                    results.add(new Watches(restclient, (JSONObject)v));
                    continue;
                }
                if (type != WorkLog.class) continue;
                results.add(new WorkLog(restclient, (JSONObject)v));
            }
        }
        return results;
    }

    public static TimeTracking getTimeTracking(Object tt) {
        TimeTracking result = null;
        if (tt instanceof JSONObject && !((JSONObject)tt).isNullObject()) {
            result = new TimeTracking((JSONObject)tt);
        }
        return result;
    }

    public static Meta getFieldMetadata(String name, JSONObject editmeta) throws JiraException {
        if (editmeta.isNullObject() || !editmeta.containsKey((Object)name)) {
            throw new JiraException("Field '" + name + "' does not exist or read-only");
        }
        Map f = (Map)editmeta.get(name);
        Meta m = new Meta();
        m.required = Field.getBoolean(f.get("required"));
        m.name = Field.getString(f.get("name"));
        if (!f.containsKey("schema")) {
            throw new JiraException("Field '" + name + "' is missing schema metadata");
        }
        Map schema = (Map)f.get("schema");
        m.type = Field.getString(schema.get("type"));
        m.items = Field.getString(schema.get("items"));
        m.system = Field.getString(schema.get("system"));
        m.custom = Field.getString(schema.get("custom"));
        m.customId = Field.getInteger(schema.get("customId"));
        return m;
    }

    public static Date toDate(Object value) {
        if (value instanceof Date || value == null) {
            return (Date)value;
        }
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        return df.parse(value.toString(), new ParsePosition(0));
    }

    public static JSONArray toArray(Iterable iter, String type) throws JiraException {
        JSONArray result = new JSONArray();
        if (type == null) {
            throw new JiraException("Array field metadata is missing item type");
        }
        for (Object val : iter) {
            if (type.equals("component") || type.equals("group") || type.equals("user") || type.equals("version")) {
                JSONObject json = new JSONObject();
                json.put((Object)"name", (Object)val.toString());
                result.add((Object)json.toString());
                continue;
            }
            if (!type.equals("string")) continue;
            result.add((Object)val.toString());
        }
        return result;
    }

    public static Object toJson(String name, Object value, JSONObject editmeta) throws JiraException, UnsupportedOperationException {
        if (value == null) {
            return null;
        }
        Meta m = Field.getFieldMetadata(name, editmeta);
        if (m.type == null) {
            throw new JiraException("Field metadata is missing a type");
        }
        if (m.type.equals("array")) {
            if (!(value instanceof Iterable)) {
                throw new JiraException("Field expects an Iterable value");
            }
            return Field.toArray((Iterable)value, m.items);
        }
        if (m.type.equals("date")) {
            Date d = Field.toDate(value);
            if (d == null) {
                throw new JiraException("Field expects a date value or format is invalid");
            }
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            return df.format(d);
        }
        if (m.type.equals(ISSUE_TYPE) || m.type.equals(PRIORITY) || m.type.equals("user") || m.type.equals(RESOLUTION)) {
            JSONObject json = new JSONObject();
            json.put((Object)"name", (Object)value.toString());
            return json.toString();
        }
        if (m.type.equals(PROJECT) || m.type.equals("issuelink")) {
            JSONObject json = new JSONObject();
            json.put((Object)"key", (Object)value.toString());
            return json.toString();
        }
        if (m.type.equals("string")) {
            if (value instanceof Map) {
                return Field.toJsonMap((Map)value);
            }
            return value.toString();
        }
        throw new UnsupportedOperationException(m.type + " is not a supported field type");
    }

    public static Object toJsonMap(Map map) {
        JSONObject json = new JSONObject();
        for (Object k : map.keySet()) {
            json.put(k, map.get(k));
        }
        return json.toString();
    }

    public static final class Meta {
        public boolean required;
        public String type;
        public String items;
        public String name;
        public String system;
        public String custom;
        public int customId;
    }
}

