/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.net.URI;
import net.rcarz.jiraclient.ICredentials;
import net.rcarz.jiraclient.Issue;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.RestClient;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

public class JiraClient {
    private RestClient restclient = null;
    private String username = null;

    public JiraClient(String uri) {
        this(uri, null);
    }

    public JiraClient(String uri, ICredentials creds) {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        this.restclient = new RestClient((HttpClient)httpclient, creds, URI.create(uri));
        if (creds != null) {
            this.username = creds.getLogonName();
        }
    }

    public Issue.FluentCreate createIssue(String project, String issueType) throws JiraException {
        return Issue.create(this.restclient, project, issueType);
    }

    public Issue getIssue(String key) throws JiraException {
        return Issue.get(this.restclient, key);
    }

    public Issue.SearchResult searchIssues(String jql) throws JiraException {
        return Issue.search(this.restclient, jql);
    }

    public RestClient getRestClient() {
        return this.restclient;
    }

    public String getSelf() {
        return this.username;
    }
}

