/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import net.rcarz.jiraclient.ICredentials;
import net.rcarz.jiraclient.RestException;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestClient {
    private HttpClient httpClient = null;
    private ICredentials creds = null;
    private URI uri = null;

    public RestClient(HttpClient httpclient, URI uri) {
        this(httpclient, null, uri);
    }

    public RestClient(HttpClient httpclient, ICredentials creds, URI uri) {
        this.httpClient = httpclient;
        this.creds = creds;
        this.uri = uri;
    }

    public URI buildURI(String path) throws URISyntaxException {
        return this.buildURI(path, null);
    }

    public URI buildURI(String path, Map<String, String> params) throws URISyntaxException {
        URIBuilder ub = new URIBuilder(this.uri);
        ub.setPath(ub.getPath() + path);
        if (params != null) {
            for (Map.Entry<String, String> ent : params.entrySet()) {
                ub.addParameter(ent.getKey(), ent.getValue());
            }
        }
        return ub.build();
    }

    private JSON request(HttpRequestBase req) throws RestException, IOException {
        StatusLine sl;
        req.addHeader("Accept", "application/json");
        if (this.creds != null) {
            this.creds.authenticate((HttpRequest)req);
        }
        HttpResponse resp = this.httpClient.execute((HttpUriRequest)req);
        HttpEntity ent = resp.getEntity();
        StringBuilder result = new StringBuilder();
        if (ent != null) {
            BufferedReader br = new BufferedReader(new InputStreamReader(ent.getContent()));
            String line = "";
            while ((line = br.readLine()) != null) {
                result.append(line);
            }
        }
        if ((sl = resp.getStatusLine()).getStatusCode() >= 300) {
            throw new RestException(sl.getReasonPhrase(), sl.getStatusCode(), result.toString());
        }
        return result.length() > 0 ? JSONSerializer.toJSON((Object)result.toString()) : null;
    }

    private JSON request(HttpEntityEnclosingRequestBase req, String payload) throws RestException, IOException {
        if (payload != null) {
            StringEntity ent = null;
            try {
                ent = new StringEntity(payload, "UTF-8");
                ent.setContentType("application/json");
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
            req.addHeader("Content-Type", "application/json");
            req.setEntity((HttpEntity)ent);
        }
        return this.request((HttpRequestBase)req);
    }

    private JSON request(HttpEntityEnclosingRequestBase req, JSON payload) throws RestException, IOException {
        return this.request(req, payload != null ? payload.toString() : null);
    }

    public JSON delete(URI uri) throws RestException, IOException {
        return this.request((HttpRequestBase)new HttpDelete(uri));
    }

    public JSON delete(String path) throws RestException, IOException, URISyntaxException {
        return this.delete(this.buildURI(path));
    }

    public JSON get(URI uri) throws RestException, IOException {
        return this.request((HttpRequestBase)new HttpGet(uri));
    }

    public JSON get(String path) throws RestException, IOException, URISyntaxException {
        return this.get(this.buildURI(path));
    }

    public JSON post(URI uri, JSON payload) throws RestException, IOException {
        return this.request((HttpEntityEnclosingRequestBase)new HttpPost(uri), payload);
    }

    public JSON post(URI uri, String payload) throws RestException, IOException {
        String quoted = payload != null ? String.format("\"%s\"", payload) : null;
        return this.request((HttpEntityEnclosingRequestBase)new HttpPost(uri), quoted);
    }

    public JSON post(String path, JSON payload) throws RestException, IOException, URISyntaxException {
        return this.post(this.buildURI(path), payload);
    }

    public JSON put(URI uri, JSON payload) throws RestException, IOException {
        return this.request((HttpEntityEnclosingRequestBase)new HttpPut(uri), payload);
    }

    public JSON put(String path, JSON payload) throws RestException, IOException, URISyntaxException {
        return this.put(this.buildURI(path), payload);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

