/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public final class Status
extends Resource {
    private String description = null;
    private String iconUrl = null;
    private String name = null;

    protected Status(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get("self"));
        this.id = Field.getString(map.get("id"));
        this.description = Field.getString(map.get("description"));
        this.iconUrl = Field.getString(map.get("iconUrl"));
        this.name = Field.getString(map.get("name"));
    }

    public static Status get(RestClient restclient, String id) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get("/rest/api/2/status/" + id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve status " + id, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Status(restclient, (JSONObject)result);
    }

    public String toString() {
        return this.getName();
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }
}

