/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public final class Watches
extends Resource {
    private String name = null;
    private int watchCount = 0;
    private boolean isWatching = false;

    protected Watches(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get("self"));
        this.id = Field.getString(map.get("id"));
        this.watchCount = Field.getInteger(map.get("watchCount"));
        this.isWatching = Field.getBoolean(map.get("isWatching"));
    }

    public static Watches get(RestClient restclient, String issue) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get("/rest/api/2/issue/" + issue + "/watches");
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve watches for issue " + issue, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Watches(restclient, (JSONObject)result);
    }

    public String toString() {
        return Integer.toString(this.getWatchCount());
    }

    public int getWatchCount() {
        return this.watchCount;
    }

    public boolean isWatching() {
        return this.isWatching;
    }
}

