/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.rcarz.jiraclient.Attachment;
import net.rcarz.jiraclient.ChangeLog;
import net.rcarz.jiraclient.Comment;
import net.rcarz.jiraclient.Component;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.IssueLink;
import net.rcarz.jiraclient.IssueType;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Priority;
import net.rcarz.jiraclient.Project;
import net.rcarz.jiraclient.Resolution;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.Status;
import net.rcarz.jiraclient.TimeTracking;
import net.rcarz.jiraclient.User;
import net.rcarz.jiraclient.Version;
import net.rcarz.jiraclient.Votes;
import net.rcarz.jiraclient.Watches;
import net.rcarz.jiraclient.WorkLog;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Issue
extends Resource {
    private String key = null;
    private Map fields = null;
    private User assignee = null;
    private List<Attachment> attachments = null;
    private ChangeLog changeLog = null;
    private List<Comment> comments = null;
    private List<Component> components = null;
    private String description = null;
    private Date dueDate = null;
    private List<Version> fixVersions = null;
    private List<IssueLink> issueLinks = null;
    private IssueType issueType = null;
    private List<String> labels = null;
    private Issue parent = null;
    private Priority priority = null;
    private Project project = null;
    private User reporter = null;
    private Resolution resolution = null;
    private Date resolutionDate = null;
    private Status status = null;
    private List<Issue> subtasks = null;
    private String summary = null;
    private TimeTracking timeTracking = null;
    private List<Version> versions = null;
    private Votes votes = null;
    private Watches watches = null;
    private List<WorkLog> workLogs = null;
    private Integer timeEstimate = null;
    private Integer timeSpent = null;

    protected Issue(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.id = Field.getString(map.get("id"));
        this.self = Field.getString(map.get("self"));
        this.key = Field.getString(map.get("key"));
        this.fields = (Map)map.get("fields");
        this.assignee = Field.getResource(User.class, this.fields.get("assignee"), this.restclient);
        this.attachments = Field.getResourceArray(Attachment.class, this.fields.get("attachment"), this.restclient);
        this.changeLog = Field.getResource(ChangeLog.class, map.get("changelog"), this.restclient);
        this.comments = Field.getComments(this.fields.get("comment"), this.restclient);
        this.components = Field.getResourceArray(Component.class, this.fields.get("components"), this.restclient);
        this.description = Field.getString(this.fields.get("description"));
        this.dueDate = Field.getDate(this.fields.get("duedate"));
        this.fixVersions = Field.getResourceArray(Version.class, this.fields.get("fixVersions"), this.restclient);
        this.issueLinks = Field.getResourceArray(IssueLink.class, this.fields.get("issuelinks"), this.restclient);
        this.issueType = Field.getResource(IssueType.class, this.fields.get("issuetype"), this.restclient);
        this.labels = Field.getStringArray(this.fields.get("labels"));
        this.parent = Field.getResource(Issue.class, this.fields.get("parent"), this.restclient);
        this.priority = Field.getResource(Priority.class, this.fields.get("priority"), this.restclient);
        this.project = Field.getResource(Project.class, this.fields.get("project"), this.restclient);
        this.reporter = Field.getResource(User.class, this.fields.get("reporter"), this.restclient);
        this.resolution = Field.getResource(Resolution.class, this.fields.get("resolution"), this.restclient);
        this.resolutionDate = Field.getDate(this.fields.get("resolutiondate"));
        this.status = Field.getResource(Status.class, this.fields.get("status"), this.restclient);
        this.subtasks = Field.getResourceArray(Issue.class, this.fields.get("subtasks"), this.restclient);
        this.summary = Field.getString(this.fields.get("summary"));
        this.timeTracking = Field.getTimeTracking(this.fields.get("timetracking"));
        this.versions = Field.getResourceArray(Version.class, this.fields.get("versions"), this.restclient);
        this.votes = Field.getResource(Votes.class, this.fields.get("votes"), this.restclient);
        this.watches = Field.getResource(Watches.class, this.fields.get("watches"), this.restclient);
        this.workLogs = Field.getWorkLogs(this.fields.get("worklog"), this.restclient);
        this.timeEstimate = Field.getInteger(this.fields.get("timeestimate"));
        this.timeSpent = Field.getInteger(this.fields.get("timespent"));
    }

    private static String getRestUri(String key) {
        return Issue.getBaseUri() + "issue/" + (key != null ? key : "");
    }

    public static JSONObject getCreateMetadata(RestClient restclient, String project, String issueType) throws JiraException {
        final String pval = project;
        final String itval = issueType;
        JSON result = null;
        try {
            URI createuri = restclient.buildURI(Issue.getBaseUri() + "issue/createmeta", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("expand", "projects.issuetypes.fields");
                    this.put("projectKeys", pval);
                    this.put("issuetypeNames", itval);
                }
            });
            result = restclient.get(createuri);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve issue metadata", ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        JSONObject jo = (JSONObject)result;
        if (jo.isNullObject() || !jo.containsKey((Object)"projects") || !(jo.get("projects") instanceof JSONArray)) {
            throw new JiraException("Create metadata is malformed");
        }
        List<Project> projects = Field.getResourceArray(Project.class, (JSONArray)jo.get("projects"), restclient);
        if (projects.isEmpty() || projects.get(0).getIssueTypes().isEmpty()) {
            throw new JiraException("Project '" + project + "'  or issue type '" + issueType + "' missing from create metadata. Do you have enough permissions?");
        }
        return projects.get(0).getIssueTypes().get(0).getFields();
    }

    private JSONObject getEditMetadata() throws JiraException {
        JSON result = null;
        try {
            result = this.restclient.get(Issue.getRestUri(this.key) + "/editmeta");
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve issue metadata", ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        JSONObject jo = (JSONObject)result;
        if (jo.isNullObject() || !jo.containsKey((Object)"fields") || !(jo.get("fields") instanceof JSONObject)) {
            throw new JiraException("Edit metadata is malformed");
        }
        return (JSONObject)jo.get("fields");
    }

    private JSONArray getTransitions() throws JiraException {
        JSON result = null;
        try {
            URI transuri = this.restclient.buildURI(Issue.getRestUri(this.key) + "/transitions", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("expand", "transitions.fields");
                }
            });
            result = this.restclient.get(transuri);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve transitions", ex);
        }
        JSONObject jo = (JSONObject)result;
        if (jo.isNullObject() || !jo.containsKey((Object)"transitions") || !(jo.get("transitions") instanceof JSONArray)) {
            throw new JiraException("Transition metadata is missing from jos");
        }
        return (JSONArray)jo.get("transitions");
    }

    public void addAttachment(File file) throws JiraException {
        try {
            this.restclient.post(Issue.getRestUri(this.key) + "/attachments", file);
        }
        catch (Exception ex) {
            throw new JiraException("Failed add attachment to issue " + this.key, ex);
        }
    }

    public void addComment(String body) throws JiraException {
        this.addComment(body, null, null);
    }

    public void addComment(String body, String visType, String visName) throws JiraException {
        JSONObject req = new JSONObject();
        req.put((Object)"body", (Object)body);
        if (visType != null && visName != null) {
            JSONObject vis = new JSONObject();
            vis.put((Object)"type", (Object)visType);
            vis.put((Object)"value", (Object)visName);
            req.put((Object)"visibility", (Object)vis);
        }
        try {
            this.restclient.post(Issue.getRestUri(this.key) + "/comment", (JSON)req);
        }
        catch (Exception ex) {
            throw new JiraException("Failed add comment to issue " + this.key, ex);
        }
    }

    public void link(String issue, String type) throws JiraException {
        this.link(issue, type, null, null, null);
    }

    public void link(String issue, String type, String body) throws JiraException {
        this.link(issue, type, body, null, null);
    }

    public void link(String issue, String type, String body, String visType, String visName) throws JiraException {
        JSONObject req = new JSONObject();
        JSONObject t = new JSONObject();
        t.put((Object)"name", (Object)type);
        req.put((Object)"type", (Object)t);
        JSONObject inward = new JSONObject();
        inward.put((Object)"key", (Object)this.key);
        req.put((Object)"inwardIssue", (Object)inward);
        JSONObject outward = new JSONObject();
        outward.put((Object)"key", (Object)issue);
        req.put((Object)"outwardIssue", (Object)outward);
        if (body != null) {
            JSONObject comment = new JSONObject();
            comment.put((Object)"body", (Object)body);
            if (visType != null && visName != null) {
                JSONObject vis = new JSONObject();
                vis.put((Object)"type", (Object)visType);
                vis.put((Object)"value", (Object)visName);
                comment.put((Object)"visibility", (Object)vis);
            }
            req.put((Object)"comment", (Object)comment);
        }
        try {
            this.restclient.post(Issue.getBaseUri() + "issueLink", (JSON)req);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to link issue " + this.key + " with issue " + issue, ex);
        }
    }

    public static FluentCreate create(RestClient restclient, String project, String issueType) throws JiraException {
        FluentCreate fc = new FluentCreate(restclient, Issue.getCreateMetadata(restclient, project, issueType));
        return fc.field("project", project).field("issuetype", issueType);
    }

    public FluentCreate createSubtask() throws JiraException {
        return Issue.create(this.restclient, this.getProject().getKey(), "Sub-task").field("parent", this.getKey());
    }

    private static JSONObject realGet(RestClient restclient, String key, Map<String, String> queryParams) throws JiraException {
        JSON result = null;
        try {
            URI uri = restclient.buildURI(Issue.getBaseUri() + "issue/" + key, queryParams);
            result = restclient.get(uri);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve issue " + key, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return (JSONObject)result;
    }

    public static Issue get(RestClient restclient, String key) throws JiraException {
        return new Issue(restclient, Issue.realGet(restclient, key, new HashMap<String, String>()));
    }

    public static Issue get(RestClient restclient, String key, final String includedFields) throws JiraException {
        HashMap<String, String> queryParams = new HashMap<String, String>(){
            {
                this.put("fields", includedFields);
            }
        };
        return new Issue(restclient, Issue.realGet(restclient, key, (Map<String, String>)queryParams));
    }

    public static Issue get(RestClient restclient, String key, final String includedFields, final String expand) throws JiraException {
        HashMap<String, String> queryParams = new HashMap<String, String>(){
            {
                this.put("fields", includedFields);
                if (expand != null) {
                    this.put("expand", expand);
                }
            }
        };
        return new Issue(restclient, Issue.realGet(restclient, key, (Map<String, String>)queryParams));
    }

    public static SearchResult search(RestClient restclient, String jql) throws JiraException {
        return Issue.search(restclient, jql, null, null);
    }

    public static SearchResult search(RestClient restclient, String jql, String includedFields, Integer maxResults) throws JiraException {
        return Issue.search(restclient, jql, includedFields, maxResults, null);
    }

    public static SearchResult search(RestClient restclient, String jql, String includedFields, Integer maxResults, Integer startAt) throws JiraException {
        final String j = jql;
        JSON result = null;
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>(){
                {
                    this.put("jql", j);
                }
            };
            if (maxResults != null) {
                queryParams.put("maxResults", String.valueOf(maxResults));
            }
            if (includedFields != null) {
                queryParams.put("fields", includedFields);
            }
            if (startAt != null) {
                queryParams.put("startAt", String.valueOf(startAt));
            }
            URI searchUri = restclient.buildURI(Issue.getBaseUri() + "search", (Map<String, String>)queryParams);
            result = restclient.get(searchUri);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to search issues", ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        SearchResult sr = new SearchResult();
        Map map = (Map)result;
        sr.start = Field.getInteger(map.get("startAt"));
        sr.max = Field.getInteger(map.get("maxResults"));
        sr.total = Field.getInteger(map.get("total"));
        sr.issues = Field.getResourceArray(Issue.class, map.get("issues"), restclient);
        return sr;
    }

    public void refresh() throws JiraException {
        JSONObject result = Issue.realGet(this.restclient, this.key, new HashMap<String, String>());
        this.deserialise(result);
    }

    public void refresh(final String includedFields) throws JiraException {
        HashMap<String, String> queryParams = new HashMap<String, String>(){
            {
                this.put("fields", includedFields);
            }
        };
        JSONObject result = Issue.realGet(this.restclient, this.key, (Map<String, String>)queryParams);
        this.deserialise(result);
    }

    public Object getField(String name) {
        return this.fields != null ? this.fields.get(name) : null;
    }

    public FluentTransition transition() throws JiraException {
        return new FluentTransition(this.getTransitions());
    }

    public FluentUpdate update() throws JiraException {
        return new FluentUpdate(this.getEditMetadata());
    }

    public void vote() throws JiraException {
        try {
            this.restclient.post(Issue.getRestUri(this.key) + "/votes");
        }
        catch (Exception ex) {
            throw new JiraException("Failed to vote on issue " + this.key, ex);
        }
    }

    public void unvote() throws JiraException {
        try {
            this.restclient.delete(Issue.getRestUri(this.key) + "/votes");
        }
        catch (Exception ex) {
            throw new JiraException("Failed to unvote on issue " + this.key, ex);
        }
    }

    public void addWatcher(String username) throws JiraException {
        try {
            URI uri = this.restclient.buildURI(Issue.getRestUri(this.key) + "/watchers");
            this.restclient.post(uri, username);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to add watcher (" + username + ") to issue " + this.key, ex);
        }
    }

    public void deleteWatcher(String username) throws JiraException {
        try {
            final String u = username;
            URI uri = this.restclient.buildURI(Issue.getRestUri(this.key) + "/watchers", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("username", u);
                }
            });
            this.restclient.delete(uri);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to remove watch (" + username + ") from issue " + this.key, ex);
        }
    }

    public String toString() {
        return this.getKey();
    }

    public ChangeLog getChangeLog() {
        return this.changeLog;
    }

    public String getKey() {
        return this.key;
    }

    public User getAssignee() {
        return this.assignee;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public List<Version> getFixVersions() {
        return this.fixVersions;
    }

    public List<IssueLink> getIssueLinks() {
        return this.issueLinks;
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public Issue getParent() {
        return this.parent;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Project getProject() {
        return this.project;
    }

    public User getReporter() {
        return this.reporter;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public Date getResolutionDate() {
        return this.resolutionDate;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<Issue> getSubtasks() {
        return this.subtasks;
    }

    public String getSummary() {
        return this.summary;
    }

    public TimeTracking getTimeTracking() {
        return this.timeTracking;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public Votes getVotes() {
        return this.votes;
    }

    public Watches getWatches() {
        return this.watches;
    }

    public List<WorkLog> getWorkLogs() {
        return this.workLogs;
    }

    public List<WorkLog> getAllWorkLogs() throws JiraException {
        JSONObject obj;
        try {
            URI uri = this.restclient.buildURI(Issue.getRestUri(this.key) + "/worklog");
            JSON json = this.restclient.get(uri);
            obj = (JSONObject)json;
        }
        catch (Exception ex) {
            throw new JiraException("Failed to get worklog for issue " + this.key, ex);
        }
        return Field.getWorkLogs(obj, this.restclient);
    }

    public Integer getTimeSpent() {
        return this.timeSpent;
    }

    public Integer getTimeEstimate() {
        return this.timeEstimate;
    }

    public static class SearchResult {
        public int start = 0;
        public int max = 0;
        public int total = 0;
        public List<Issue> issues = null;
    }

    public final class FluentTransition {
        Map<String, Object> fields = new HashMap<String, Object>();
        JSONArray transitions = null;

        private FluentTransition(JSONArray transitions) {
            this.transitions = transitions;
        }

        private JSONObject getTransition(String id, boolean name) throws JiraException {
            JSONObject result = null;
            for (Object item : this.transitions) {
                if (!(item instanceof JSONObject) || !((JSONObject)item).containsKey((Object)"id")) {
                    throw new JiraException("Transition metadata is malformed");
                }
                JSONObject t = (JSONObject)item;
                if ((name || !Field.getString(t.get("id")).equals(id)) && (!name || !Field.getString(t.get("name")).equals(id))) continue;
                result = t;
                break;
            }
            if (result == null) {
                throw new JiraException("Transition was not found in metadata");
            }
            return result;
        }

        private void realExecute(JSONObject trans) throws JiraException {
            if (trans.isNullObject() || !trans.containsKey((Object)"fields") || !(trans.get("fields") instanceof JSONObject)) {
                throw new JiraException("Transition metadata is missing fields");
            }
            JSONObject editmeta = (JSONObject)trans.get("fields");
            JSONObject fieldmap = new JSONObject();
            for (Map.Entry<String, Object> ent : this.fields.entrySet()) {
                Object newval = Field.toJson(ent.getKey(), ent.getValue(), editmeta);
                fieldmap.put((Object)ent.getKey(), newval);
            }
            JSONObject req = new JSONObject();
            if (fieldmap.size() > 0) {
                req.put((Object)"fields", (Object)fieldmap);
            }
            JSONObject t = new JSONObject();
            t.put((Object)"id", (Object)Field.getString(trans.get("id")));
            req.put((Object)"transition", (Object)t);
            try {
                Issue.this.restclient.post(Issue.getRestUri(Issue.this.key) + "/transitions", (JSON)req);
            }
            catch (Exception ex) {
                throw new JiraException("Failed to transition issue " + Issue.this.key, ex);
            }
        }

        public void execute(int id) throws JiraException {
            this.realExecute(this.getTransition(Integer.toString(id), false));
        }

        public void execute(String name) throws JiraException {
            this.realExecute(this.getTransition(name, true));
        }

        public FluentTransition field(String name, Object value) {
            this.fields.put(name, value);
            return this;
        }
    }

    public final class FluentUpdate {
        Map<String, Object> fields = new HashMap<String, Object>();
        Map<String, List> fieldOpers = new HashMap<String, List>();
        JSONObject editmeta = null;

        private FluentUpdate(JSONObject editmeta) {
            this.editmeta = editmeta;
        }

        public void execute() throws JiraException {
            Object newval;
            JSONObject fieldmap = new JSONObject();
            JSONObject updatemap = new JSONObject();
            if (this.fields.size() == 0 && this.fieldOpers.size() == 0) {
                throw new JiraException("No fields were given for update");
            }
            for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                newval = Field.toJson(entry.getKey(), entry.getValue(), this.editmeta);
                fieldmap.put((Object)entry.getKey(), newval);
            }
            for (Map.Entry<String, Object> entry : this.fieldOpers.entrySet()) {
                newval = Field.toJson(entry.getKey(), entry.getValue(), this.editmeta);
                updatemap.put((Object)entry.getKey(), newval);
            }
            JSONObject req = new JSONObject();
            if (fieldmap.size() > 0) {
                req.put((Object)"fields", (Object)fieldmap);
            }
            if (updatemap.size() > 0) {
                req.put((Object)"update", (Object)updatemap);
            }
            try {
                Issue.this.restclient.put(Issue.getRestUri(Issue.this.key), (JSON)req);
            }
            catch (Exception exception) {
                throw new JiraException("Failed to update issue " + Issue.this.key, exception);
            }
        }

        public FluentUpdate field(String name, Object value) {
            this.fields.put(name, value);
            return this;
        }

        private FluentUpdate fieldOperation(String oper, String name, Object value) {
            if (!this.fieldOpers.containsKey(name)) {
                this.fieldOpers.put(name, new ArrayList());
            }
            this.fieldOpers.get(name).add(new Field.Operation(oper, value));
            return this;
        }

        public FluentUpdate fieldAdd(String name, Object value) {
            return this.fieldOperation("add", name, value);
        }

        public FluentUpdate fieldRemove(String name, Object value) {
            return this.fieldOperation("remove", name, value);
        }
    }

    public static final class FluentCreate {
        Map<String, Object> fields = new HashMap<String, Object>();
        RestClient restclient = null;
        JSONObject createmeta = null;

        private FluentCreate(RestClient restclient, JSONObject createmeta) {
            this.restclient = restclient;
            this.createmeta = createmeta;
        }

        public Issue execute() throws JiraException {
            return this.executeCreate(null);
        }

        public Issue execute(String includedFields) throws JiraException {
            return this.executeCreate(includedFields);
        }

        private Issue executeCreate(String includedFields) throws JiraException {
            JSONObject fieldmap = new JSONObject();
            if (this.fields.size() == 0) {
                throw new JiraException("No fields were given for create");
            }
            for (Map.Entry<String, Object> ent : this.fields.entrySet()) {
                Object newval = Field.toJson(ent.getKey(), ent.getValue(), this.createmeta);
                fieldmap.put((Object)ent.getKey(), newval);
            }
            JSONObject req = new JSONObject();
            req.put((Object)"fields", (Object)fieldmap);
            JSON result = null;
            try {
                result = this.restclient.post(Issue.getRestUri(null), (JSON)req);
            }
            catch (Exception ex) {
                throw new JiraException("Failed to create issue", ex);
            }
            if (!(result instanceof JSONObject && ((JSONObject)result).containsKey((Object)"key") && ((JSONObject)result).get("key") instanceof String)) {
                throw new JiraException("Unexpected result on create issue");
            }
            if (includedFields != null) {
                return Issue.get(this.restclient, (String)((JSONObject)result).get("key"), includedFields);
            }
            return Issue.get(this.restclient, (String)((JSONObject)result).get("key"));
        }

        public FluentCreate field(String name, Object value) {
            this.fields.put(name, value);
            return this;
        }
    }
}

