/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public class Votes
extends Resource {
    private String name = null;
    private int votes = 0;
    private boolean hasVoted = false;

    protected Votes(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get("self"));
        this.id = Field.getString(map.get("id"));
        this.votes = Field.getInteger(map.get("votes"));
        this.hasVoted = Field.getBoolean(map.get("hasVoted"));
    }

    public static Votes get(RestClient restclient, String issue) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get(Votes.getBaseUri() + "issue/" + issue + "/votes");
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve votes for issue " + issue, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Votes(restclient, (JSONObject)result);
    }

    public String toString() {
        return Integer.toString(this.getVotes());
    }

    public int getVotes() {
        return this.votes;
    }

    public boolean hasVoted() {
        return this.hasVoted;
    }
}

