/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient.greenhopper;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.greenhopper.Epic;
import net.rcarz.jiraclient.greenhopper.GreenHopperField;
import net.rcarz.jiraclient.greenhopper.Marker;
import net.rcarz.jiraclient.greenhopper.RapidView;
import net.rcarz.jiraclient.greenhopper.RapidViewProject;
import net.rcarz.jiraclient.greenhopper.RapidViewVersion;
import net.rcarz.jiraclient.greenhopper.Sprint;
import net.rcarz.jiraclient.greenhopper.SprintIssue;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Backlog {
    private RestClient restclient = null;
    private List<SprintIssue> issues = null;
    private List<SprintIssue> backlogIssues = null;
    private int rankCustomFieldId = 0;
    private List<Sprint> sprints = null;
    private List<RapidViewProject> projects = null;
    private List<Marker> markers = null;
    private List<Epic> epics = null;
    private boolean canEditEpics = false;
    private boolean canManageSprints = false;
    private boolean maxIssuesExceeded = false;
    private int queryResultLimit = 0;
    private Map<String, List<RapidViewVersion>> versionsPerProject = null;

    protected Backlog(RestClient restclient, JSONObject json) {
        this.restclient = restclient;
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject verData;
        JSONObject map = json;
        this.issues = GreenHopperField.getResourceArray(SprintIssue.class, map.get("issues"), this.restclient);
        this.rankCustomFieldId = Field.getInteger(map.get("rankCustomFieldId"));
        this.sprints = GreenHopperField.getResourceArray(Sprint.class, map.get("sprints"), this.restclient);
        this.projects = GreenHopperField.getResourceArray(RapidViewProject.class, map.get("projects"), this.restclient);
        this.markers = GreenHopperField.getResourceArray(Marker.class, map.get("markers"), this.restclient);
        this.canManageSprints = Field.getBoolean(map.get("canManageSprints"));
        this.maxIssuesExceeded = Field.getBoolean(map.get("maxIssuesExceeded"));
        this.queryResultLimit = Field.getInteger(map.get("queryResultLimit"));
        if (map.containsKey("epicData") && map.get("epicData") instanceof JSONObject) {
            Map epicData = (Map)map.get("epicData");
            this.epics = GreenHopperField.getResourceArray(Epic.class, epicData.get("epics"), this.restclient);
            this.canEditEpics = Field.getBoolean(epicData.get("canEditEpics"));
        }
        if (map.containsKey("versionData") && map.get("versionData") instanceof JSONObject && (verData = (JSONObject)map.get("versionData")).containsKey("versionsPerProject") && verData.get("versionsPerProject") instanceof JSONObject) {
            Map verMap = (Map)verData.get("versionsPerProject");
            this.versionsPerProject = new HashMap<String, List<RapidViewVersion>>();
            for (Map.Entry entry : verMap.entrySet()) {
                if (!(entry.getValue() instanceof JSONArray)) continue;
                ArrayList<RapidViewVersion> versions = new ArrayList<RapidViewVersion>();
                for (Object item : (JSONArray)entry.getValue()) {
                    if (!(item instanceof JSONObject)) continue;
                    RapidViewVersion ver = new RapidViewVersion(this.restclient, (JSONObject)item);
                    versions.add(ver);
                }
                this.versionsPerProject.put((String)entry.getKey(), (List<RapidViewVersion>)versions);
            }
        }
        for (SprintIssue issue : this.issues) {
            boolean addedToSprint = false;
            for (Sprint sprint : this.sprints) {
                if (!sprint.getIssuesIds().contains(issue.getId())) continue;
                sprint.getIssues().add(issue);
                addedToSprint = true;
            }
            if (addedToSprint) continue;
            if (this.backlogIssues == null) {
                this.backlogIssues = new ArrayList<SprintIssue>();
            }
            this.backlogIssues.add(issue);
        }
    }

    public static Backlog get(RestClient restclient, RapidView rv) throws JiraException {
        final int rvId = rv.getId();
        JSON result = null;
        try {
            URI reporturi = restclient.buildURI("/rest/greenhopper/1.0/xboard/plan/backlog/data", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("rapidViewId", Integer.toString(rvId));
                }
            });
            result = restclient.get(reporturi);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve backlog data", ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Backlog(restclient, (JSONObject)result);
    }

    public List<SprintIssue> getIssues() {
        return this.issues;
    }

    public List<SprintIssue> getBacklogIssues() {
        return this.backlogIssues;
    }

    public int getRankCustomFieldId() {
        return this.rankCustomFieldId;
    }

    public List<Sprint> getSprints() {
        return this.sprints;
    }

    public List<RapidViewProject> getProjects() {
        return this.projects;
    }

    public List<Marker> getMarkers() {
        return this.markers;
    }

    public List<Epic> getEpics() {
        return this.epics;
    }

    public boolean canEditEpics() {
        return this.canEditEpics;
    }

    public boolean canManageSprints() {
        return this.canManageSprints;
    }

    public boolean maxIssuesExceeded() {
        return this.maxIssuesExceeded;
    }

    public int queryResultLimit() {
        return this.queryResultLimit;
    }

    public Map<String, List<RapidViewVersion>> getVersionsPerProject() {
        return this.versionsPerProject;
    }
}

