/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.rcarz.jiraclient.Attachment;
import net.rcarz.jiraclient.ChangeLog;
import net.rcarz.jiraclient.ChangeLogEntry;
import net.rcarz.jiraclient.ChangeLogItem;
import net.rcarz.jiraclient.Comment;
import net.rcarz.jiraclient.Component;
import net.rcarz.jiraclient.CustomFieldOption;
import net.rcarz.jiraclient.Issue;
import net.rcarz.jiraclient.IssueLink;
import net.rcarz.jiraclient.IssueType;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.LinkType;
import net.rcarz.jiraclient.Priority;
import net.rcarz.jiraclient.Project;
import net.rcarz.jiraclient.ProjectCategory;
import net.rcarz.jiraclient.RemoteLink;
import net.rcarz.jiraclient.Resolution;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.Security;
import net.rcarz.jiraclient.Status;
import net.rcarz.jiraclient.TimeTracking;
import net.rcarz.jiraclient.Transition;
import net.rcarz.jiraclient.User;
import net.rcarz.jiraclient.Version;
import net.rcarz.jiraclient.Visibility;
import net.rcarz.jiraclient.Votes;
import net.rcarz.jiraclient.Watches;
import net.rcarz.jiraclient.WorkLog;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public final class Field {
    public static final String ASSIGNEE = "assignee";
    public static final String ATTACHMENT = "attachment";
    public static final String CHANGE_LOG = "changelog";
    public static final String CHANGE_LOG_ENTRIES = "histories";
    public static final String CHANGE_LOG_ITEMS = "items";
    public static final String COMMENT = "comment";
    public static final String COMPONENTS = "components";
    public static final String DESCRIPTION = "description";
    public static final String DUE_DATE = "duedate";
    public static final String FIX_VERSIONS = "fixVersions";
    public static final String ISSUE_LINKS = "issuelinks";
    public static final String ISSUE_TYPE = "issuetype";
    public static final String LABELS = "labels";
    public static final String PARENT = "parent";
    public static final String PRIORITY = "priority";
    public static final String PROJECT = "project";
    public static final String REPORTER = "reporter";
    public static final String RESOLUTION = "resolution";
    public static final String RESOLUTION_DATE = "resolutiondate";
    public static final String STATUS = "status";
    public static final String SUBTASKS = "subtasks";
    public static final String SUMMARY = "summary";
    public static final String TIME_TRACKING = "timetracking";
    public static final String VERSIONS = "versions";
    public static final String VOTES = "votes";
    public static final String WATCHES = "watches";
    public static final String WORKLOG = "worklog";
    public static final String TIME_ESTIMATE = "timeestimate";
    public static final String TIME_SPENT = "timespent";
    public static final String CREATED_DATE = "created";
    public static final String UPDATED_DATE = "updated";
    public static final String TRANSITION_TO_STATUS = "to";
    public static final String SECURITY = "security";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    private Field() {
    }

    public static boolean getBoolean(Object b) {
        boolean result = false;
        if (b instanceof Boolean) {
            result = (Boolean)b;
        }
        return result;
    }

    public static List<Comment> getComments(Object c, RestClient restclient, String issueKey) {
        List<Comment> results = new ArrayList<Comment>();
        if (c instanceof JSONObject && !((JSONObject)c).isNullObject()) {
            results = Field.getResourceArray(Comment.class, ((Map)c).get("comments"), restclient, issueKey);
        }
        return results;
    }

    public static List<WorkLog> getWorkLogs(Object c, RestClient restclient) {
        List<WorkLog> results = new ArrayList<WorkLog>();
        if (c instanceof JSONObject && !((JSONObject)c).isNullObject()) {
            results = Field.getResourceArray(WorkLog.class, ((Map)c).get("worklogs"), restclient);
        }
        return results;
    }

    public static List<RemoteLink> getRemoteLinks(Object c, RestClient restclient) {
        List<RemoteLink> results = new ArrayList<RemoteLink>();
        if (c instanceof JSONArray) {
            results = Field.getResourceArray(RemoteLink.class, c, restclient);
        }
        return results;
    }

    public static Date getDate(Object d) {
        Date result = null;
        if (d instanceof String) {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            result = df.parse((String)d, new ParsePosition(0));
        }
        return result;
    }

    public static Date getDateTime(Object d) {
        Date result = null;
        if (d instanceof String) {
            SimpleDateFormat df = new SimpleDateFormat(DATETIME_FORMAT);
            result = df.parse((String)d, new ParsePosition(0));
        }
        return result;
    }

    public static Double getDouble(Object i) {
        Double result = null;
        if (i instanceof Double) {
            result = (Double)i;
        }
        return result;
    }

    public static int getInteger(Object i) {
        int result = 0;
        if (i instanceof Integer) {
            result = (Integer)i;
        }
        return result;
    }

    public static long getLong(Object i) {
        long result = 0L;
        if (i instanceof Long) {
            result = (Long)i;
        } else if (i instanceof Integer) {
            result = ((Integer)i).intValue();
        }
        return result;
    }

    public static <TK, TV> Map<TK, TV> getMap(Class<TK> keytype, Class<TV> valtype, Object m) {
        HashMap result = new HashMap();
        if (m instanceof JSONObject && !((JSONObject)m).isNullObject()) {
            for (Object k : ((Map)m).keySet()) {
                Object v = ((Map)m).get(k);
                if (k.getClass() != keytype || v.getClass() != valtype) continue;
                result.put(k, v);
            }
        }
        return result;
    }

    public static <T extends Resource> T getResource(Class<T> type, Object r, RestClient restclient) {
        return Field.getResource(type, r, restclient, null);
    }

    public static <T extends Resource> T getResource(Class<T> type, Object r, RestClient restclient, String parentId) {
        Resource result = null;
        if (r instanceof JSONObject && !((JSONObject)r).isNullObject()) {
            if (type == Attachment.class) {
                result = new Attachment(restclient, (JSONObject)r);
            } else if (type == ChangeLog.class) {
                result = new ChangeLog(restclient, (JSONObject)r);
            } else if (type == ChangeLogEntry.class) {
                result = new ChangeLogEntry(restclient, (JSONObject)r);
            } else if (type == ChangeLogItem.class) {
                result = new ChangeLogItem(restclient, (JSONObject)r);
            } else if (type == Comment.class) {
                result = new Comment(restclient, (JSONObject)r, parentId);
            } else if (type == Component.class) {
                result = new Component(restclient, (JSONObject)r);
            } else if (type == CustomFieldOption.class) {
                result = new CustomFieldOption(restclient, (JSONObject)r);
            } else if (type == Issue.class) {
                result = new Issue(restclient, (JSONObject)r);
            } else if (type == IssueLink.class) {
                result = new IssueLink(restclient, (JSONObject)r);
            } else if (type == IssueType.class) {
                result = new IssueType(restclient, (JSONObject)r);
            } else if (type == LinkType.class) {
                result = new LinkType(restclient, (JSONObject)r);
            } else if (type == Priority.class) {
                result = new Priority(restclient, (JSONObject)r);
            } else if (type == Project.class) {
                result = new Project(restclient, (JSONObject)r);
            } else if (type == ProjectCategory.class) {
                result = new ProjectCategory(restclient, (JSONObject)r);
            } else if (type == RemoteLink.class) {
                result = new RemoteLink(restclient, (JSONObject)r);
            } else if (type == Resolution.class) {
                result = new Resolution(restclient, (JSONObject)r);
            } else if (type == Status.class) {
                result = new Status(restclient, (JSONObject)r);
            } else if (type == Transition.class) {
                result = new Transition(restclient, (JSONObject)r);
            } else if (type == User.class) {
                result = new User(restclient, (JSONObject)r);
            } else if (type == Visibility.class) {
                result = new Visibility(restclient, (JSONObject)r);
            } else if (type == Version.class) {
                result = new Version(restclient, (JSONObject)r);
            } else if (type == Votes.class) {
                result = new Votes(restclient, (JSONObject)r);
            } else if (type == Watches.class) {
                result = new Watches(restclient, (JSONObject)r);
            } else if (type == WorkLog.class) {
                result = new WorkLog(restclient, (JSONObject)r);
            } else if (type == Security.class) {
                result = new Security(restclient, (JSONObject)r);
            }
        }
        return (T)result;
    }

    public static String getString(Object s) {
        String result = null;
        if (s instanceof String) {
            result = (String)s;
        }
        return result;
    }

    public static List<String> getStringArray(Object sa) {
        ArrayList<String> results = new ArrayList<String>();
        if (sa instanceof JSONArray) {
            for (Object s : (JSONArray)sa) {
                if (!(s instanceof String)) continue;
                results.add((String)s);
            }
        }
        return results;
    }

    public static <T extends Resource> List<T> getResourceArray(Class<T> type, Object ra, RestClient restclient) {
        return Field.getResourceArray(type, ra, restclient, null);
    }

    public static <T extends Resource> List<T> getResourceArray(Class<T> type, Object ra, RestClient restclient, String parentId) {
        ArrayList<Object> results = new ArrayList<Object>();
        if (ra instanceof JSONArray) {
            for (Object v : (JSONArray)ra) {
                Object item = null;
                item = parentId != null ? (Object)Field.getResource(type, v, restclient, parentId) : (Object)Field.getResource(type, v, restclient);
                if (item == null) continue;
                results.add(item);
            }
        }
        return results;
    }

    public static TimeTracking getTimeTracking(Object tt) {
        TimeTracking result = null;
        if (tt instanceof JSONObject && !((JSONObject)tt).isNullObject()) {
            result = new TimeTracking((JSONObject)tt);
        }
        return result;
    }

    public static Meta getFieldMetadata(String name, JSONObject editmeta) throws JiraException {
        if (editmeta.isNullObject() || !editmeta.containsKey((Object)name)) {
            throw new JiraException("Field '" + name + "' does not exist or read-only");
        }
        Map f = (Map)editmeta.get(name);
        Meta m = new Meta();
        m.required = Field.getBoolean(f.get("required"));
        m.name = Field.getString(f.get("name"));
        if (!f.containsKey("schema")) {
            throw new JiraException("Field '" + name + "' is missing schema metadata");
        }
        Map schema = (Map)f.get("schema");
        m.type = Field.getString(schema.get("type"));
        m.items = Field.getString(schema.get(CHANGE_LOG_ITEMS));
        m.system = Field.getString(schema.get("system"));
        m.custom = Field.getString(schema.get("custom"));
        m.customId = Field.getInteger(schema.get("customId"));
        return m;
    }

    public static Date toDate(Object value) {
        if (value instanceof Date || value == null) {
            return (Date)value;
        }
        String dateStr = value.toString();
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        if (dateStr.length() > DATE_FORMAT.length()) {
            df = new SimpleDateFormat(DATETIME_FORMAT);
        }
        return df.parse(dateStr, new ParsePosition(0));
    }

    public static JSONArray toArray(Iterable iter, String type, String custom) throws JiraException {
        JSONArray results = new JSONArray();
        if (type == null) {
            throw new JiraException("Array field metadata is missing item type");
        }
        for (Object val : iter) {
            Operation oper = null;
            Object realValue = null;
            Object realResult = null;
            if (val instanceof Operation) {
                oper = (Operation)val;
                realValue = oper.value;
            } else {
                realValue = val;
            }
            if (type.equals("component") || type.equals("group") || type.equals("user") || type.equals("version")) {
                JSONObject itemMap = new JSONObject();
                if (realValue instanceof ValueTuple) {
                    ValueTuple tuple = (ValueTuple)realValue;
                    itemMap.put((Object)tuple.type, (Object)tuple.value.toString());
                } else {
                    itemMap.put((Object)ValueType.NAME.toString(), (Object)realValue.toString());
                }
                realResult = itemMap;
            } else if (type.equals("option") || type.equals("string") && custom != null && (custom.equals("com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes") || custom.equals("com.atlassian.jira.plugin.system.customfieldtypes:multiselect"))) {
                realResult = new JSONObject();
                realResult.put((Object)ValueType.VALUE.toString(), (Object)realValue.toString());
            } else if (type.equals("string")) {
                realResult = realValue.toString();
            }
            if (oper != null) {
                JSONObject operMap = new JSONObject();
                operMap.put((Object)oper.name, realResult);
                results.add((Object)operMap);
                continue;
            }
            results.add(realResult);
        }
        return results;
    }

    public static Object toJson(String name, Object value, JSONObject editmeta) throws JiraException, UnsupportedOperationException {
        Meta m = Field.getFieldMetadata(name, editmeta);
        if (m.type == null) {
            throw new JiraException("Field '" + name + "' is missing metadata type");
        }
        if (m.type.equals("array")) {
            if (value == null) {
                value = new ArrayList();
            } else if (!(value instanceof Iterable)) {
                throw new JiraException("Field '" + name + "' expects an Iterable value");
            }
            return Field.toArray(value, m.items, m.custom);
        }
        if (m.type.equals("date")) {
            if (value == null) {
                return JSONNull.getInstance();
            }
            Date d = Field.toDate(value);
            if (d == null) {
                throw new JiraException("Field '" + name + "' expects a date value or format is invalid");
            }
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            return df.format(d);
        }
        if (m.type.equals("datetime")) {
            if (value == null) {
                return JSONNull.getInstance();
            }
            if (!(value instanceof Timestamp)) {
                throw new JiraException("Field '" + name + "' expects a Timestamp value");
            }
            SimpleDateFormat df = new SimpleDateFormat(DATETIME_FORMAT);
            return df.format(value);
        }
        if (m.type.equals(ISSUE_TYPE) || m.type.equals(PRIORITY) || m.type.equals("user") || m.type.equals(RESOLUTION) || m.type.equals("securitylevel")) {
            JSONObject json = new JSONObject();
            if (value == null) {
                return JSONNull.getInstance();
            }
            if (value instanceof ValueTuple) {
                ValueTuple tuple = (ValueTuple)((Object)value);
                json.put((Object)tuple.type, (Object)tuple.value.toString());
            } else {
                json.put((Object)ValueType.NAME.toString(), (Object)((Object)value).toString());
            }
            return json.toString();
        }
        if (m.type.equals(PROJECT) || m.type.equals("issuelink")) {
            JSONObject json = new JSONObject();
            if (value == null) {
                return JSONNull.getInstance();
            }
            if (value instanceof ValueTuple) {
                ValueTuple tuple = (ValueTuple)((Object)value);
                json.put((Object)tuple.type, (Object)tuple.value.toString());
            } else {
                json.put((Object)ValueType.KEY.toString(), (Object)((Object)value).toString());
            }
            return json.toString();
        }
        if (m.type.equals("string") || m.type.equals("securitylevel") || m.type.equals("option")) {
            if (value == null) {
                return "";
            }
            if (value instanceof List) {
                return Field.toJsonMap(value);
            }
            if (value instanceof ValueTuple) {
                JSONObject json = new JSONObject();
                ValueTuple tuple = (ValueTuple)((Object)value);
                json.put((Object)tuple.type, (Object)tuple.value.toString());
                return json.toString();
            }
            return ((Object)value).toString();
        }
        if (m.type.equals(TIME_TRACKING)) {
            if (value == null) {
                return JSONNull.getInstance();
            }
            if (value instanceof TimeTracking) {
                return ((TimeTracking)((Object)value)).toJsonObject();
            }
        } else {
            if (m.type.equals("number")) {
                if (value == null) {
                    return JSONNull.getInstance();
                }
                if (!(value instanceof Integer || value instanceof Double || value instanceof Float || value instanceof Long)) {
                    throw new JiraException("Field '" + name + "' expects a Numeric value");
                }
                return value;
            }
            if (m.type.equals("any")) {
                if (value == null) {
                    return JSONNull.getInstance();
                }
                if (value instanceof List) {
                    return Field.toJsonMap(value);
                }
                if (value instanceof ValueTuple) {
                    JSONObject json = new JSONObject();
                    ValueTuple tuple = (ValueTuple)((Object)value);
                    json.put((Object)tuple.type, (Object)tuple.value.toString());
                    return json.toString();
                }
                if (value instanceof TimeTracking) {
                    return ((TimeTracking)((Object)value)).toJsonObject();
                }
                return value;
            }
        }
        throw new UnsupportedOperationException(m.type + " is not a supported field type");
    }

    public static Object toJsonMap(List list) {
        JSONObject json = new JSONObject();
        for (Object item : list) {
            if (item instanceof ValueTuple) {
                ValueTuple vt = (ValueTuple)item;
                json.put((Object)vt.type, (Object)vt.value.toString());
                continue;
            }
            json.put((Object)ValueType.VALUE.toString(), (Object)item.toString());
        }
        return json.toString();
    }

    public static ValueTuple valueByKey(String key) {
        return new ValueTuple(ValueType.KEY, (Object)key);
    }

    public static ValueTuple valueByName(String name) {
        return new ValueTuple(ValueType.NAME, (Object)name);
    }

    public static ValueTuple valueById(String id) {
        return new ValueTuple(ValueType.ID_NUMBER, (Object)id);
    }

    public static final class ValueTuple {
        public final String type;
        public final Object value;

        public ValueTuple(String type, Object value) {
            this.type = type;
            this.value = value != null ? value : JSONNull.getInstance();
        }

        public ValueTuple(ValueType type, Object value) {
            this(type.toString(), value);
        }
    }

    public static enum ValueType {
        KEY("key"),
        NAME("name"),
        ID_NUMBER("id"),
        VALUE("value");

        private String typeName;

        private ValueType(String typeName) {
            this.typeName = typeName;
        }

        public String toString() {
            return this.typeName;
        }
    }

    public static final class Operation {
        public String name;
        public Object value;

        public Operation(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    public static final class Meta {
        public boolean required;
        public String type;
        public String items;
        public String name;
        public String system;
        public String custom;
        public int customId;
    }
}

