/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.rcarz.jiraclient.Component;
import net.rcarz.jiraclient.CustomFieldOption;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.Filter;
import net.rcarz.jiraclient.ICredentials;
import net.rcarz.jiraclient.Issue;
import net.rcarz.jiraclient.IssueHistory;
import net.rcarz.jiraclient.IssueHistoryItem;
import net.rcarz.jiraclient.IssueType;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Priority;
import net.rcarz.jiraclient.Project;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.RestException;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;

public class JiraClient {
    private RestClient restclient = null;
    private String username = null;

    public JiraClient(String uri) throws JiraException {
        this(null, uri, null);
    }

    public JiraClient(String uri, ICredentials creds) throws JiraException {
        this(null, uri, creds);
    }

    public JiraClient(HttpClient httpClient, String uri, ICredentials creds) throws JiraException {
        if (httpClient == null) {
            PoolingClientConnectionManager connManager = new PoolingClientConnectionManager();
            connManager.setDefaultMaxPerRoute(20);
            connManager.setMaxTotal(40);
            httpClient = new DefaultHttpClient((ClientConnectionManager)connManager);
        }
        this.restclient = new RestClient(httpClient, creds, URI.create(uri));
        if (creds != null) {
            this.username = creds.getLogonName();
            creds.initialize(this.restclient);
        }
    }

    public Issue.FluentCreate createIssue(String project, String issueType) throws JiraException {
        return Issue.create(this.restclient, project, issueType);
    }

    public Issue getIssue(String key) throws JiraException {
        return Issue.get(this.restclient, key);
    }

    public Issue getIssue(String key, String includedFields) throws JiraException {
        return Issue.get(this.restclient, key, includedFields);
    }

    public Issue getIssue(String key, String includedFields, String expand) throws JiraException {
        return Issue.get(this.restclient, key, includedFields, expand);
    }

    public int countIssues(String jql) throws JiraException {
        return Issue.count(this.restclient, jql);
    }

    public Issue.SearchResult searchIssues(String jql) throws JiraException {
        return this.searchIssues(jql, null, null, null, null);
    }

    public Issue.SearchResult searchIssues(String jql, Integer maxResults) throws JiraException {
        return this.searchIssues(jql, null, null, maxResults, null);
    }

    public Issue.SearchResult searchIssues(String jql, String includedFields) throws JiraException {
        return this.searchIssues(jql, includedFields, null, null, null);
    }

    public Issue.SearchResult searchIssues(String jql, String includedFields, String expandFields) throws JiraException {
        return this.searchIssues(jql, includedFields, expandFields, null, null);
    }

    public Issue.SearchResult searchIssues(String jql, String includedFields, Integer maxResults) throws JiraException {
        return this.searchIssues(jql, includedFields, null, maxResults, null);
    }

    public Issue.SearchResult searchIssues(String jql, String includedFields, Integer maxResults, Integer startAt) throws JiraException {
        return this.searchIssues(jql, includedFields, null, maxResults, startAt);
    }

    public Issue.SearchResult searchIssues(String jql, String includedFields, String expandFields, Integer maxResults, Integer startAt) throws JiraException {
        return Issue.search(this.restclient, jql, includedFields, expandFields, maxResults, startAt);
    }

    public Filter getFilter(String id) throws JiraException {
        return Filter.get(this.restclient, id);
    }

    public List<Priority> getPriorities() throws JiraException {
        try {
            URI uri = this.restclient.buildURI(Resource.getBaseUri() + "priority");
            JSON response = this.restclient.get(uri);
            JSONArray prioritiesArray = JSONArray.fromObject((Object)response);
            ArrayList<Priority> priorities = new ArrayList<Priority>(prioritiesArray.size());
            for (int i = 0; i < prioritiesArray.size(); ++i) {
                JSONObject p = prioritiesArray.getJSONObject(i);
                priorities.add(new Priority(this.restclient, p));
            }
            return priorities;
        }
        catch (Exception ex) {
            throw new JiraException(ex.getMessage(), ex);
        }
    }

    public List<CustomFieldOption> getCustomFieldAllowedValues(String field, String project, String issueType) throws JiraException {
        JSONObject createMetadata = Issue.getCreateMetadata(this.restclient, project, issueType);
        JSONObject fieldMetadata = (JSONObject)createMetadata.get(field);
        List<CustomFieldOption> customFieldOptions = Field.getResourceArray(CustomFieldOption.class, fieldMetadata.get("allowedValues"), this.restclient);
        return customFieldOptions;
    }

    public List<Component> getComponentsAllowedValues(String project, String issueType) throws JiraException {
        JSONObject createMetadata = Issue.getCreateMetadata(this.restclient, project, issueType);
        JSONObject fieldMetadata = (JSONObject)createMetadata.get("components");
        List<Component> componentOptions = Field.getResourceArray(Component.class, fieldMetadata.get("allowedValues"), this.restclient);
        return componentOptions;
    }

    public RestClient getRestClient() {
        return this.restclient;
    }

    public String getSelf() {
        return this.username;
    }

    public List<Project> getProjects() throws JiraException {
        try {
            URI uri = this.restclient.buildURI(Resource.getBaseUri() + "project");
            JSON response = this.restclient.get(uri);
            JSONArray projectsArray = JSONArray.fromObject((Object)response);
            ArrayList<Project> projects = new ArrayList<Project>(projectsArray.size());
            for (int i = 0; i < projectsArray.size(); ++i) {
                JSONObject p = projectsArray.getJSONObject(i);
                projects.add(new Project(this.restclient, p));
            }
            return projects;
        }
        catch (Exception ex) {
            throw new JiraException(ex.getMessage(), ex);
        }
    }

    public Project getProject(String key) throws JiraException {
        try {
            URI uri = this.restclient.buildURI(Resource.getBaseUri() + "project/" + key);
            JSON response = this.restclient.get(uri);
            return new Project(this.restclient, (JSONObject)response);
        }
        catch (Exception ex) {
            throw new JiraException(ex.getMessage(), ex);
        }
    }

    public List<IssueType> getIssueTypes() throws JiraException {
        try {
            URI uri = this.restclient.buildURI(Resource.getBaseUri() + "issuetype");
            JSON response = this.restclient.get(uri);
            JSONArray issueTypeArray = JSONArray.fromObject((Object)response);
            ArrayList<IssueType> issueTypes = new ArrayList<IssueType>(issueTypeArray.size());
            for (int i = 0; i < issueTypeArray.size(); ++i) {
                JSONObject it = issueTypeArray.getJSONObject(i);
                issueTypes.add(new IssueType(this.restclient, it));
            }
            return issueTypes;
        }
        catch (Exception ex) {
            throw new JiraException(ex.getMessage(), ex);
        }
    }

    public Component.FluentCreate createComponent(String project) {
        return Component.create(this.restclient, project);
    }

    public Component getComponent(String id) throws JiraException {
        return Component.get(this.restclient, id);
    }

    public ArrayList<IssueHistory> filterChangeLog(List<IssueHistory> histoy, String fields) {
        ArrayList<IssueHistory> result = new ArrayList<IssueHistory>(histoy.size());
        fields = "," + fields + ",";
        for (IssueHistory record : histoy) {
            ArrayList<IssueHistoryItem> list = new ArrayList<IssueHistoryItem>(record.getChanges().size());
            for (IssueHistoryItem item : record.getChanges()) {
                if (!fields.contains(item.getField())) continue;
                list.add(item);
            }
            if (list.size() <= 0) continue;
            result.add(new IssueHistory(record, list));
        }
        return result;
    }

    public ArrayList<IssueHistory> getIssueChangeLog(Issue issue) throws JiraException {
        try {
            ArrayList<IssueHistory> changes = null;
            JSON response = this.getNextPortion(issue, 0);
            while (true) {
                JSONObject object = JSONObject.fromObject((Object)response);
                Object opers = object.get("changelog");
                object = JSONObject.fromObject((Object)opers);
                Integer totalObj = (Integer)object.get("total");
                JSONArray histories = JSONArray.fromObject((Object)object.get("histories"));
                if (changes == null) {
                    changes = new ArrayList<IssueHistory>(totalObj);
                }
                for (int i = 0; i < histories.size(); ++i) {
                    JSONObject p = histories.getJSONObject(i);
                    changes.add(new IssueHistory(this.restclient, p));
                }
                if (changes.size() >= totalObj) break;
                response = this.getNextPortion(issue, changes.size());
            }
            return changes;
        }
        catch (Exception ex) {
            throw new JiraException(ex.getMessage(), ex);
        }
    }

    private JSON getNextPortion(Issue issue, Integer startAt) throws URISyntaxException, RestException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (startAt != null) {
            params.put("startAt", String.valueOf(startAt));
        }
        params.put("expand", "changelog.fields");
        URI uri = this.restclient.buildURI(Issue.getBaseUri() + "issue/" + issue.id, params);
        return this.restclient.get(uri);
    }
}

