/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import java.util.HashMap;
import java.util.Map;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public class User
extends Resource {
    private boolean active = false;
    private Map<String, String> avatarUrls = null;
    private String displayName = null;
    private String email = null;
    private String name = null;

    protected User(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    public static User get(RestClient restclient, String username) throws JiraException {
        JSON result = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        try {
            result = restclient.get(User.getBaseUri() + "user", params);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve user " + username, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new User(restclient, (JSONObject)result);
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get("self"));
        this.id = Field.getString(map.get("id"));
        this.active = Field.getBoolean(map.get("active"));
        this.avatarUrls = Field.getMap(String.class, String.class, map.get("avatarUrls"));
        this.displayName = Field.getString(map.get("displayName"));
        this.email = this.getEmailFromMap((Map)map);
        this.name = Field.getString(map.get("name"));
    }

    private String getEmailFromMap(Map map) {
        if (map.containsKey("email")) {
            return Field.getString(map.get("email"));
        }
        return Field.getString(map.get("emailAddress"));
    }

    public String toString() {
        return this.getName();
    }

    public boolean isActive() {
        return this.active;
    }

    public Map<String, String> getAvatarUrls() {
        return this.avatarUrls;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }
}

