/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.impsort;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.revelc.code.impsort.Import;
import net.revelc.code.impsort.LineEnding;

public class Result {
    private Boolean isSorted;
    private final Path path;
    private final Charset sourceEncoding;
    private final String originalSection;
    private final String newSection;
    private final Collection<Import> allImports;
    private final List<String> fileLines;
    private final int start;
    private final int stop;
    private final LineEnding lineEnding;

    Result(Path path, Charset sourceEncoding, List<String> fileLines, int start, int stop, String originalSection, String newSection, Collection<Import> allImports, LineEnding lineEnding) {
        this.path = path;
        this.sourceEncoding = sourceEncoding;
        this.originalSection = originalSection;
        this.newSection = newSection;
        this.allImports = allImports;
        this.fileLines = fileLines;
        this.start = start;
        this.stop = stop;
        this.lineEnding = lineEnding;
    }

    public boolean isSorted() {
        if (this.isSorted == null) {
            this.isSorted = this.originalSection.contentEquals(this.newSection);
        }
        return this.isSorted;
    }

    public Collection<Import> getImports() {
        return this.allImports;
    }

    public void saveBackup(Path destination) throws IOException {
        Files.copy(this.path, destination, StandardCopyOption.REPLACE_EXISTING);
    }

    public void saveSorted(Path destination) throws IOException {
        if (this.isSorted()) {
            if (!Files.isSameFile(this.path, destination)) {
                this.saveBackup(destination);
            }
            return;
        }
        List<String> beforeImports = this.fileLines.subList(0, this.start);
        List<String> importLines = Arrays.asList(this.newSection.split(this.lineEnding.getChars()));
        List<String> afterImports = this.fileLines.subList(this.stop, this.fileLines.size());
        ArrayList<String> allLines = new ArrayList<String>(beforeImports.size() + importLines.size() + afterImports.size() + 1);
        allLines.addAll(beforeImports);
        allLines.addAll(importLines);
        if (afterImports.size() > 0) {
            allLines.add("");
        }
        allLines.addAll(afterImports);
        this.writeLines(destination, allLines, this.sourceEncoding);
    }

    private Path writeLines(Path destination, List<String> lines, Charset sourceEncoding) throws IOException {
        try (OutputStream out = Files.newOutputStream(destination, new OpenOption[0]);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, sourceEncoding.newEncoder()));){
            for (String line : lines) {
                writer.write(line);
                writer.write(this.lineEnding.getChars());
            }
        }
        return destination;
    }
}

