/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.serenitybdd.maven.plugins.HistoryDirectory;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="clear-history")
public class SerenityClearHistoryMojo
extends AbstractMojo {
    @Parameter(property="serenity.historyDirectory")
    public String historyDirectoryPath;
    @Parameter(defaultValue="${session}")
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Clearing Serenity test result summaries");
        EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
        String configuredHistoryDirectoryPath = HistoryDirectory.configuredIn(environmentVariables, this.historyDirectoryPath);
        Path historyDirectory = Paths.get(configuredHistoryDirectoryPath, new String[0]);
        try {
            FileUtils.deleteDirectory((File)historyDirectory.toFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

