/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.maven.plugins;

import com.google.common.base.Splitter;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.di.SerenityInfrastructure;
import net.serenitybdd.maven.plugins.MavenProjectHelper;
import net.serenitybdd.maven.plugins.UpdatedClassLoader;
import net.thucydides.core.reports.ExtendedReports;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="reports", requiresProject=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SerenityReportMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerenityReportMojo.class);
    @Parameter(property="serenity.outputDirectory", defaultValue="${basedir}/target/site/serenity")
    public File outputDirectory;
    @Parameter(property="serenity.sourceDirectory", defaultValue="${basedir}/target/site/serenity")
    public File sourceDirectory;
    @Parameter
    public String requirementsBaseDir;
    EnvironmentVariables environmentVariables;
    Configuration configuration;
    @Parameter(defaultValue="${session}")
    protected MavenSession session;
    @Parameter(property="tags")
    public String tags;
    @Parameter(defaultValue="${project}")
    public MavenProject project;
    @Parameter(property="thucydides.project.key", defaultValue="default")
    public String projectKey;
    @Parameter(property="serenity.reports")
    public String reports;

    public void prepareExecution() throws MojoExecutionException {
        MavenProjectHelper.propagateBuildDir(this.session);
        this.configureOutputDirectorySettings();
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        this.configureEnvironmentVariables();
        UpdatedClassLoader.withProjectClassesFrom(this.project);
    }

    private void configureOutputDirectorySettings() {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.getConfiguration().getOutputDirectory();
        }
        if (this.sourceDirectory == null) {
            this.sourceDirectory = this.getConfiguration().getOutputDirectory();
        }
        Path projectDir = this.session.getCurrentProject().getBasedir().toPath();
        if (!this.outputDirectory.isAbsolute()) {
            this.outputDirectory = projectDir.resolve(this.outputDirectory.toPath()).toFile();
        }
        if (!this.sourceDirectory.isAbsolute()) {
            this.sourceDirectory = projectDir.resolve(this.sourceDirectory.toPath()).toFile();
        }
    }

    private EnvironmentVariables getEnvironmentVariables() {
        return SystemEnvironmentVariables.currentEnvironmentVariables();
    }

    private Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = SerenityInfrastructure.getConfiguration();
        }
        return this.configuration;
    }

    private void configureEnvironmentVariables() {
        Locale.setDefault(Locale.ENGLISH);
        this.updateSystemProperty(ThucydidesSystemProperty.SERENITY_PROJECT_KEY.getPropertyName(), this.projectKey, Serenity.getDefaultProjectKey());
        this.updateSystemProperty(ThucydidesSystemProperty.SERENITY_TEST_REQUIREMENTS_BASEDIR.toString(), this.requirementsBaseDir);
    }

    private void updateSystemProperty(String key, String value, String defaultValue) {
        this.getEnvironmentVariables().setProperty(key, Optional.ofNullable(value).orElse(defaultValue));
    }

    private void updateSystemProperty(String key, String value) {
        Optional.ofNullable(value).ifPresent(propertyValue -> this.getEnvironmentVariables().setProperty(key, propertyValue));
    }

    public void execute() throws MojoExecutionException {
        this.prepareExecution();
        this.generateExtraReports();
    }

    private void generateExtraReports() {
        if (StringUtils.isEmpty((CharSequence)this.reports)) {
            return;
        }
        List extendedReportTypes = Splitter.on((String)",").splitToList((CharSequence)this.reports);
        ExtendedReports.named((List)extendedReportTypes).forEach(report -> {
            report.setSourceDirectory(this.sourceDirectory.toPath());
            report.setOutputDirectory(this.outputDirectory.toPath());
            Path generatedReport = report.generateReport();
            LOGGER.info("Generated report file for {}: {}", (Object)report.getName(), (Object)generatedReport);
        });
    }
}

