/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.util.List;
import java.util.NoSuchElementException;
import net.thucydides.core.annotations.ClearCookiesPolicy;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.annotations.InvalidManagedWebDriverFieldException;
import net.thucydides.core.annotations.Managed;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.openqa.selenium.WebDriver;

public class ManagedWebDriverAnnotatedField {
    private static final String NO_ANNOTATED_FIELD_ERROR = "No WebDriver field annotated with @Managed was found in the test case.";
    private final Field field;

    public static Optional<ManagedWebDriverAnnotatedField> findOptionalAnnotatedField(Class<?> testClass) {
        try {
            Field annotatedField = (Field)Iterables.find(ManagedWebDriverAnnotatedField.fieldsIn(testClass), ManagedWebDriverAnnotatedField.withCorrectAnnotations());
            return Optional.of((Object)new ManagedWebDriverAnnotatedField(annotatedField));
        }
        catch (NoSuchElementException e) {
            return Optional.absent();
        }
    }

    public static ManagedWebDriverAnnotatedField findFirstAnnotatedField(Class<?> testClass) {
        Optional<ManagedWebDriverAnnotatedField> optionalField = ManagedWebDriverAnnotatedField.findOptionalAnnotatedField(testClass);
        if (optionalField.isPresent()) {
            return (ManagedWebDriverAnnotatedField)optionalField.get();
        }
        throw new InvalidManagedWebDriverFieldException(NO_ANNOTATED_FIELD_ERROR);
    }

    public static List<ManagedWebDriverAnnotatedField> findAnnotatedFields(Class<?> testClass) {
        ImmutableList managedFields = ImmutableList.copyOf((Iterable)Iterables.filter(ManagedWebDriverAnnotatedField.fieldsIn(testClass), ManagedWebDriverAnnotatedField.withCorrectAnnotations()));
        return Lambda.convert((Object)managedFields, ManagedWebDriverAnnotatedField.toManagedAnnotatedFields());
    }

    private static Converter<Field, ManagedWebDriverAnnotatedField> toManagedAnnotatedFields() {
        return new Converter<Field, ManagedWebDriverAnnotatedField>(){

            public ManagedWebDriverAnnotatedField convert(Field field) {
                return new ManagedWebDriverAnnotatedField(field);
            }
        };
    }

    public static boolean hasManagedWebdriverField(Class<?> testClass) {
        try {
            Iterables.find(ManagedWebDriverAnnotatedField.fieldsIn(testClass), ManagedWebDriverAnnotatedField.withCorrectAnnotations());
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private static Predicate<Field> withCorrectAnnotations() {
        return new Predicate<Field>(){

            public boolean apply(Field field) {
                return ManagedWebDriverAnnotatedField.isFieldAnnotated(field);
            }
        };
    }

    private static boolean isFieldAnnotated(Field field) {
        return ManagedWebDriverAnnotatedField.fieldIsAnnotatedCorrectly(field) && ManagedWebDriverAnnotatedField.fieldIsRightType(field);
    }

    private static boolean fieldIsRightType(Field field) {
        return WebDriverFacade.class.isAssignableFrom(field.getType()) || field.getType().isAssignableFrom(WebDriver.class);
    }

    private static boolean fieldIsAnnotatedCorrectly(Field field) {
        return field.getAnnotation(Managed.class) != null;
    }

    protected ManagedWebDriverAnnotatedField(Field field) {
        this.field = field;
    }

    public void setValue(Object testCase, WebDriver manageDriver) {
        try {
            this.field.setAccessible(true);
            this.field.set(testCase, manageDriver);
        }
        catch (IllegalAccessException e) {
            throw new InvalidManagedWebDriverFieldException("Could not access or set web driver field: " + this.field + " - is this field public?", e);
        }
    }

    private static ImmutableSet<Field> fieldsIn(Class clazz) {
        return ImmutableSet.copyOf(Fields.of(clazz).allFields());
    }

    public boolean isUniqueSession() {
        return this.field.getAnnotation(Managed.class).uniqueSession();
    }

    public ClearCookiesPolicy getClearCookiesPolicy() {
        return this.field.getAnnotation(Managed.class).clearCookies();
    }

    public String getDriver() {
        return this.field.getAnnotation(Managed.class).driver();
    }
}

