/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Stack;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.eventbus.Broadcaster;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.events.TestLifecycleEvents;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.DataDrivenStep;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.TestResultTally;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepEventBus {
    private static ThreadLocal<StepEventBus> stepEventBusThreadLocal = new ThreadLocal();
    private static final String CORE_THUCYDIDES_PACKAGE = "net.thucydides.core";
    private static final Logger LOGGER = LoggerFactory.getLogger(StepEventBus.class);
    public static final String TEST_SOURCE_JUNIT = "JUnit";
    public static final String TEST_SOURCE_JBEHAVE = "JBehave";
    public static final String TEST_SOURCE_CUCUMBER = "Cucumber";
    private List<StepListener> registeredListeners = new ArrayList<StepListener>();
    private BaseStepListener baseStepListener;
    private TestResultTally resultTally;
    private Stack<String> stepStack = new Stack();
    private Stack<Boolean> webdriverSuspensions = new Stack();
    private Set<StepListener> customListeners;
    private boolean stepFailed;
    private boolean suspendedTest;
    private boolean assumptionViolated;
    private String assumptionViolatedMessage;
    private boolean uniqueSession;
    private Class<?> classUnderTest;
    private Story storyUnderTest;
    private Optional<Boolean> isDryRun = Optional.absent();
    private final EnvironmentVariables environmentVariables;
    private String testSource;
    private final Optional<TestResult> NO_FORCED_RESULT = Optional.absent();
    Optional<TestResult> NO_RESULT_YET = Optional.absent();
    private boolean softAssertsEnabled = false;

    public static synchronized StepEventBus getEventBus() {
        if (stepEventBusThreadLocal.get() == null) {
            stepEventBusThreadLocal.set(new StepEventBus(ConfiguredEnvironment.getEnvironmentVariables()));
        }
        return stepEventBusThreadLocal.get();
    }

    @Inject
    public StepEventBus(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public StepEventBus registerListener(StepListener listener) {
        if (!this.registeredListeners.contains(listener)) {
            this.registeredListeners.add(listener);
            if (BaseStepListener.class.isAssignableFrom(listener.getClass())) {
                this.baseStepListener = (BaseStepListener)listener;
                this.baseStepListener.setEventBus(this);
            }
        }
        return this;
    }

    public boolean isBaseStepListenerRegistered() {
        return this.baseStepListener != null;
    }

    public BaseStepListener getBaseStepListener() {
        Preconditions.checkNotNull((Object)this.baseStepListener, (Object)"No BaseStepListener has been registered");
        return this.baseStepListener;
    }

    public void testStarted(String testName) {
        this.clear();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testStarted(testName);
        }
    }

    public void testStarted(String testName, String id) {
        this.clear();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testStarted(testName, id);
        }
    }

    public boolean isUniqueSession() {
        return this.uniqueSession;
    }

    public void setUniqueSession(boolean uniqueSession) {
        this.uniqueSession = uniqueSession;
    }

    public void testStarted(String newTestName, Story story) {
        this.startSuiteWithStoryForFirstTest(story);
        this.testStarted(newTestName);
    }

    public void testStarted(String newTestName, Class<?> testClass) {
        this.ensureThatTheTestSuiteStartedWith(testClass);
        if (newTestName != null) {
            this.testStarted(newTestName);
        }
    }

    private void ensureThatTheTestSuiteStartedWith(Class<?> testClass) {
        if (!this.getBaseStepListener().testSuiteRunning()) {
            this.testSuiteStarted(testClass);
        }
    }

    private void startSuiteWithStoryForFirstTest(Story story) {
        if (this.storyUnderTest == null || this.storyUnderTest != story) {
            this.testSuiteStarted(story);
        }
    }

    protected List<StepListener> getAllListeners() {
        ArrayList allListeners = Lists.newArrayList(this.registeredListeners);
        allListeners.addAll(this.getCustomListeners());
        return ImmutableList.copyOf((Collection)allListeners);
    }

    private Set<StepListener> getCustomListeners() {
        if (this.customListeners == null) {
            this.customListeners = Collections.synchronizedSet(new HashSet());
            ServiceLoader<StepListener> stepListenerServiceLoader = ServiceLoader.load(StepListener.class);
            Iterator<StepListener> listenerImplementations = stepListenerServiceLoader.iterator();
            while (listenerImplementations.hasNext()) {
                try {
                    StepListener listener = listenerImplementations.next();
                    if (this.isACore(listener)) continue;
                    LOGGER.debug("Registering custom listener " + listener);
                    this.customListeners.add(listener);
                }
                catch (ServiceConfigurationError e) {
                    LOGGER.error("Could not instantiate listener ", (Throwable)e);
                }
            }
        }
        return this.customListeners;
    }

    private boolean isACore(StepListener listener) {
        return listener.getClass().getPackage().getName().startsWith(CORE_THUCYDIDES_PACKAGE);
    }

    public void testSuiteStarted(Class<?> testClass) {
        LOGGER.debug("Test suite started for {}", testClass);
        this.clear();
        this.updateClassUnderTest(testClass);
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testSuiteStarted(testClass);
        }
        TestLifecycleEvents.postEvent(TestLifecycleEvents.testSuiteStarted());
    }

    private void updateClassUnderTest(Class<?> testClass) {
        this.classUnderTest = testClass;
    }

    private void updateStoryUnderTest(Story story) {
        this.storyUnderTest = story;
    }

    public void testSuiteStarted(Story story) {
        LOGGER.debug("Test suite started for story {}", (Object)story);
        this.updateStoryUnderTest(story);
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testSuiteStarted(story);
        }
        TestLifecycleEvents.postEvent(TestLifecycleEvents.testSuiteStarted());
    }

    public void clear() {
        this.stepStack.clear();
        this.clearStepFailures();
        this.currentTestIsNotSuspended();
        this.noAssumptionsViolated();
        this.disableSoftAsserts();
        this.resultTally = null;
        this.classUnderTest = null;
        this.webdriverSuspensions.clear();
        Broadcaster.unregisterAllListeners();
    }

    private void noAssumptionsViolated() {
        this.assumptionViolated = false;
        this.assumptionViolatedMessage = "";
    }

    private void currentTestIsNotSuspended() {
        this.suspendedTest = false;
    }

    private TestResultTally getResultTally() {
        if (this.resultTally == null) {
            this.resultTally = TestResultTally.forTestClass(this.classUnderTest);
        }
        return this.resultTally;
    }

    public void testFinished() {
        TestOutcome outcome = this.getBaseStepListener().getCurrentTestOutcome();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testFinished(outcome);
        }
        this.clear();
    }

    public void testFinished(TestOutcome result) {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testFinished(result);
        }
        this.clear();
    }

    public void testRetried() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testRetried();
        }
        this.clear();
    }

    private void pushStep(String stepName) {
        this.stepStack.push(stepName);
    }

    private void popStep() {
        this.stepStack.pop();
    }

    public void clearStepFailures() {
        this.stepFailed = false;
    }

    public boolean aStepInTheCurrentTestHasFailed() {
        return this.stepFailed;
    }

    public boolean isCurrentTestDataDriven() {
        return DataDrivenStep.inProgress();
    }

    public void stepStarted(ExecutedStepDescription stepDescription) {
        this.stepStarted(stepDescription, false);
    }

    public void stepStarted(ExecutedStepDescription stepDescription, boolean isPrecondition) {
        this.pushStep(stepDescription.getName());
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepStarted(stepDescription);
        }
        if (isPrecondition) {
            this.baseStepListener.currentStepIsAPrecondition();
        }
    }

    public void skippedStepStarted(ExecutedStepDescription executedStepDescription) {
        this.pushStep(executedStepDescription.getName());
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.skippedStepStarted(executedStepDescription);
        }
    }

    public void stepFinished() {
        this.stepDone();
        this.getResultTally().logExecutedTest();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepFinished();
        }
    }

    private void stepDone() {
        if (!this.stepStack.empty()) {
            this.popStep();
        }
    }

    public void stepFailed(StepFailure failure) {
        this.stepDone();
        this.getResultTally().logFailure(failure);
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepFailed(failure);
        }
        this.stepFailed = true;
    }

    public void lastStepFailed(StepFailure failure) {
        this.getResultTally().logFailure(failure);
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepFailed(failure);
        }
        this.stepFailed = true;
    }

    public void stepIgnored() {
        this.stepDone();
        this.getResultTally().logIgnoredTest();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.stepIgnored();
        }
    }

    public void stepPending() {
        this.stepPending(null);
    }

    public void stepPending(String message) {
        this.testPending();
        this.stepDone();
        this.getResultTally().logIgnoredTest();
        for (StepListener stepListener : this.getAllListeners()) {
            if (message != null) {
                stepListener.stepPending(message);
                continue;
            }
            stepListener.stepPending();
        }
    }

    public void assumptionViolated(String message) {
        this.testIgnored();
        this.suspendTest();
        this.stepDone();
        this.getResultTally().logIgnoredTest();
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.assumptionViolated(message);
        }
        this.assumptionViolated = true;
        this.assumptionViolatedMessage = message;
    }

    public void dropListener(StepListener stepListener) {
        this.registeredListeners.remove(stepListener);
    }

    public void dropAllListeners() {
        this.registeredListeners.clear();
    }

    public boolean webdriverCallsAreSuspended() {
        if (this.softAssertsActive()) {
            return !this.webdriverSuspensions.isEmpty();
        }
        return this.currentTestIsSuspended() || this.aStepInTheCurrentTestHasFailed() || !this.webdriverSuspensions.isEmpty();
    }

    public void reenableWebdriverCalls() {
        this.webdriverSuspensions.pop();
    }

    public void temporarilySuspendWebdriverCalls() {
        this.webdriverSuspensions.push(true);
    }

    public void testFailed(Throwable cause) {
        TestOutcome outcome = this.getBaseStepListener().getCurrentTestOutcome();
        for (StepListener stepListener : this.getAllListeners()) {
            try {
                stepListener.testFailed(outcome, cause);
            }
            catch (AbstractMethodError ame) {
                LOGGER.warn("Caught abstract method error - this seems to be mostly harmless.");
            }
        }
    }

    public void testPending() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testPending();
        }
        this.suspendTest();
    }

    public void testIsManual() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testIsManual();
        }
        this.suspendTest();
    }

    public void suspendTest() {
        this.suspendedTest = true;
    }

    public void suspendTest(TestResult result) {
        this.suspendTest();
        switch (result) {
            case PENDING: {
                this.testPending();
                break;
            }
            case IGNORED: {
                this.testIgnored();
                break;
            }
            case SKIPPED: {
                this.testSkipped();
            }
        }
    }

    public boolean currentTestIsSuspended() {
        return this.suspendedTest;
    }

    public boolean assumptionViolated() {
        return this.assumptionViolated;
    }

    public void testIgnored() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testIgnored();
        }
        this.suspendTest();
    }

    public void testSkipped() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testSkipped();
        }
        this.suspendTest();
    }

    public boolean areStepsRunning() {
        return !this.stepStack.isEmpty();
    }

    public void notifyScreenChange() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.notifyScreenChange();
        }
    }

    public void testSuiteFinished() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testSuiteFinished();
        }
        TestLifecycleEvents.postEvent(TestLifecycleEvents.testSuiteFinished());
        this.storyUnderTest = null;
    }

    public void testRunFinished() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.testRunFinished();
        }
    }

    public void updateCurrentStepTitle(String stepTitle) {
        this.getBaseStepListener().updateCurrentStepTitle(stepTitle);
    }

    public void updateCurrentStepTitleAsPrecondition(String stepTitle) {
        this.getBaseStepListener().updateCurrentStepTitle(stepTitle).asAPrecondition();
    }

    public void addIssuesToCurrentStory(List<String> issues) {
        this.getBaseStepListener().addIssuesToCurrentStory(issues);
    }

    public void addIssuesToCurrentTest(List<String> issues) {
        this.getBaseStepListener().getCurrentTestOutcome().addIssues(issues);
    }

    public void addTagsToCurrentTest(List<TestTag> tags) {
        this.getBaseStepListener().getCurrentTestOutcome().addTags(tags);
    }

    public void addTagsToCurrentStory(List<TestTag> tags) {
        this.getBaseStepListener().addTagsToCurrentStory(tags);
    }

    public void addDescriptionToCurrentTest(String description) {
        this.getBaseStepListener().getCurrentTestOutcome().setDescription(description);
    }

    public void setBackgroundTitle(String title) {
        this.getBaseStepListener().getCurrentTestOutcome().setBackgroundTitle(title);
    }

    public void setBackgroundDescription(String description) {
        this.getBaseStepListener().getCurrentTestOutcome().setBackgroundDescription(description);
    }

    public void useExamplesFrom(DataTable table) {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.useExamplesFrom(table);
        }
    }

    public void addNewExamplesFrom(DataTable newTable) {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.addNewExamplesFrom(newTable);
        }
    }

    public void exampleStarted(Map<String, String> data) {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.exampleStarted(data);
        }
    }

    public void exampleFinished() {
        for (StepListener stepListener : this.getAllListeners()) {
            stepListener.exampleFinished();
        }
    }

    public boolean currentTestOutcomeIsDataDriven() {
        return this.getBaseStepListener().latestTestOutcome().isPresent() && ((TestOutcome)this.getBaseStepListener().latestTestOutcome().get()).isDataDriven();
    }

    public void takeScreenshot() {
        this.getBaseStepListener().takeScreenshot();
    }

    public boolean testSuiteHasStarted() {
        return this.getBaseStepListener().testSuiteRunning();
    }

    public String getAssumptionViolatedMessage() {
        return this.assumptionViolatedMessage;
    }

    public Optional<TestStep> getCurrentStep() {
        return this.getBaseStepListener().cloneCurrentStep();
    }

    public void setAllStepsTo(TestResult result) {
        this.baseStepListener.setAllStepsTo(result);
    }

    public Optional<TestResult> getForcedResult() {
        return this.baseStepListener != null ? this.baseStepListener.getForcedResult() : this.NO_FORCED_RESULT;
    }

    public synchronized boolean isDryRun() {
        if (this.isDryRun.isPresent()) {
            return (Boolean)this.isDryRun.get();
        }
        return ThucydidesSystemProperty.THUCYDIDES_DRY_RUN.booleanFrom(this.environmentVariables);
    }

    public synchronized void enableDryRun() {
        this.isDryRun = Optional.of((Object)true);
    }

    public void exceptionExpected(Class<? extends Throwable> expected) {
        this.getBaseStepListener().exceptionExpected(expected);
    }

    public Optional<TestResult> resultSoFar() {
        return this.getBaseStepListener().latestTestOutcome().isPresent() ? Optional.fromNullable((Object)((Object)((TestOutcome)this.getBaseStepListener().latestTestOutcome().get()).getResult())) : this.NO_RESULT_YET;
    }

    public void mergePreviousStep() {
        this.baseStepListener.mergeLast(2).steps();
    }

    public void updateOverallResults() {
        this.baseStepListener.updateOverallResults();
    }

    public void reset() {
        if (this.baseStepListener != null) {
            this.baseStepListener.testSuiteFinished();
        }
        stepEventBusThreadLocal.remove();
    }

    public void disableSoftAsserts() {
        this.softAssertsEnabled = false;
    }

    public void enableSoftAsserts() {
        this.softAssertsEnabled = true;
    }

    public boolean softAssertsActive() {
        return this.softAssertsEnabled;
    }

    public String getTestSource() {
        return this.testSource;
    }

    public void setTestSource(String testSource) {
        this.testSource = testSource;
    }

    public void cancelPreviousTest() {
        this.baseStepListener.cancelPreviousTest();
    }

    public void lastTestPassedAfterRetries(int remainingTries, List<String> failureMessages) {
        this.baseStepListener.lastTestPassedAfterRetries(remainingTries, failureMessages);
    }
}

