/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.net.URL;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.appium.AppiumConfiguration;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class AppiumDriverProvider
implements DriverProvider {
    private final DriverCapabilityRecord driverProperties;
    private final FixtureProviderService fixtureProviderService;

    public AppiumDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        switch (this.appiumTargetPlatform(environmentVariables)) {
            case ANDROID: {
                AndroidDriver androidDriver = new AndroidDriver(this.appiumUrl(environmentVariables), (Capabilities)enhancer.enhanced(this.appiumCapabilities(options, environmentVariables), SupportedWebDriver.ANDROID));
                this.driverProperties.registerCapabilities("appium", this.capabilitiesToProperties(androidDriver.getCapabilities()));
                return androidDriver;
            }
            case IOS: {
                IOSDriver iosDriver = new IOSDriver(this.appiumUrl(environmentVariables), (Capabilities)enhancer.enhanced(this.appiumCapabilities(options, environmentVariables), SupportedWebDriver.IPHONE));
                this.driverProperties.registerCapabilities("appium", this.capabilitiesToProperties(iosDriver.getCapabilities()));
                return iosDriver;
            }
        }
        throw new UnsupportedDriverException(this.appiumTargetPlatform(environmentVariables).name());
    }

    private DesiredCapabilities appiumCapabilities(String options, EnvironmentVariables environmentVariables) {
        return AppiumConfiguration.from(environmentVariables).getCapabilities(options);
    }

    private MobilePlatform appiumTargetPlatform(EnvironmentVariables environmentVariables) {
        return AppiumConfiguration.from(environmentVariables).getTargetPlatform();
    }

    private URL appiumUrl(EnvironmentVariables environmentVariables) {
        return AppiumConfiguration.from(environmentVariables).getUrl();
    }
}

