/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.net.MalformedURLException;
import java.net.URL;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.RemoteDriverBuilder;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.capabilities.BrowserStackRemoteDriverCapabilities;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

class BrowserStackDriverBuilder
extends RemoteDriverBuilder {
    private final DriverCapabilities remoteDriverCapabilities;
    private final BrowserStackRemoteDriverCapabilities browserStackRemoteDriverCapabilities;

    BrowserStackDriverBuilder(EnvironmentVariables environmentVariables, DriverCapabilities remoteDriverCapabilities) {
        super(environmentVariables);
        this.remoteDriverCapabilities = remoteDriverCapabilities;
        this.browserStackRemoteDriverCapabilities = new BrowserStackRemoteDriverCapabilities(environmentVariables);
    }

    @Override
    WebDriver buildWithOptions(String options) throws MalformedURLException {
        String browserStackUrl = this.browserStackRemoteDriverCapabilities.getUrl();
        return this.newRemoteDriver(new URL(browserStackUrl), this.findbrowserStackCapabilities(options), options);
    }

    private Capabilities findbrowserStackCapabilities(String options) {
        String driver = WebDriverFactory.getBrowserStackDriverFrom(this.environmentVariables);
        DesiredCapabilities capabilities = this.remoteDriverCapabilities.forDriver(driver, options);
        return this.browserStackRemoteDriverCapabilities.getCapabilities(capabilities);
    }
}

