/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Preconditions;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.DriverSource;
import net.thucydides.core.webdriver.WebDriverFactory;

public class ProvidedDriverConfiguration {
    private final EnvironmentVariables environmentVariables;

    public ProvidedDriverConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public boolean isProvided() {
        return WebDriverFactory.getDriverFrom(this.environmentVariables).equals("provided");
    }

    public DriverSource getDriverSource() {
        String providedDriverType = this.getDriverName();
        Preconditions.checkNotNull((Object)providedDriverType, (Object)"No provider type was specified in 'webdriver.provided.type'");
        String providedImplementation = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty("webdriver.provided." + providedDriverType).orElse(null);
        Preconditions.checkNotNull((Object)providedImplementation, (Object)("No provider implementation was specified in 'webdriver.provided.'" + providedDriverType));
        try {
            return (DriverSource)Class.forName(providedImplementation).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate the custom webdriver provider of type " + providedImplementation);
        }
    }

    public String getDriverName() {
        return ThucydidesSystemProperty.WEBDRIVER_PROVIDED_TYPE.from(this.environmentVariables);
    }
}

