/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders.webdrivermanager;

import io.github.bonigarcia.wdm.WebDriverManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import net.serenitybdd.core.webdriver.enhancers.WebDriverManagerEnhancer;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.reflection.ClassFinder;
import net.thucydides.core.util.EnvironmentVariables;

public class WebDriverManagerSetup {
    private final EnvironmentVariables environmentVariables;

    public WebDriverManagerSetup(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    protected WebDriverManager enhance(WebDriverManager webDriverManager) {
        List customEnhancers = ClassFinder.loadClasses().thatImplement(WebDriverManagerEnhancer.class).fromPackage("net.serenitybdd.plugins");
        String extensionPackageList = ThucydidesSystemProperty.SERENITY_EXTENSION_PACKAGES.from(this.environmentVariables);
        if (extensionPackageList != null) {
            List<String> extensionPackages = Arrays.asList(extensionPackageList.split(","));
            extensionPackages.forEach(extensionPackage -> customEnhancers.addAll(ClassFinder.loadClasses().thatImplement(WebDriverManagerEnhancer.class).fromPackage(extensionPackage)));
        }
        WebDriverManager enhancedDriverManager = webDriverManager;
        for (Class enhancerType : customEnhancers) {
            try {
                WebDriverManagerEnhancer enhancer = (WebDriverManagerEnhancer)enhancerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                enhancedDriverManager = enhancer.apply(webDriverManager);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return enhancedDriverManager;
    }

    public void forFirefox() {
        this.enhance(WebDriverManager.firefoxdriver()).setup();
    }

    public void forChrome() {
        this.enhance(WebDriverManager.chromedriver()).setup();
    }

    public void forEdge() {
        this.enhance(WebDriverManager.edgedriver()).setup();
    }

    public void forIE() {
        this.enhance(WebDriverManager.iedriver()).setup();
    }

    public void forOpera() {
        this.enhance(WebDriverManager.operadriver()).setup();
    }

    public void forSafari() {
        this.enhance(WebDriverManager.safaridriver()).setup();
    }

    public static WebDriverManagerSetup usingEnvironmentVariables(EnvironmentVariables environmentVariables) {
        return new WebDriverManagerSetup(environmentVariables);
    }
}

