/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.components;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Pattern;
import net.serenitybdd.core.webdriver.ConfigureFileDetector;
import net.thucydides.core.pages.components.FileToUploadCouldNotBeFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebElement;

public class FileToUpload {
    private final String requestedFilename;
    private String resolvedFilename;
    private static final String WINDOWS_PATH_PATTERN = "^[A-Z]:\\\\.*";
    private static Pattern fullWindowsPath = Pattern.compile("^[A-Z]:\\\\.*");
    private final WebDriver driver;
    private boolean remoteDriver = false;

    public FileToUpload(WebDriver driver, String requestedFilename) {
        this.driver = driver;
        this.requestedFilename = requestedFilename;
        this.resolvedFilename = this.resolveAsBestWeCan(requestedFilename);
    }

    private String resolveAsBestWeCan(String requestedFilename) {
        URL resourceOnTheClassPath = Optional.ofNullable(this.resourceOnClasspath(requestedFilename)).orElse(this.resourceOnClasspath(this.stripLeadingSlashFrom(requestedFilename)));
        String resolvedPath = resourceOnTheClassPath != null ? resourceOnTheClassPath.getPath() : this.getFileFromFileSystem(requestedFilename);
        return this.windowsSafe(resolvedPath);
    }

    private String windowsSafe(String resolvedPath) {
        return SystemUtils.IS_OS_WINDOWS && resolvedPath.startsWith("/") ? resolvedPath.substring(1) : resolvedPath;
    }

    private String stripLeadingSlashFrom(String requestedFilename) {
        return requestedFilename.startsWith("/") ? requestedFilename.substring(1) : requestedFilename;
    }

    private URL resourceOnClasspath(String filename) {
        ClassLoader cldr = Thread.currentThread().getContextClassLoader();
        return cldr.getResource(filename);
    }

    public static boolean isAFullWindowsPath(String filename) {
        return fullWindowsPath.matcher(filename).find();
    }

    private String getFileFromFileSystem(String filename) {
        File fileToUpload = new File(filename);
        return fileToUpload.getAbsolutePath();
    }

    public void to(WebElement uploadFileField) {
        String filePath = this.windowsSafe(this.uploadableFilePathTo(uploadFileField).forFile(this.resolvedFilename));
        this.checkThatFileExistsFor(filePath);
        uploadFileField.sendKeys(new CharSequence[]{this.osSpecificPathOf(filePath)});
    }

    private void checkThatFileExistsFor(String filePath) {
        if (!Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            throw new FileToUploadCouldNotBeFoundException(filePath);
        }
    }

    private FilePathLocator uploadableFilePathTo(WebElement uploadFileField) {
        return this.isRemoteDriver() ? new RemoteFilePathLocator(uploadFileField) : new LocalFilePathLocator();
    }

    private boolean isRemoteDriver() {
        return this.remoteDriver;
    }

    public FileToUpload useRemoteDriver(boolean remoteDriver) {
        this.remoteDriver = remoteDriver;
        return this;
    }

    private String osSpecificPathOf(String fileToUpload) {
        if (FileToUpload.isAFullWindowsPath(fileToUpload)) {
            return this.windowsNative(fileToUpload);
        }
        return fileToUpload;
    }

    private String windowsNative(String fileToUpload) {
        String bareFilename = fileToUpload.charAt(0) == '/' ? fileToUpload.substring(1) : fileToUpload;
        return StringUtils.replace((String)bareFilename, (String)"/", (String)"\\");
    }

    public FileToUpload fromLocalMachine() {
        ConfigureFileDetector.forDriver(this.driver);
        return this;
    }

    public FileToUpload fromClasspath() {
        URL systemResource = Optional.ofNullable(ClassLoader.getSystemResource(this.requestedFilename)).orElseThrow(() -> new InvalidArgumentException("File not found on classpath: " + this.requestedFilename));
        try {
            this.resolvedFilename = new File(systemResource.toURI()).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            new InvalidArgumentException("File not found on classpath: " + this.requestedFilename);
        }
        return this;
    }

    class RemoteFilePathLocator
    implements FilePathLocator {
        private final WebElement uploadFileField;

        RemoteFilePathLocator(WebElement uploadFileField) {
            this.uploadFileField = uploadFileField;
        }

        @Override
        public String forFile(String filename) {
            WebElement resolvedField;
            LocalFileDetector detector = new LocalFileDetector();
            File localFile = detector.getLocalFile(new CharSequence[]{FileToUpload.this.osSpecificPathOf(filename)});
            WebElement webElement = resolvedField = this.uploadFileField instanceof WrapsElement ? ((WrapsElement)this.uploadFileField).getWrappedElement() : this.uploadFileField;
            if (resolvedField instanceof RemoteWebElement) {
                ((RemoteWebElement)resolvedField).setFileDetector((FileDetector)detector);
            }
            return localFile.getAbsolutePath();
        }
    }

    static interface FilePathLocator {
        public String forFile(String var1);
    }

    private class LocalFilePathLocator
    implements FilePathLocator {
        LocalFilePathLocator() {
        }

        @Override
        public String forFile(String filename) {
            return FileToUpload.this.osSpecificPathOf(filename);
        }
    }
}

