/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.thucydides.core.webdriver.WebDriverFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageSourceRecorder {
    private final WebDriver driver;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String HTML_PRISM_HIGHLIGHT = "<html lang='en'><head><link href='prism/prism.css' rel='stylesheet' /></head><body><script src='prism/prism.js'></script><body><div><pre><code class='language-html'>";
    private static final String HTML_CLOSE = "</code></pre></div></body></html>";

    public PageSourceRecorder(WebDriver driver) {
        this.driver = driver;
    }

    public Optional<File> intoDirectory(Path path) {
        byte[] pageSource = this.render(this.getPageSource());
        if (WebDriverFactory.isAlive(this.driver) && pageSource.length > 0 && this.shouldRecordPageSource()) {
            try {
                Path pageSourceFile = Files.createTempFile(path, "pagesource", ".html", new FileAttribute[0]);
                Files.write(pageSourceFile, pageSource, new OpenOption[0]);
                return Optional.of(pageSourceFile.toFile());
            }
            catch (IOException couldNotCreatePageSourcce) {
                this.LOGGER.warn("Could not save the page source HTML file", (Throwable)couldNotCreatePageSourcce);
            }
        }
        return Optional.empty();
    }

    private boolean shouldRecordPageSource() {
        return false;
    }

    private byte[] render(byte[] pageSource) {
        Document document = Jsoup.parse((String)new String(pageSource));
        String prettyHtml = document.html();
        String pageBody = Arrays.stream(prettyHtml.split("\\n")).map(line -> line.replace("<", "&lt;").replace(">", "&gt;")).collect(Collectors.joining("<br/>" + System.lineSeparator()));
        String renderedPage = HTML_PRISM_HIGHLIGHT + pageBody + HTML_CLOSE;
        return renderedPage.getBytes();
    }

    private byte[] getPageSource() {
        try {
            String ps = this.driver.getPageSource();
            if (ps == null) {
                return new byte[0];
            }
            return ps.getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.LOGGER.warn("Failed to get page source", (Throwable)e);
            return new byte[0];
        }
    }
}

