/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.formatting;

import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import java.util.stream.Collectors;

public class ScenarioOutlineDescription {
    private final Scenario scenario;

    public ScenarioOutlineDescription(Scenario scenario) {
        this.scenario = scenario;
    }

    public static ScenarioOutlineDescription from(Scenario scenario) {
        return new ScenarioOutlineDescription(scenario);
    }

    public String getDescription() {
        return this.scenario.getSteps().stream().map(this::stepToString).collect(Collectors.joining(System.lineSeparator()));
    }

    private String stepToString(Step step) {
        String phrase = step.getKeyword() + step.getText();
        if (step.getDataTable() != null && step.getDataTable().isPresent()) {
            DataTable table = (DataTable)step.getDataTable().get();
            String tableAsString = "";
            for (TableRow row : table.getRows()) {
                tableAsString = tableAsString + "|";
                tableAsString = tableAsString + row.getCells().stream().map(TableCell::getValue).collect(Collectors.joining(" | "));
                tableAsString = tableAsString + "|" + System.lineSeparator();
            }
            phrase = phrase + System.lineSeparator() + tableAsString.trim();
        }
        return phrase;
    }
}

