/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.FeaturePathFormatter;
import io.cucumber.core.plugin.TestSourcesModel;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.Tag;
import io.cucumber.plugin.event.TestStep;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.model.domain.DataTable;
import net.thucydides.model.domain.DataTableRow;
import net.thucydides.model.domain.TestTag;
import org.jetbrains.annotations.NotNull;

class ScenarioContext {
    private final Queue<Step> stepQueue = new LinkedList<Step>();
    private final Queue<TestStep> testStepQueue = new LinkedList<TestStep>();
    private boolean examplesRunning;
    private boolean addingScenarioOutlineSteps = false;
    private DataTable table;
    Map<Long, Map<String, String>> exampleRows;
    Map<Long, List<Tag>> exampleTags;
    int exampleCount = 0;
    boolean waitingToProcessBackgroundSteps = false;
    private String currentScenarioId;
    Scenario currentScenarioDefinition;
    String currentScenario;
    List<Tag> featureTags = new ArrayList<Tag>();
    URI currentFeaturePath;
    private final FeaturePathFormatter featurePathFormatter = new FeaturePathFormatter();

    ScenarioContext() {
    }

    public void currentFeaturePathIs(URI featurePath) {
        this.currentFeaturePath = featurePath;
    }

    public Scenario currentScenarioOutline() {
        return this.currentScenarioDefinition;
    }

    public URI currentFeaturePath() {
        return this.currentFeaturePath;
    }

    public Queue<Step> getStepQueue() {
        return this.stepQueue;
    }

    public boolean examplesAreRunning() {
        return this.examplesRunning;
    }

    public Map<Long, Map<String, String>> getExampleRows() {
        return this.exampleRows;
    }

    public Map<Long, List<Tag>> getExampleTags() {
        return this.exampleTags;
    }

    public int getExampleCount() {
        return this.exampleCount;
    }

    public DataTable getTable() {
        return this.table;
    }

    public boolean isWaitingToProcessBackgroundSteps() {
        return this.waitingToProcessBackgroundSteps;
    }

    public String getCurrentScenarioId() {
        return this.currentScenarioId;
    }

    public void setCurrentScenarioId(String scenarioId) {
        this.currentScenarioId = scenarioId;
    }

    public Scenario getCurrentScenarioDefinition() {
        return this.currentScenarioDefinition;
    }

    public String getCurrentScenario() {
        return this.currentScenario;
    }

    public List<Tag> getFeatureTags() {
        return this.featureTags;
    }

    public boolean isAddingScenarioOutlineSteps() {
        return this.addingScenarioOutlineSteps;
    }

    public void doneAddingScenarioOutlineSteps() {
        this.addingScenarioOutlineSteps = false;
    }

    public void setFeatureTags(List<Tag> tags) {
        this.featureTags = new ArrayList<Tag>(tags);
    }

    public void setCurrentScenarioDefinitionFrom(TestSourcesModel.AstNode astNode) {
        this.currentScenarioDefinition = TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)astNode);
    }

    public boolean isAScenarioOutline() {
        return this.currentScenarioDefinition.getExamples().size() > 0;
    }

    public void startNewExample() {
        this.examplesRunning = true;
        this.addingScenarioOutlineSteps = true;
    }

    public void setExamplesRunning(boolean examplesRunning) {
        this.examplesRunning = examplesRunning;
    }

    public List<Tag> getScenarioTags() {
        return this.currentScenarioDefinition.getTags();
    }

    public String getScenarioName() {
        return this.currentScenarioDefinition.getName();
    }

    public List<Examples> getScenarioExamples() {
        return this.currentScenarioDefinition.getExamples();
    }

    public void clearStepQueue() {
        this.stepQueue.clear();
    }

    public void clearTestStepQueue() {
        this.testStepQueue.clear();
    }

    public void queueStep(Step step) {
        this.stepQueue.add(step);
    }

    public void queueTestStep(TestStep testStep) {
        this.testStepQueue.add(testStep);
    }

    public Step getCurrentStep() {
        return this.stepQueue.peek();
    }

    public Step nextStep() {
        return this.stepQueue.poll();
    }

    public TestStep nextTestStep() {
        return this.testStepQueue.poll();
    }

    public boolean noStepsAreQueued() {
        return this.stepQueue.isEmpty();
    }

    public boolean hasScenarioId(String scenarioId) {
        return this.currentScenarioId != null && this.currentScenarioId.equals(scenarioId);
    }

    public void setTable(DataTable table) {
        this.table = table;
        this.exampleCount = table.getSize();
    }

    public void addTableRows(List<String> headers, List<Map<String, String>> rows, String name, String description, Map<Integer, Long> lineNumbersOfEachRow) {
        this.table.startNewDataSet(name, description);
        AtomicInteger rowNumber = new AtomicInteger();
        rows.forEach(row -> this.table.appendRow(this.newRow(headers, lineNumbersOfEachRow, rowNumber.getAndIncrement(), (Map<String, String>)row)));
        this.table.updateLineNumbers(lineNumbersOfEachRow);
        this.exampleCount = this.table.getSize();
    }

    @NotNull
    private DataTableRow newRow(List<String> headers, Map<Integer, Long> lineNumbersOfEachRow, int rowNumber, Map<String, String> row) {
        return new DataTableRow(this.rowValuesFrom(headers, row), lineNumbersOfEachRow.getOrDefault(rowNumber, 0L).longValue());
    }

    private List<String> rowValuesFrom(List<String> headers, Map<String, String> row) {
        return headers.stream().map(row::get).collect(Collectors.toList());
    }

    public void addTableTags(List<TestTag> tags) {
        this.table.addTagsToLatestDataSet(tags);
    }

    public void clearTable() {
        this.table = null;
    }

    public StepEventBus stepEventBus() {
        URI prefixedPath = this.featurePathFormatter.featurePathWithPrefixIfNecessary(this.currentFeaturePath());
        return StepEventBus.eventBusFor((Object)prefixedPath);
    }
}

