/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.runners;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepPublisher;
import net.thucydides.model.domain.TestStep;
import org.junit.runners.model.Statement;

class SerenityStatement
extends Statement {
    private final Statement statement;
    private final StepPublisher publisher;

    SerenityStatement(Statement statement, StepPublisher publisher) {
        this.statement = statement;
        this.publisher = publisher;
    }

    StepEventBus stepEventBus() {
        if (this.publisher instanceof BaseStepListener) {
            return ((BaseStepListener)this.publisher).getEventBus();
        }
        return StepEventBus.getParallelEventBus();
    }

    public void evaluate() throws Throwable {
        try {
            this.updateCurrentEventBusFrom(this.publisher);
            this.statement.evaluate();
        }
        catch (Throwable throwable) {
            if (this.isAssumptionViolatedException(throwable)) {
                this.stepEventBus().assumptionViolated(throwable.getMessage());
            }
            if (throwable instanceof AssertionError) {
                if (!this.stepEventBus().aStepInTheCurrentTestHasFailed()) {
                    throw throwable;
                }
            }
            throw throwable;
        }
        this.checkForStepFailures();
        this.checkForAssumptionViolations();
    }

    private boolean isAssumptionViolatedException(Throwable throwable) {
        try {
            Class<?> clazz = Class.forName("org.junit.AssumptionViolatedException");
            return clazz.isInstance(throwable);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void updateCurrentEventBusFrom(StepPublisher publisher) {
        if (StepEventBus.getParallelEventBus() != this.stepEventBus()) {
            StepEventBus.overrideEventBusWith((StepEventBus)this.stepEventBus());
        }
    }

    private void checkForStepFailures() throws Throwable {
        if (this.publisher.aStepHasFailed()) {
            if (this.publisher.getTestFailureCause() != null) {
                throw this.publisher.getTestFailureCause().toException();
            }
            if (this.publisher.firstFailingStep().isPresent()) {
                throw ((TestStep)this.publisher.firstFailingStep().get()).getException().asException();
            }
        }
    }

    private void checkForAssumptionViolations() {
        if (this.stepEventBus().assumptionViolated()) {
            throw this.createAssumptionViolatedException(this.stepEventBus().getAssumptionViolatedMessage());
        }
    }

    private RuntimeException createAssumptionViolatedException(String message) {
        try {
            Class<?> clazz = Class.forName("org.junit.AssumptionViolatedException");
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return (RuntimeException)constructor.newInstance(message);
        }
        catch (ClassNotFoundException e) {
            System.err.println("AssumptionViolatedException class not found: " + e.getMessage());
            return new RuntimeException("Assumption violation occurred, but no handler class found.");
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            System.err.println("Error instantiating AssumptionViolatedException: " + e.getMessage());
            return new RuntimeException("Error during assumption violation exception handling.");
        }
    }
}

