/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import io.cucumber.tagexpressions.Expression;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.reports.html.CucumberCompatibleFilter;
import net.thucydides.core.reports.html.CucumberTagConverter;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;

public class RequirementsFilter
extends CucumberCompatibleFilter {
    public RequirementsFilter(EnvironmentVariables environmentVariables) {
        super(environmentVariables);
    }

    public boolean inDisplayOnlyTags(Requirement requirement) {
        Expression expectedTags = this.cucumberTagExpressionUsing(ThucydidesSystemProperty.TAGS);
        return this.requirementMatchesAnyTagIn(requirement, expectedTags);
    }

    private boolean requirementMatchesAnyTagIn(Requirement requirement, Expression expectedTags) {
        List<String> requirementTags = CucumberTagConverter.toStrings(requirement.getTags());
        if (expectedTags.evaluate(requirementTags) || this.matchExistsInScenarios(expectedTags, requirement)) {
            return true;
        }
        return this.hasChildWithMatchingTag(requirement, expectedTags);
    }

    private boolean matchExistsInScenarios(Expression expectedTags, Requirement requirement) {
        return requirement.getScenarioTags().values().stream().map(CucumberTagConverter::toStrings).anyMatch(arg_0 -> ((Expression)expectedTags).evaluate(arg_0));
    }

    private boolean hasChildWithMatchingTag(Requirement requirement, Expression expectedTags) {
        if (!requirement.hasChildren()) {
            return false;
        }
        return requirement.getNestedChildren().stream().anyMatch(child -> expectedTags.evaluate(CucumberTagConverter.toStrings(child.getTags())));
    }

    public List<Requirement> filteredByDisplayTag(List<Requirement> requirements) {
        return requirements.stream().filter(this::inDisplayOnlyTags).map(this::withFilteredChildren).collect(Collectors.toList());
    }

    private Requirement withFilteredChildren(Requirement requirement) {
        if (!requirement.hasChildren()) {
            return requirement;
        }
        return requirement.withChildren(this.filteredByDisplayTag(requirement.getChildren()));
    }
}

