/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports.cucumber;

import gherkin.ast.DataTable;
import gherkin.ast.Examples;
import gherkin.ast.Node;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.requirements.model.cucumber.ExampleRowResultIcon;

public class RenderCucumber {
    public static String step(Step step) {
        return step.getKeyword() + RenderCucumber.withEscapedParameterFields(step.getText()) + "  " + RenderCucumber.renderedArgument(step.getArgument());
    }

    private static String renderedArgument(Node argument) {
        if (argument instanceof DataTable) {
            return RenderCucumber.renderedDataTable((DataTable)argument);
        }
        if (argument instanceof Examples) {
            return RenderCucumber.renderedExamples((Examples)argument);
        }
        return "";
    }

    public static List<String> examples(List<Examples> examples, String featureName, String scenarioName) {
        ArrayList<String> renderedExamples = new ArrayList<String>();
        for (Examples exampleTable : examples) {
            renderedExamples.add(RenderCucumber.renderedExamples(exampleTable, featureName, scenarioName));
        }
        return renderedExamples;
    }

    private static String renderedExamples(Examples examples, String featureName, String scenarioName) {
        ExampleRowResultIcon exampleRowResultIcon = new ExampleRowResultIcon(featureName);
        StringBuffer renderedTable = new StringBuffer();
        RenderCucumber.renderExampleDescriptionOf(examples);
        renderedTable.append(RenderCucumber.renderExampleDescriptionOf(examples));
        RenderCucumber.addRow(renderedTable, examples.getTableHeader().getCells(), " ");
        RenderCucumber.addSeparatorCells(renderedTable, examples.getTableHeader().getCells().size());
        for (TableRow row : examples.getTableBody()) {
            RenderCucumber.addRow(renderedTable, row.getCells(), exampleRowResultIcon.resultToken(row.getLocation().getLine()));
        }
        return renderedTable.toString();
    }

    private static String renderExampleDescriptionOf(Examples examples) {
        StringBuffer renderedTable = new StringBuffer();
        renderedTable.append(examples.getKeyword()).append(": ");
        if (examples.getName() != null) {
            renderedTable.append(examples.getName());
        }
        renderedTable.append("  ").append(System.lineSeparator());
        if (examples.getDescription() != null) {
            renderedTable.append(System.lineSeparator()).append("> ").append(examples.getDescription().trim()).append(System.lineSeparator());
        }
        renderedTable.append(System.lineSeparator());
        return renderedTable.toString();
    }

    private static String renderedExamples(Examples examples) {
        StringBuffer renderedTable = new StringBuffer();
        renderedTable.append(RenderCucumber.renderExampleDescriptionOf(examples));
        RenderCucumber.addRow(renderedTable, examples.getTableHeader().getCells(), null);
        RenderCucumber.addSeparatorCells(renderedTable, examples.getTableHeader().getCells().size());
        for (TableRow row : examples.getTableBody()) {
            RenderCucumber.addRow(renderedTable, row.getCells(), null);
        }
        return renderedTable.toString();
    }

    private static String renderedDataTable(DataTable dataTable) {
        StringBuffer renderedTable = new StringBuffer();
        renderedTable.append("  ").append(System.lineSeparator());
        int firstRow = 0;
        TableRow header = (TableRow)dataTable.getRows().get(0);
        if (RenderCucumber.thereAreMultipleColumnsIn(dataTable)) {
            RenderCucumber.addRow(renderedTable, header.getCells());
            RenderCucumber.addSeparatorCells(renderedTable, header.getCells().size());
            ++firstRow;
        } else {
            RenderCucumber.addSeparatorCells(renderedTable, header.getCells().size());
        }
        for (int row = firstRow; row < dataTable.getRows().size(); ++row) {
            RenderCucumber.addRow(renderedTable, ((TableRow)dataTable.getRows().get(row)).getCells());
        }
        return renderedTable.toString();
    }

    private static boolean thereAreMultipleColumnsIn(DataTable dataTable) {
        return ((TableRow)dataTable.getRows().get(0)).getCells().size() > 1;
    }

    private static void addSeparatorCells(StringBuffer renderedTable, int columnCount) {
        renderedTable.append("|");
        for (int col = 0; col < columnCount; ++col) {
            renderedTable.append("-----------").append("|");
        }
        renderedTable.append("  ").append(System.lineSeparator());
    }

    private static void addRow(StringBuffer renderedTable, List<TableCell> cells) {
        RenderCucumber.addRow(renderedTable, cells, null);
    }

    private static void addRow(StringBuffer renderedTable, List<TableCell> cells, String statusToken) {
        renderedTable.append("|");
        for (TableCell cell : cells) {
            renderedTable.append(RenderCucumber.withEscapedParameterFields(cell.getValue())).append(" |");
        }
        if (statusToken != null) {
            renderedTable.append(statusToken + " |");
        }
        renderedTable.append("  ").append(System.lineSeparator());
    }

    private static String withEscapedParameterFields(String text) {
        return text.replace("<", "{").replace(">", "}");
    }
}

