/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultComparison;

public class DataTableRow {
    private final List<?> values;
    private final long lineNumber;
    private TestResult result;

    public DataTableRow(List<?> values) {
        this(values, 0L, TestResult.UNDEFINED);
    }

    public DataTableRow(List<?> values, long lineNumber) {
        this(values, lineNumber, TestResult.UNDEFINED);
    }

    public DataTableRow(List<?> values, long lineNumber, TestResult result) {
        this.values = values == null ? new ArrayList() : new ArrayList(values);
        this.result = result;
        this.lineNumber = lineNumber;
    }

    public List<?> getValues() {
        return this.values == null ? Collections.emptyList() : new ArrayList(this.values);
    }

    public List<String> getStringValues() {
        return this.getValues().stream().map(value -> value == null ? "" : value.toString()).collect(Collectors.toList());
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public TestResult getResult() {
        return this.result;
    }

    public void setResult(TestResult result) {
        this.result = result;
    }

    public void updateResult(TestResult newResult) {
        if (newResult == TestResult.UNDEFINED) {
            this.setResult(newResult);
        } else {
            this.setResult(TestResultComparison.overallResultFor(this.result, newResult));
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DataTableRow)) {
            return false;
        }
        return this.getValues().equals(((DataTableRow)other).getValues()) && this.lineNumber == ((DataTableRow)other).getLineNumber() && this.result == ((DataTableRow)other).getResult();
    }

    public boolean equalsIgnoringTheResult(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DataTableRow)) {
            return false;
        }
        return this.getValues().equals(((DataTableRow)other).getValues()) && this.lineNumber == ((DataTableRow)other).getLineNumber();
    }

    public String toString() {
        return "DataTableRow{values=" + this.getValues() + ", result=" + (Object)((Object)this.result) + '}';
    }
}

