/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.thucydides.core.adapters.TestFramework;

public class ClassInfoAnnotations {
    private final Class classInfo;

    public ClassInfoAnnotations(Class classInfo) {
        this.classInfo = classInfo;
    }

    public static ClassInfoAnnotations theClassDefinedIn(Class classInfo) {
        return new ClassInfoAnnotations(classInfo);
    }

    public boolean hasAnAnnotation(Class<? extends Annotation> ... annotationClasses) {
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            if (this.classInfo == null || this.classInfo.getAnnotation(annotationClass) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasAPackageAnnotation(Class<? extends Annotation> ... annotationClasses) {
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            if (this.classInfo == null || this.classInfo.getPackage().getAnnotation(annotationClass) == null) continue;
            return true;
        }
        return false;
    }

    public boolean containsTests() {
        return this.allMethods().stream().anyMatch(method -> TestFramework.support().isTestMethod((Method)method));
    }

    private Set<Method> allMethods() {
        Class<?>[] declaredInnerClasses;
        Class<?>[] innerClasses;
        HashSet<Method> allMethods = new HashSet<Method>();
        if (this.classInfo == null) {
            return new HashSet<Method>();
        }
        try {
            allMethods.addAll(Arrays.asList(this.classInfo.getMethods()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            allMethods.addAll(Arrays.asList(this.classInfo.getDeclaredMethods()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        for (Class<?> innerClass : innerClasses = this.classInfo.getClasses()) {
            allMethods.addAll(Arrays.asList(innerClass.getMethods()));
        }
        for (Class<?> innerClass : declaredInnerClasses = this.classInfo.getClasses()) {
            allMethods.addAll(Arrays.asList(innerClass.getDeclaredMethods()));
        }
        return allMethods;
    }
}

