/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.reports;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.model.collect.NewList;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.issues.IssueTracking;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.requirements.RequirementsMerger;
import net.thucydides.model.requirements.RequirementsProvided;
import net.thucydides.model.requirements.RequirementsTagProvider;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.model.RequirementTree;
import net.thucydides.model.requirements.reports.RequirementsOutcomeFactory;
import net.thucydides.model.requirements.reports.RequirementsOutcomes;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleSourceRequirmentsOutcomeFactory
implements RequirementsOutcomeFactory {
    private final List<RequirementsTagProvider> requirementsTagProviders;
    private final IssueTracking issueTracking;
    private final EnvironmentVariables environmentVariables;
    private final ReportNameProvider reportNameProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleSourceRequirmentsOutcomeFactory.class);

    public MultipleSourceRequirmentsOutcomeFactory(List<RequirementsTagProvider> requirementsTagProviders, IssueTracking issueTracking, ReportNameProvider reportNameProvider) {
        this(requirementsTagProviders, issueTracking, SystemEnvironmentVariables.currentEnvironmentVariables(), reportNameProvider);
    }

    public MultipleSourceRequirmentsOutcomeFactory(List<RequirementsTagProvider> requirementsTagProviders, IssueTracking issueTracking, EnvironmentVariables environmentVariables, ReportNameProvider reportNameProvider) {
        this.requirementsTagProviders = NewList.copyOf(requirementsTagProviders);
        this.issueTracking = issueTracking;
        this.environmentVariables = environmentVariables;
        this.reportNameProvider = reportNameProvider;
    }

    @Override
    public RequirementsOutcomes buildRequirementsOutcomesFrom(TestOutcomes testOutcomes) {
        List<Requirement> allRequirements = new ArrayList<Requirement>();
        LOGGER.debug("Loading requirements from tag providers :" + String.valueOf(this.requirementsTagProviders));
        for (RequirementsTagProvider tagProvider : this.requirementsTagProviders) {
            allRequirements = new RequirementsMerger().merge(allRequirements, RequirementsProvided.by(tagProvider));
        }
        Optional<String> overview = this.requirementsTagProviders.stream().map(RequirementsTagProvider::getOverview).filter(Optional::isPresent).map(overviewText -> (String)overviewText.get()).findFirst();
        LOGGER.debug("LOADED REQUIREMENTS:{}{}", (Object)System.lineSeparator(), (Object)RequirementTree.withRequirements(allRequirements));
        return new RequirementsOutcomes(allRequirements, testOutcomes, this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider, overview.orElse(""));
    }

    @Override
    public RequirementsOutcomes buildRequirementsOutcomesFrom(Requirement parentRequirement, TestOutcomes testOutcomes) {
        List<Requirement> childRequirements = parentRequirement.getChildren();
        return new RequirementsOutcomes(parentRequirement, childRequirements, testOutcomes, this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider, "");
    }
}

