/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.actions.WithChainableActions;
import org.openqa.selenium.interactions.Actions;

public abstract class ChainablePerformable
implements WithChainableActions {
    private List<Consumer<Actions>> actionsToPerform = new ArrayList<Consumer<Actions>>();

    protected ChainablePerformable() {
    }

    protected void addAction(Consumer<Actions> action) {
        this.actionsToPerform.add(action);
    }

    protected void addActionAtStart(Consumer<Actions> action) {
        this.actionsToPerform.add(0, action);
    }

    @Override
    public WithChainableActions andThen(Consumer<Actions> nextAction) {
        this.actionsToPerform.add(nextAction);
        return this;
    }

    public <T extends Actor> void performSubsequentActionsAs(Actor actor) {
        Actions browserActions = BrowseTheWeb.as(actor).withAction();
        this.actionsToPerform.forEach(action -> action.accept(browserActions));
        browserActions.build().perform();
    }
}

