/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.DefaultConverters;
import net.serenitybdd.screenplay.EnumValues;
import net.serenitybdd.screenplay.QuestionBuilder;

public interface Question<ANSWER> {
    public ANSWER answeredBy(Actor var1);

    default public String getSubject() {
        return "";
    }

    public static QuestionBuilder about(String subject) {
        return new QuestionBuilder(subject);
    }

    default public Question<Boolean> asBoolean() {
        return Question.about(this.getSubject()).answeredBy((Actor actor) -> Boolean.parseBoolean(String.valueOf(this.answeredBy(actor))));
    }

    public static Question<Boolean> not(Question<Boolean> question) {
        return Question.about(question.getSubject()).answeredBy((Actor actor) -> (Boolean)question.answeredBy(actor) == false);
    }

    default public Question<String> asString() {
        return Question.about(this.getSubject()).answeredBy((Actor actor) -> String.valueOf(this.answeredBy(actor)));
    }

    default public Question<Integer> asInteger() {
        return Question.about(this.getSubject()).answeredBy((Actor actor) -> Integer.parseInt(String.valueOf(this.answeredBy(actor))));
    }

    default public Question<Double> asDouble() {
        return Question.about(this.getSubject()).answeredBy((Actor actor) -> Double.parseDouble(String.valueOf(this.answeredBy(actor))));
    }

    default public Question<Float> asFloat() {
        return Question.about(this.getSubject()).answeredBy((Actor actor) -> Float.valueOf(Float.parseFloat(String.valueOf(this.answeredBy(actor)))));
    }

    default public Question<Long> asLong() {
        return Question.about(this.getSubject()).answeredBy((Actor actor) -> Long.parseLong(String.valueOf(this.answeredBy(actor))));
    }

    default public Question<BigDecimal> asBigDecimal() {
        return Question.about(this.getSubject()).answeredBy((Actor actor) -> new BigDecimal(String.valueOf(this.answeredBy(actor))));
    }

    default public Question<LocalDate> asADate() {
        return Question.about(this.getSubject()).answeredBy((Actor actor) -> LocalDate.parse(String.valueOf(this.answeredBy(actor))));
    }

    default public Question<LocalDate> asADate(String format) {
        return Question.about(this.getSubject()).answeredBy((Actor actor) -> LocalDate.parse(String.valueOf(this.answeredBy(actor)), DateTimeFormatter.ofPattern(format)));
    }

    default public <T> Question<T> asEnum(Class<T> enumType) {
        return Question.about(this.getSubject()).answeredBy((Actor actor) -> EnumValues.forType(enumType).getValueOf(String.valueOf(this.answeredBy(actor))));
    }

    default public <T> Question<T> map(Function<ANSWER, T> transformer) {
        return Question.about(this.getSubject()).answeredBy((Actor actor) -> transformer.apply(this.answeredBy(actor)));
    }

    default public <T> Question<Collection<T>> mapEach(Function<String, T> transformer) {
        return actor -> ((List)this.answeredBy(actor)).stream().map((? super T value) -> transformer.apply((String)value)).collect(Collectors.toList());
    }

    default public Question<ANSWER> describedAs(String description) {
        return Question.about(description).answeredBy(this::answeredBy);
    }

    default public Question<ANSWER> as(Class<ANSWER> type) {
        return actor -> DefaultConverters.converterFor(type).convert(this.answeredBy(actor));
    }

    default public <T> Question<List<T>> asListOf(Class<T> type) {
        return actor -> ((List)this.answeredBy(actor)).stream().map((? super T value) -> DefaultConverters.converterFor(type).convert(value)).collect(Collectors.toList());
    }

    default public <T> Question<Collection<T>> asCollectionOf(Class<T> type) {
        return actor -> ((List)this.answeredBy(actor)).stream().map((? super T value) -> DefaultConverters.converterFor(type).convert(value)).collect(Collectors.toList());
    }
}

