/*
 * Decompiled with CFR 0.152.
 */
package net.sf.alchim.mojo.yuicompressor;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import net.sf.alchim.mojo.yuicompressor.Aggregation;
import net.sf.alchim.mojo.yuicompressor.MojoSupport;
import net.sf.alchim.mojo.yuicompressor.SourceFile;
import net.sf.retrotranslator.runtime.java.lang._Long;
import net.sf.retrotranslator.runtime.java.lang._String;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class YuiCompressorMojo
extends MojoSupport {
    private String encoding;
    private String suffix;
    private boolean nosuffix;
    private int linebreakpos;
    private boolean nomunge;
    private boolean preserveAllSemiColons;
    private boolean disableOptimizations;
    private boolean force;
    private Aggregation[] aggregations;
    private boolean gzip;
    private boolean statistics;
    private long inSizeTotal_;
    private long outSizeTotal_;

    protected String[] getDefaultIncludes() throws Exception {
        return new String[]{"**/*.css", "**/*.js"};
    }

    public void beforeProcess() throws Exception {
        if (this.nosuffix) {
            this.suffix = "";
        }
    }

    protected void afterProcess() throws Exception {
        if (this.statistics && this.inSizeTotal_ > 0L) {
            this.getLog().info((CharSequence)_String.format((String)"total input (%db) -> output (%db)[%d%%]", (Object[])new Object[]{_Long.valueOf((long)this.inSizeTotal_), _Long.valueOf((long)this.outSizeTotal_), _Long.valueOf((long)(this.outSizeTotal_ * 100L / this.inSizeTotal_))}));
        }
        if (this.aggregations != null) {
            Aggregation[] aggregationArray = this.aggregations;
            int n = this.aggregations.length;
            int n2 = 0;
            while (n2 < n) {
                Aggregation aggregation = aggregationArray[n2];
                this.getLog().info((CharSequence)("generate aggregation : " + aggregation.output));
                aggregation.run();
                File gzipped = this.gzipIfRequested(aggregation.output);
                if (this.statistics) {
                    if (gzipped != null) {
                        this.getLog().info((CharSequence)_String.format((String)"%s (%db) -> %s (%db)[%d%%]", (Object[])new Object[]{aggregation.output.getName(), _Long.valueOf((long)aggregation.output.length()), gzipped.getName(), _Long.valueOf((long)gzipped.length()), _Long.valueOf((long)this.ratioOfSize(aggregation.output, gzipped))}));
                    } else if (aggregation.output.exists()) {
                        this.getLog().info((CharSequence)_String.format((String)"%s (%db)", (Object[])new Object[]{aggregation.output.getName(), _Long.valueOf((long)aggregation.output.length())}));
                    } else {
                        this.getLog().warn((CharSequence)_String.format((String)"%s not created", (Object[])new Object[]{aggregation.output.getName()}));
                    }
                }
                ++n2;
            }
        }
    }

    protected void processFile(SourceFile src) throws Exception {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("compress file :" + src.toFile() + " to " + src.toDestFile(this.suffix)));
        }
        File inFile = src.toFile();
        File outFile = src.toDestFile(this.suffix);
        this.getLog().debug((CharSequence)"only compress if input file is youger than existing output file");
        if (!this.force && outFile.exists() && outFile.lastModified() > inFile.lastModified()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("nothing to do, " + outFile + " is younger than original, use 'force' option or clean your target"));
            }
            return;
        }
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        File outFileTmp = new File(String.valueOf(outFile.getAbsolutePath()) + ".tmp");
        FileUtils.forceDelete((File)outFileTmp);
        try {
            Object compressor;
            in = new InputStreamReader((InputStream)new FileInputStream(inFile), this.encoding);
            if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
                throw new MojoExecutionException("Cannot create resource output directory: " + outFile.getParentFile());
            }
            this.getLog().debug((CharSequence)"use a temporary outputfile (in case in == out)");
            this.getLog().debug((CharSequence)"start compression");
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFileTmp), this.encoding);
            if (".js".equalsIgnoreCase(src.getExtension())) {
                compressor = new JavaScriptCompressor(in, this.jsErrorReporter_);
                ((JavaScriptCompressor)compressor).compress(out, this.linebreakpos, !this.nomunge, this.jswarn, this.preserveAllSemiColons, this.disableOptimizations);
            } else if (".css".equalsIgnoreCase(src.getExtension())) {
                compressor = new CssCompressor(in);
                ((CssCompressor)compressor).compress(out, this.linebreakpos);
            }
            this.getLog().debug((CharSequence)"end compression");
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((Reader)in);
        IOUtil.close((Writer)out);
        FileUtils.forceDelete((File)outFile);
        FileUtils.rename((File)outFileTmp, (File)outFile);
        File gzipped = this.gzipIfRequested(outFile);
        if (this.statistics) {
            this.inSizeTotal_ += inFile.length();
            this.outSizeTotal_ += outFile.length();
            this.getLog().info((CharSequence)_String.format((String)"%s (%db) -> %s (%db)[%d%%]", (Object[])new Object[]{inFile.getName(), _Long.valueOf((long)inFile.length()), outFile.getName(), _Long.valueOf((long)outFile.length()), _Long.valueOf((long)this.ratioOfSize(inFile, outFile))}));
            if (gzipped != null) {
                this.getLog().info((CharSequence)_String.format((String)"%s (%db) -> %s (%db)[%d%%]", (Object[])new Object[]{inFile.getName(), _Long.valueOf((long)inFile.length()), gzipped.getName(), _Long.valueOf((long)gzipped.length()), _Long.valueOf((long)this.ratioOfSize(inFile, gzipped))}));
            }
        }
    }

    protected File gzipIfRequested(File file) throws Exception {
        if (!this.gzip || file == null || !file.exists()) {
            return null;
        }
        if (".gz".equalsIgnoreCase(FileUtils.getExtension((String)file.getName()))) {
            return null;
        }
        File gzipped = new File(String.valueOf(file.getAbsolutePath()) + ".gz");
        this.getLog().debug((CharSequence)_String.format((String)"create gzip version : %s", (Object[])new Object[]{gzipped.getName()}));
        GZIPOutputStream out = null;
        FileInputStream in = null;
        try {
            out = new GZIPOutputStream(new FileOutputStream(gzipped));
            in = new FileInputStream(file);
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
        return gzipped;
    }

    protected long ratioOfSize(File file100, File fileX) throws Exception {
        long v100 = Math.max(file100.length(), 1L);
        long vX = Math.max(fileX.length(), 1L);
        return vX * 100L / v100;
    }
}

