/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.iconlabel;

import java.io.IOException;
import net.sf.jasperreports.components.ComponentsXmlWriter;
import net.sf.jasperreports.components.iconlabel.IconLabelComponent;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentXmlWriter;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.VersionComparator;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class IconLabelComponentXmlWriter
implements ComponentXmlWriter {
    private final JasperReportsContext jasperReportsContext;
    private final VersionComparator versionComparator;

    public IconLabelComponentXmlWriter(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.versionComparator = new VersionComparator();
    }

    @Override
    public boolean isToWrite(JRComponentElement componentElement, JRXmlWriter reportWriter) {
        String version = ComponentsXmlWriter.getVersion(this.jasperReportsContext, componentElement, reportWriter);
        return this.isNewerVersionOrEqual(version, "4.1.1");
    }

    @Override
    public void writeToXml(JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        Component component = componentElement.getComponent();
        if (component instanceof IconLabelComponent) {
            IconLabelComponent iconLabelComponent = (IconLabelComponent)component;
            ComponentKey componentKey = componentElement.getComponentKey();
            this.writeIconLabelComponent(iconLabelComponent, componentKey, reportWriter);
        }
    }

    protected void writeIconLabelComponent(IconLabelComponent iconLabelComponent, ComponentKey componentKey, JRXmlWriter reportWriter) throws IOException {
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        String namespaceURI = componentKey.getNamespace();
        String schemaLocation = ComponentsEnvironment.getInstance(this.jasperReportsContext).getBundle(namespaceURI).getXmlParser().getPublicSchemaLocation();
        XmlNamespace componentNamespace = new XmlNamespace(namespaceURI, componentKey.getNamespacePrefix(), schemaLocation);
        writer.startElement("iconLabel", componentNamespace);
        writer.addAttribute("iconPosition", iconLabelComponent.getIconPosition());
        writer.addAttribute("labelFill", iconLabelComponent.getLabelFill());
        writer.addAttribute("horizontalAlignment", iconLabelComponent.getOwnHorizontalImageAlign());
        writer.addAttribute("verticalAlignment", iconLabelComponent.getOwnVerticalImageAlign());
        reportWriter.writeBox(iconLabelComponent.getLineBox(), JRXmlWriter.JASPERREPORTS_NAMESPACE);
        writer.startElement("label", componentNamespace);
        reportWriter.writeTextField(iconLabelComponent.getLabelTextField());
        writer.closeElement();
        writer.startElement("icon", componentNamespace);
        reportWriter.writeTextField(iconLabelComponent.getIconTextField());
        writer.closeElement();
        writer.closeElement();
    }

    protected boolean isNewerVersionOrEqual(String currentVersion, String oldVersion) {
        return this.versionComparator.compare(currentVersion, oldVersion) >= 0;
    }
}

