/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.NPCPAttribute;
import com.ibm.as400.access.NPCPID;
import com.ibm.as400.access.NPCPIDAFPResource;
import com.ibm.as400.access.PrintObject;
import com.ibm.as400.access.PrintObjectImpl;
import com.ibm.as400.access.PrintObjectInputStream;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class AFPResource
extends PrintObject
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final String STR_FNTRSC = "FNTRSC";
    public static final String STR_FORMDF = "FORMDF";
    public static final String STR_OVL = "OVL";
    public static final String STR_PAGDFN = "PAGDFN";
    public static final String STR_PAGSEG = "PAGSEG";
    private static final String PATH = "path";

    AFPResource(AS400 aS400, NPCPIDAFPResource nPCPIDAFPResource, NPCPAttribute nPCPAttribute) {
        super(aS400, nPCPIDAFPResource, nPCPAttribute, 7);
    }

    public AFPResource() {
        super(null, null, 7);
    }

    public AFPResource(AS400 aS400, String string) {
        super(aS400, AFPResource.buildIDCodePoint(string), null, 7);
    }

    private static NPCPIDAFPResource buildIDCodePoint(String string) {
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        return new NPCPIDAFPResource(qSYSObjectPathName.getObjectName(), qSYSObjectPathName.getLibraryName(), qSYSObjectPathName.getObjectType());
    }

    @Override
    void chooseImpl() throws IOException, AS400SecurityException {
        AS400 aS400 = this.getSystem();
        if (aS400 == null) {
            Trace.log(2, "Attempt to use AFPResource before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectImpl)aS400.loadImpl2("com.ibm.as400.access.AFPResourceImplRemote", "com.ibm.as400.access.AFPResourceImplProxy");
        super.setImpl();
    }

    public PrintObjectInputStream getInputStream() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        PrintObjectInputStream printObjectInputStream = new PrintObjectInputStream(this, null);
        return printObjectInputStream;
    }

    public String getName() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return nPCPID.getStringValue(175);
    }

    public String getPath() {
        NPCPID nPCPID = this.getIDCodePoint();
        if (nPCPID == null) {
            return "";
        }
        return QSYSObjectPathName.toPath(nPCPID.getStringValue(174), nPCPID.getStringValue(175), ((NPCPIDAFPResource)nPCPID).getResourceType());
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null");
            throw new NullPointerException(PATH);
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'path' after connect.");
            throw new ExtendedIllegalStateException(PATH, 5);
        }
        String string2 = this.getPath();
        this.vetos.fireVetoableChange(PATH, string2, string);
        this.setIDCodePoint(AFPResource.buildIDCodePoint(string));
        this.changes.firePropertyChange(PATH, string2, string);
    }
}

