/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Certificate;
import com.ibm.as400.access.AS400CertificateAttribute;
import com.ibm.as400.access.AS400CertificateEvent;
import com.ibm.as400.access.AS400CertificateListener;
import com.ibm.as400.access.AS400CertificateUtilImpl;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class AS400CertificateUtil
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.AS400CertificateUtil";
    static final long serialVersionUID = 4L;
    public static final int DEFAULT_BUFFER_SIZE = 128;
    public static final int MAX_BUFFER_SIZE = 16384;
    public static final int MIN_BUFFER_SIZE = 8;
    String ifsPathName_;
    String libName_;
    String objectName_;
    String objectType_;
    String usrSpaceName_;
    AS400 system_ = null;
    transient boolean connected_ = false;
    transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    transient Vector certListeners_ = new Vector();
    transient VetoableChangeSupport vetos_ = new VetoableChangeSupport(this);
    String[] as400AttrS_;
    byte[][] as400AttrB_;
    int nextCertificateToReturn_ = 0;
    int nextCertificateOffset_ = -1;
    int numberCertificatesFound_ = 0;
    transient AS400CertificateUtilImpl impl_ = null;
    static final int EXTENDED_IO_EXCP = 1;
    static final int ILLEGAL_ARG_EXCP = 2;
    static final int ACCESS_EXCP = 3;
    static final int DOES_NOT_EXIST_EXCP = 4;
    static final int INTERNAL_ERR_EXCP = 5;
    static final int SUCCESS = 0;
    private String info_;

    public AS400CertificateUtil() {
    }

    public AS400CertificateUtil(AS400 aS400, String string) {
        this.system_ = aS400;
        if (null == this.system_) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.ifsPathName_ = string;
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        this.libName_ = qSYSObjectPathName.getLibraryName();
        this.objectName_ = qSYSObjectPathName.getObjectName();
        this.objectType_ = qSYSObjectPathName.getObjectType();
        if (null == this.libName_ || null == this.objectName_) {
            throw new ExtendedIllegalArgumentException("path", 3);
        }
    }

    public abstract void addCertificate(byte[] var1) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException;

    public synchronized void addAS400CertificateListener(AS400CertificateListener aS400CertificateListener) {
        this.certListeners_.addElement(aS400CertificateListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public abstract void deleteCertificate(byte[] var1) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException;

    public abstract void deleteCertificateByHandle(byte[] var1) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException;

    public AS400Certificate[] getCertificates(String string, int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.isConnected()) {
            this.connect();
        }
        this.setAS400UserSpaceName(string);
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("firstCertificateToReturn (" + n + ")", 4);
        }
        if (n2 < 8 || n2 > 16384) {
            throw new ExtendedIllegalArgumentException("buffSize (" + n2 + ")", 4);
        }
        int n3 = this.impl_.callgetCertificates(this.usrSpaceName_, n2 *= 1024, n, -1);
        if (n3 != 0) {
            this.throwException(this.impl_.cpfError_, this.ifsPathName_, n3);
        }
        if (this.impl_.certificates_ == null) {
            throw new ExtendedIOException("userSpaceName (" + string + ")", 40);
        }
        this.nextCertificateToReturn_ = this.impl_.certificates_.length + n;
        this.numberCertificatesFound_ = this.impl_.numberCertificatesFound_;
        this.nextCertificateOffset_ = this.impl_.nextCertificateOffsetOut_;
        if (this.nextCertificateToReturn_ >= this.numberCertificatesFound_) {
            this.nextCertificateToReturn_ = -1;
        }
        return this.impl_.certificates_;
    }

    public byte[] getCertificateHandle(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        if (null == byArray) {
            Trace.log(2, "Parameter 'certificate' is null.");
            throw new NullPointerException("certificate");
        }
        if (!this.isConnected()) {
            this.connect();
        }
        if ((n = this.impl_.callgetHandle(byArray, byArray.length)) != 0) {
            int n2 = n / 1000;
            int n3 = n % 1000;
            this.impl_.cpfError_ = null == this.impl_.cpfError_ || 0 == this.impl_.cpfError_.length() ? this.ifsPathName_ : this.impl_.cpfError_.trim() + ": " + this.ifsPathName_;
            switch (n2) {
                case 1: {
                    throw new ExtendedIOException(this.impl_.cpfError_, n3);
                }
            }
            throw new ExtendedIOException(this.impl_.cpfError_, 42);
        }
        return this.impl_.handle_;
    }

    public AS400Certificate[] getFirstCertificates(String string, int n) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.isConnected()) {
            this.connect();
        }
        this.setAS400UserSpaceName(string);
        if (n < 8 || n > 16384) {
            throw new ExtendedIllegalArgumentException("buffSize (" + n + ")", 4);
        }
        int n2 = this.impl_.callgetCertificates(this.usrSpaceName_, n *= 1024, 0, -1);
        if (n2 != 0) {
            this.throwException(this.impl_.cpfError_, this.ifsPathName_, n2);
        }
        if (this.impl_.certificates_ == null) {
            throw new ExtendedIOException("userSpaceName (" + string + ")", 40);
        }
        this.nextCertificateToReturn_ = this.impl_.certificates_.length;
        this.numberCertificatesFound_ = this.impl_.numberCertificatesFound_;
        this.nextCertificateOffset_ = this.impl_.nextCertificateOffsetOut_;
        if (this.nextCertificateToReturn_ >= this.numberCertificatesFound_) {
            this.nextCertificateToReturn_ = -1;
        }
        return this.impl_.certificates_;
    }

    public String getName() {
        if (this.ifsPathName_ == null) {
            return "";
        }
        return this.objectName_;
    }

    public AS400Certificate[] getNextCertificates(int n) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.isConnected()) {
            this.connect();
        }
        if (null == this.usrSpaceName_ || -1 == this.nextCertificateOffset_) {
            throw new ExtendedIOException(16);
        }
        if (0 > this.nextCertificateToReturn_) {
            return null;
        }
        if (n < 8 || n > 16384) {
            throw new ExtendedIllegalArgumentException("buffSize (" + n + ")", 4);
        }
        int n2 = this.impl_.callgetCertificates(this.usrSpaceName_, n *= 1024, this.nextCertificateToReturn_, this.nextCertificateOffset_);
        if (n2 != 0) {
            this.throwException(this.impl_.cpfError_, this.ifsPathName_, n2);
        }
        if (this.nextCertificateToReturn_ < this.numberCertificatesFound_) {
            if (this.impl_.certificates_ == null) {
                throw new ExtendedIOException("userSpaceName_ (" + this.usrSpaceName_ + ")", 40);
            }
            this.nextCertificateToReturn_ += this.impl_.certificates_.length;
            this.nextCertificateOffset_ = this.impl_.nextCertificateOffsetOut_;
        }
        if (this.nextCertificateToReturn_ >= this.numberCertificatesFound_) {
            this.nextCertificateToReturn_ = -1;
        }
        return this.impl_.certificates_;
    }

    public String getObjectInfo() {
        return this.info_;
    }

    public String getPath() {
        if (this.ifsPathName_ == null) {
            return "";
        }
        return this.ifsPathName_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public abstract int listCertificates(AS400CertificateAttribute[] var1, String var2) throws AS400SecurityException, ErrorCompletingRequestException, ExtendedIllegalArgumentException, ExtendedIOException, InterruptedException, IOException, ObjectDoesNotExistException;

    public synchronized void removeAS400CertificateListener(AS400CertificateListener aS400CertificateListener) {
        this.certListeners_.removeElement(aS400CertificateListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setObjectInfo(String string) {
        this.info_ = string;
    }

    public abstract void setPath(String var1) throws PropertyVetoException;

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.system_ == null) {
            this.system_ = aS400;
        } else {
            if (this.isConnected()) {
                Trace.log(2, "Parameter 'system' is not changed (Connected=true).");
                throw new ExtendedIllegalStateException("system", 5);
            }
            AS400 aS4002 = this.system_;
            this.vetos_.fireVetoableChange("system", aS4002, aS400);
            this.system_ = aS400;
            this.changes_.firePropertyChange("system", aS4002, aS400);
        }
    }

    void throwException(String object, String string, int n) throws AS400SecurityException, ExtendedIllegalArgumentException, ExtendedIOException, ObjectDoesNotExistException, InternalErrorException {
        int n2 = n / 1000;
        int n3 = n % 1000;
        object = null == object || 0 == ((String)object).length() ? string : ((String)object).trim() + ": " + string;
        switch (n2) {
            case 1: {
                throw new ExtendedIOException((String)object, n3);
            }
            case 2: {
                throw new ExtendedIllegalArgumentException((String)object, n3);
            }
            case 3: {
                throw new AS400SecurityException((String)object, n3);
            }
            case 4: {
                throw new ObjectDoesNotExistException((String)object, n3);
            }
            case 5: {
                throw new InternalErrorException((String)object, n3);
            }
        }
        throw new ExtendedIOException((String)object, 25);
    }

    void setAS400UserSpaceName(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'userSpaceName' is null.");
            throw new NullPointerException("userSpaceName");
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "USRSPC");
        String string2 = qSYSObjectPathName.getLibraryName();
        String string3 = qSYSObjectPathName.getObjectName();
        this.usrSpaceName_ = string3 + "          ";
        this.usrSpaceName_ = this.usrSpaceName_.substring(0, 10) + string2 + "          ";
        this.usrSpaceName_ = this.usrSpaceName_.substring(0, 20);
        this.usrSpaceName_ = this.usrSpaceName_.toUpperCase();
    }

    String getAS400UserSpaceName(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'userSpaceName' is null.");
            throw new NullPointerException("userSpaceName");
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "USRSPC");
        String string2 = qSYSObjectPathName.getLibraryName();
        String string3 = qSYSObjectPathName.getObjectName();
        Object object = string3 + "          ";
        object = ((String)object).substring(0, 10) + string2 + "          ";
        object = ((String)object).substring(0, 20);
        object = ((String)object).toUpperCase();
        return object;
    }

    boolean[] setSearchAttributes(AS400CertificateAttribute[] aS400CertificateAttributeArray) throws ExtendedIllegalArgumentException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        boolean[] blArray = new boolean[7];
        this.as400AttrS_ = new String[6];
        this.as400AttrB_ = new byte[1][0];
        if (null == aS400CertificateAttributeArray) {
            return blArray;
        }
        for (n = 0; n < aS400CertificateAttributeArray.length; ++n) {
            if (null == aS400CertificateAttributeArray[n]) continue;
            if (2 == aS400CertificateAttributeArray[n].getAttributeType()) {
                if (blArray[0]) {
                    bl2 = true;
                    break;
                }
                blArray[0] = true;
                this.as400AttrS_[0] = (String)aS400CertificateAttributeArray[n].getAttributeValue();
                continue;
            }
            if (7 == aS400CertificateAttributeArray[n].getAttributeType()) {
                if (blArray[1]) {
                    bl2 = true;
                    break;
                }
                blArray[1] = true;
                this.as400AttrS_[1] = (String)aS400CertificateAttributeArray[n].getAttributeValue();
                continue;
            }
            if (6 == aS400CertificateAttributeArray[n].getAttributeType()) {
                if (blArray[2]) {
                    bl2 = true;
                    break;
                }
                blArray[2] = true;
                this.as400AttrS_[2] = (String)aS400CertificateAttributeArray[n].getAttributeValue();
                continue;
            }
            if (4 == aS400CertificateAttributeArray[n].getAttributeType()) {
                if (blArray[3]) {
                    bl2 = true;
                    break;
                }
                blArray[3] = true;
                this.as400AttrS_[3] = (String)aS400CertificateAttributeArray[n].getAttributeValue();
                continue;
            }
            if (5 == aS400CertificateAttributeArray[n].getAttributeType()) {
                if (blArray[4]) {
                    bl2 = true;
                    break;
                }
                blArray[4] = true;
                this.as400AttrS_[4] = (String)aS400CertificateAttributeArray[n].getAttributeValue();
                continue;
            }
            if (3 == aS400CertificateAttributeArray[n].getAttributeType()) {
                if (blArray[5]) {
                    bl2 = true;
                    break;
                }
                blArray[5] = true;
                this.as400AttrS_[5] = (String)aS400CertificateAttributeArray[n].getAttributeValue();
                continue;
            }
            if (1 == aS400CertificateAttributeArray[n].getAttributeType()) {
                if (blArray[6]) {
                    bl2 = true;
                    break;
                }
                blArray[6] = true;
                this.as400AttrB_[0] = (byte[])aS400CertificateAttributeArray[n].getAttributeValue();
                continue;
            }
            bl = true;
            break;
        }
        if (bl2 || bl) {
            throw new ExtendedIllegalArgumentException("AS400CertificateAttribute (" + Integer.toString(n) + ")", 2);
        }
        return blArray;
    }

    abstract void connect() throws IOException;

    boolean isConnected() {
        return this.connected_;
    }

    void fireAdd() {
        Vector vector = (Vector)this.certListeners_.clone();
        AS400CertificateEvent aS400CertificateEvent = new AS400CertificateEvent(this, 0);
        for (int i = 0; i < vector.size(); ++i) {
            AS400CertificateListener aS400CertificateListener = (AS400CertificateListener)vector.elementAt(i);
            aS400CertificateListener.added(aS400CertificateEvent);
        }
    }

    void fireDelete() {
        Vector vector = (Vector)this.certListeners_.clone();
        AS400CertificateEvent aS400CertificateEvent = new AS400CertificateEvent(this, 1);
        for (int i = 0; i < vector.size(); ++i) {
            AS400CertificateListener aS400CertificateListener = (AS400CertificateListener)vector.elementAt(i);
            aS400CertificateListener.deleted(aS400CertificateEvent);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.connected_ = false;
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.certListeners_ = new Vector();
        this.nextCertificateToReturn_ = 0;
        this.nextCertificateOffset_ = -1;
        this.numberCertificatesFound_ = 0;
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
    }
}

