/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileRecordDescriptionEvent;
import com.ibm.as400.access.AS400FileRecordDescriptionImpl;
import com.ibm.as400.access.AS400FileRecordDescriptionListener;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RecordFormat;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;

public class AS400FileRecordDescription
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private String file_ = "";
    private String member_ = "";
    private String name_ = "";
    private AS400 system_ = null;
    transient Vector rdeListeners_;
    transient PropertyChangeSupport changes_;
    transient VetoableChangeSupport vetos_;
    private transient AS400FileRecordDescriptionImpl impl_;

    public AS400FileRecordDescription() {
        this.initializeTransient();
    }

    public AS400FileRecordDescription(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.initializeTransient();
        this.name_ = string;
        this.parseName();
        this.system_ = aS400;
    }

    public void addAS400FileRecordDescriptionListener(AS400FileRecordDescriptionListener aS400FileRecordDescriptionListener) {
        if (aS400FileRecordDescriptionListener == null) {
            throw new NullPointerException("listener");
        }
        this.rdeListeners_.addElement(aS400FileRecordDescriptionListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    private synchronized void chooseImpl() throws AS400SecurityException, IOException {
        if (this.impl_ == null) {
            this.impl_ = (AS400FileRecordDescriptionImpl)this.system_.loadImpl2("com.ibm.as400.access.AS400FileRecordDescriptionImplRemote", "com.ibm.as400.access.AS400FileRecordDescriptionImplProxy");
            this.impl_.setPath(this.name_);
            this.impl_.setSystem(this.system_.getImpl());
        }
        this.system_.signon(false);
    }

    public synchronized void createRecordFormatSource(String object, String string) throws AS400Exception, AS400SecurityException, IOException, InterruptedException {
        this.chooseImpl();
        String[] stringArray = this.impl_.createRecordFormatSource(string);
        String string2 = System.getProperty("file.separator");
        if (object != null) {
            if (((String)object).lastIndexOf(string2) != ((String)object).length() - string2.length()) {
                object = (String)object + string2;
            }
        } else {
            object = "";
        }
        for (int i = 0; i < stringArray.length / 2; ++i) {
            String string3 = (String)object + stringArray[i * 2];
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            PrintWriter printWriter = new PrintWriter(fileOutputStream, true);
            printWriter.print(stringArray[i * 2 + 1]);
            if (printWriter.checkError()) {
                printWriter.close();
                throw new InternalErrorException("Error writing to sourceFile.", 6);
            }
            printWriter.close();
        }
        Vector vector = (Vector)this.rdeListeners_.clone();
        AS400FileRecordDescriptionEvent aS400FileRecordDescriptionEvent = new AS400FileRecordDescriptionEvent(this, 2);
        for (int i = 0; i < vector.size(); ++i) {
            AS400FileRecordDescriptionListener aS400FileRecordDescriptionListener = (AS400FileRecordDescriptionListener)vector.elementAt(i);
            aS400FileRecordDescriptionListener.recordFormatSourceCreated(aS400FileRecordDescriptionEvent);
        }
    }

    private void parseName() {
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(this.name_);
        if (!qSYSObjectPathName.getObjectType().equals("FILE") && !qSYSObjectPathName.getObjectType().equals("MBR")) {
            throw new IllegalPathNameException(this.name_, 1);
        }
        this.file_ = qSYSObjectPathName.getObjectName();
        this.member_ = qSYSObjectPathName.getObjectType().equals("FILE") ? "*FIRST" : (qSYSObjectPathName.getMemberName().equalsIgnoreCase("*FILE") ? this.file_ : qSYSObjectPathName.getMemberName());
    }

    public String getFileName() {
        return this.file_;
    }

    public String getMemberName() {
        return this.member_;
    }

    public String getPath() {
        return this.name_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.rdeListeners_ = new Vector();
        this.impl_ = null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeAS400FileRecordDescriptionListener(AS400FileRecordDescriptionListener aS400FileRecordDescriptionListener) {
        if (aS400FileRecordDescriptionListener == null) {
            throw new NullPointerException("listener");
        }
        this.rdeListeners_.removeElement(aS400FileRecordDescriptionListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized RecordFormat[] retrieveRecordFormat() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.chooseImpl();
        RecordFormat[] recordFormatArray = this.impl_.retrieveRecordFormat();
        for (int i = 0; recordFormatArray != null && i < recordFormatArray.length; ++i) {
            recordFormatArray[i].initializeTextObjects(this.system_);
        }
        Vector vector = (Vector)this.rdeListeners_.clone();
        AS400FileRecordDescriptionEvent aS400FileRecordDescriptionEvent = new AS400FileRecordDescriptionEvent(this, 1);
        for (int i = 0; i < vector.size(); ++i) {
            AS400FileRecordDescriptionListener aS400FileRecordDescriptionListener = (AS400FileRecordDescriptionListener)vector.elementAt(i);
            aS400FileRecordDescriptionListener.recordFormatRetrieved(aS400FileRecordDescriptionEvent);
        }
        return recordFormatArray;
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        String string2 = this.name_;
        this.vetos_.fireVetoableChange("path", string2, string);
        this.name_ = string;
        this.parseName();
        if (this.impl_ != null) {
            this.impl_.setPath(this.name_);
        }
        this.changes_.firePropertyChange("path", string2, string);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        AS400 aS4002 = this.system_;
        this.vetos_.fireVetoableChange("system", aS4002, aS400);
        this.system_ = aS400;
        if (this.impl_ != null) {
            this.impl_.setSystem(this.system_.getImpl());
        }
        this.changes_.firePropertyChange("system", aS4002, this.system_);
    }
}

