/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCArrayResultSet;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLBoolean;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

public class AS400JDBCArray
implements java.sql.Array,
Serializable {
    private Object[] data_;
    private String typeName_;
    int typeCode_;
    private int vrm_;
    private transient AS400JDBCConnection con_;
    private transient SQLData contentTemplate_;
    private boolean isSQLData_ = false;

    AS400JDBCArray() {
    }

    AS400JDBCArray(String string, Object[] objectArray, int n, AS400JDBCConnection aS400JDBCConnection) throws SQLException {
        this.typeCode_ = JDUtilities.getTypeCode(string);
        this.typeName_ = JDUtilities.getTypeName(this.typeCode_);
        this.vrm_ = n;
        if (objectArray instanceof SQLData[]) {
            this.isSQLData_ = true;
            this.data_ = objectArray;
        } else {
            this.isSQLData_ = false;
            this.setArray(objectArray);
        }
        this.con_ = aS400JDBCConnection;
        this.contentTemplate_ = null;
        for (int i = 0; this.isSQLData_ && this.contentTemplate_ == null && i < this.data_.length; ++i) {
            if (this.data_[i] == null) continue;
            this.contentTemplate_ = (SQLData)this.data_[i];
        }
        if (this.contentTemplate_ == null) {
            this.contentTemplate_ = SQLDataFactory.newData(string, 1, 1, 1, 37, null, this.vrm_, aS400JDBCConnection == null ? null : aS400JDBCConnection.getProperties());
        }
    }

    @Override
    public synchronized void free() throws SQLException {
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.typeName_;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.contentTemplate_.getType();
    }

    @Override
    public synchronized Object getArray() throws SQLException {
        return this.getArrayX(1L, this.data_.length);
    }

    @Override
    public synchronized Object getArray(long l, int n) throws SQLException {
        if (l <= 0L) {
            JDError.throwSQLException("HY090", "" + l);
        }
        if (n < 0) {
            JDError.throwSQLException("HY090", "" + n);
        }
        if (l > (long)this.data_.length) {
            JDError.throwSQLException("HY090", "" + l);
        }
        if (l + (long)n > (long)(this.data_.length + 1)) {
            JDError.throwSQLException("HY090", l + "+" + n);
        }
        return this.getArrayX(l, n);
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        AS400JDBCArrayResultSet aS400JDBCArrayResultSet = new AS400JDBCArrayResultSet(this.data_, this.contentTemplate_, this.isSQLData_, this.getBaseType(), this.vrm_);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getResultSet");
        }
        return aS400JDBCArrayResultSet;
    }

    @Override
    public synchronized ResultSet getResultSet(long l, int n) throws SQLException {
        int n2 = (int)l - 1;
        Object[] objectArray = new Object[n];
        if (this.data_.length > 0) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.data_[i + n2];
            }
        } else {
            objectArray = this.data_;
        }
        AS400JDBCArrayResultSet aS400JDBCArrayResultSet = new AS400JDBCArrayResultSet(objectArray, this.contentTemplate_, this.isSQLData_, this.getBaseType(), this.vrm_);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getResultSet");
        }
        return aS400JDBCArrayResultSet;
    }

    public synchronized Object getArray(Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001", "getArray(java.util.Map)");
        return null;
    }

    public synchronized Object getArray(long l, int n, Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001", "getArray(long,int,Java.util.Map)");
        return null;
    }

    public synchronized ResultSet getResultSet(Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001", "getResultSet(java.util.Map)");
        return null;
    }

    public synchronized ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001", "getResultSet(long,int,java.util.Map)");
        return null;
    }

    private Object getArrayX(long l, int n) throws SQLException {
        int n2 = (int)l - 1;
        if (this.isSQLData_) {
            Object object;
            Class<?> clazz = null;
            try {
                object = this.contentTemplate_.getJavaClassName();
                if (((String)object).equals("com.ibm.as400.access.AS400JDBCBlob")) {
                    object = "java.sql.Blob";
                }
                clazz = Class.forName((String)object);
            }
            catch (Exception exception) {
                try {
                    clazz = Class.forName("java.lang.Object");
                }
                catch (Exception exception2) {
                    clazz = null;
                }
            }
            object = Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                Object object2;
                ((Object[])object)[i] = this.data_[i + n2] != null ? (object2 = ((SQLData)this.data_[i + n2]).getObject()) : null;
            }
            return object;
        }
        if (this.data_.length > 0 && !this.isSQLData_) {
            Object object = Array.newInstance(this.data_.getClass().getComponentType(), n);
            for (int i = 0; i < n; ++i) {
                ((Object[])object)[i] = this.data_[i + n2];
            }
            return object;
        }
        return this.data_;
    }

    private void setArray(Object object) throws SQLException {
        if (object == null) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "DB2Array.validate array is null 07006");
            }
            JDError.throwSQLException("07006", "null");
            return;
        }
        Class<?> clazz = object.getClass().getComponentType();
        String string = clazz.getName();
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setArray typeCode is " + this.typeCode_ + " arrayType is " + string);
        }
        switch (this.typeCode_) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if ("java.lang.String".equals(string)) {
                    String[] stringArray = (String[])object;
                    String[] stringArray2 = new String[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray2[i] = stringArray[i];
                    }
                    this.data_ = stringArray2;
                    break;
                }
                if ("java.math.BigDecimal".equals(string) || "java.lang.Boolean".equals(string) || "java.lang.Byte".equals(string) || "java.lang.Short".equals(string) || "java.lang.Integer".equals(string) || "java.lang.Long".equals(string) || "java.lang.Float".equals(string) || "java.lang.Double".equals(string) || "java.sql.Date".equals(string) || "java.sql.Time".equals(string) || "java.sql.Timestamp".equals(string) || JDUtilities.classIsInstanceOf(clazz, "java.math.BigDecimal") || JDUtilities.classIsInstanceOf(clazz, "java.sql.Date") || JDUtilities.classIsInstanceOf(clazz, "java.sql.Time") || JDUtilities.classIsInstanceOf(clazz, "java.sql.Timestamp")) {
                    Object[] objectArray = (Object[])object;
                    String[] stringArray = new String[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringArray[i] = objectArray[i] == null ? null : objectArray[i].toString();
                    }
                    this.data_ = stringArray;
                    break;
                }
                if (JDUtilities.classIsInstanceOf(clazz, "java.sql.Clob")) {
                    Clob[] clobArray = (Clob[])object;
                    String[] stringArray = new String[clobArray.length];
                    for (int i = 0; i < clobArray.length; ++i) {
                        if (clobArray[i] == null) {
                            stringArray[i] = null;
                            continue;
                        }
                        int n = (int)clobArray[i].length();
                        stringArray[i] = clobArray[i].getSubString(1L, n);
                    }
                    this.data_ = stringArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is CHAR/VARCHAR but array type is " + string);
                }
                JDError.throwSQLException("07006", string);
                break;
            }
            case 5: {
                if ("java.lang.Short".equals(string)) {
                    Short[] shortArray = (Short[])object;
                    Integer[] integerArray = new Integer[shortArray.length];
                    for (int i = 0; i < shortArray.length; ++i) {
                        integerArray[i] = shortArray[i] == null ? null : new Integer(shortArray[i].shortValue());
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("short".equals(string)) {
                    short[] sArray = (short[])object;
                    Integer[] integerArray = new Integer[sArray.length];
                    for (int i = 0; i < sArray.length; ++i) {
                        integerArray[i] = new Integer(sArray[i]);
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Integer".equals(string)) {
                    Integer[] integerArray = (Integer[])object;
                    Integer[] integerArray2 = new Integer[integerArray.length];
                    for (int i = 0; i < integerArray.length; ++i) {
                        integerArray2[i] = integerArray[i];
                    }
                    this.data_ = integerArray2;
                    break;
                }
                if ("int".equals(string)) {
                    int[] nArray = (int[])object;
                    Integer[] integerArray = new Integer[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        integerArray[i] = new Integer(nArray[i]);
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Long".equals(string)) {
                    Long[] longArray = (Long[])object;
                    Integer[] integerArray = new Integer[longArray.length];
                    for (int i = 0; i < longArray.length; ++i) {
                        if (longArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        long l = longArray[i];
                        if (l >= -32768L && l <= 32767L) {
                            integerArray[i] = new Integer((int)l);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is SMALLINT but value at index " + i + " is " + l);
                        }
                        JDError.throwSQLException("07006", "SMALLINT(" + l + ")");
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Float".equals(string)) {
                    Float[] floatArray = (Float[])object;
                    Integer[] integerArray = new Integer[floatArray.length];
                    for (int i = 0; i < floatArray.length; ++i) {
                        if (floatArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        float f = floatArray[i].floatValue();
                        if (f >= -32768.0f && f <= 32767.0f) {
                            integerArray[i] = new Integer((int)f);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is SMALLINT but value at index " + i + " is " + f);
                        }
                        JDError.throwSQLException("07006", "SMALLINT(" + f + ")");
                        return;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Double".equals(string)) {
                    Double[] doubleArray = (Double[])object;
                    Integer[] integerArray = new Integer[doubleArray.length];
                    for (int i = 0; i < doubleArray.length; ++i) {
                        if (doubleArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        double d = doubleArray[i];
                        if (d >= -32768.0 && d <= 32767.0) {
                            integerArray[i] = new Integer((int)d);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is SMALLINT but value at index " + i + " is " + d);
                        }
                        JDError.throwSQLException("07006", "SMALLINT(" + d + ")");
                        return;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(string)) {
                    BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                    Integer[] integerArray = new Integer[bigDecimalArray.length];
                    for (int i = 0; i < bigDecimalArray.length; ++i) {
                        if (bigDecimalArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        BigInteger bigInteger = bigDecimalArray[i].toBigInteger();
                        long l = bigInteger.longValue();
                        if (l >= -32768L && l <= 32767L) {
                            integerArray[i] = new Integer((int)l);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is SMALLINT but value at index " + i + " is " + l);
                        }
                        JDError.throwSQLException("07006", "SMALLINT(" + l + ")");
                        return;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Boolean".equals(string)) {
                    Boolean[] booleanArray = (Boolean[])object;
                    Integer[] integerArray = new Integer[booleanArray.length];
                    for (int i = 0; i < booleanArray.length; ++i) {
                        boolean bl;
                        integerArray[i] = booleanArray[i] == null ? null : ((bl = booleanArray[i].booleanValue()) ? new Integer(1) : new Integer(0));
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Byte".equals(string)) {
                    Byte[] byteArray = (Byte[])object;
                    Integer[] integerArray = new Integer[byteArray.length];
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (byteArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        byte by = byteArray[i];
                        integerArray[i] = new Integer(by);
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.String".equals(string)) {
                    String[] stringArray = (String[])object;
                    Integer[] integerArray = new Integer[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        try {
                            integerArray[i] = new Integer(Short.parseShort(stringArray[i]));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is SMALLINT but NumberFormatException thrown for string " + stringArray[i]);
                            }
                            JDError.throwSQLException("07006", "SMALLINT(" + stringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = integerArray;
                    break;
                }
                try {
                    Object[] objectArray = (Object[])object;
                    Integer[] integerArray = new Integer[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        try {
                            integerArray[i] = new Integer(Short.parseShort(objectArray[i].toString()));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is SMALLINT but NumberFormatException thrown for string " + objectArray[i]);
                            }
                            JDError.throwSQLException("07006", "SMALLINT(" + objectArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = integerArray;
                }
                catch (Exception exception) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "DB2Array.validate 07006 type is SMALLINT but array types is " + string);
                    }
                    JDError.throwSQLException("07006", "SMALLINT<>" + string);
                }
                break;
            }
            case 4: {
                if ("java.lang.Integer".equals(string)) {
                    Integer[] integerArray = (Integer[])object;
                    Integer[] integerArray3 = new Integer[integerArray.length];
                    for (int i = 0; i < integerArray.length; ++i) {
                        integerArray3[i] = integerArray[i];
                    }
                    this.data_ = integerArray3;
                    break;
                }
                if ("int".equals(string)) {
                    int[] nArray = (int[])object;
                    Integer[] integerArray = new Integer[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        integerArray[i] = new Integer(nArray[i]);
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(string)) {
                    BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                    Integer[] integerArray = new Integer[bigDecimalArray.length];
                    for (int i = 0; i < bigDecimalArray.length; ++i) {
                        if (bigDecimalArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        BigInteger bigInteger = bigDecimalArray[i].toBigInteger();
                        long l = bigInteger.longValue();
                        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                            integerArray[i] = new Integer((int)l);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is INTEGER but value at index " + i + " is " + l);
                        }
                        JDError.throwSQLException("07006", "INTEGER(" + l + ")");
                        return;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Long".equals(string)) {
                    Long[] longArray = (Long[])object;
                    Integer[] integerArray = new Integer[longArray.length];
                    for (int i = 0; i < longArray.length; ++i) {
                        if (longArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        long l = longArray[i];
                        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                            integerArray[i] = new Integer((int)l);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is SMALLINT but value at index " + i + " is " + l);
                        }
                        JDError.throwSQLException("07006", "SMALLINT(" + l + ")");
                        return;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Float".equals(string)) {
                    Float[] floatArray = (Float[])object;
                    Integer[] integerArray = new Integer[floatArray.length];
                    for (int i = 0; i < floatArray.length; ++i) {
                        if (floatArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        float f = floatArray[i].floatValue();
                        if (f >= -2.1474836E9f && f <= 2.1474836E9f) {
                            integerArray[i] = new Integer((int)f);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is INTEGER but value at index " + i + " is " + f);
                        }
                        JDError.throwSQLException("07006", "INTEGER(" + f + ")");
                        return;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Double".equals(string)) {
                    Double[] doubleArray = (Double[])object;
                    Integer[] integerArray = new Integer[doubleArray.length];
                    for (int i = 0; i < doubleArray.length; ++i) {
                        if (doubleArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        double d = doubleArray[i];
                        if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                            integerArray[i] = new Integer((int)d);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is INTEGER but value at index " + i + " is " + d);
                        }
                        JDError.throwSQLException("07006", "INTEGER(" + d + ")");
                        return;
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Boolean".equals(string)) {
                    Boolean[] booleanArray = (Boolean[])object;
                    Integer[] integerArray = new Integer[booleanArray.length];
                    for (int i = 0; i < booleanArray.length; ++i) {
                        boolean bl;
                        integerArray[i] = booleanArray[i] == null ? null : ((bl = booleanArray[i].booleanValue()) ? new Integer(1) : new Integer(0));
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Byte".equals(string)) {
                    Byte[] byteArray = (Byte[])object;
                    Integer[] integerArray = new Integer[byteArray.length];
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (byteArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        byte by = byteArray[i];
                        integerArray[i] = new Integer(by);
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.Short".equals(string)) {
                    Short[] shortArray = (Short[])object;
                    Integer[] integerArray = new Integer[shortArray.length];
                    for (int i = 0; i < shortArray.length; ++i) {
                        if (shortArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        short s = shortArray[i];
                        integerArray[i] = new Integer(s);
                    }
                    this.data_ = integerArray;
                    break;
                }
                if ("java.lang.String".equals(string)) {
                    String[] stringArray = (String[])object;
                    Integer[] integerArray = new Integer[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i] == null) {
                            integerArray[i] = null;
                            continue;
                        }
                        try {
                            integerArray[i] = new Integer(Integer.parseInt(stringArray[i]));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is INTEGER but NumberFormatException thrown for string " + stringArray[i]);
                            }
                            JDError.throwSQLException("07006", "INTEGER(" + stringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = integerArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is INTEGER but array types is " + string);
                }
                JDError.throwSQLException("07006", "INTEGER<>" + string);
                break;
            }
            case -5: {
                if ("java.lang.Long".equals(string)) {
                    Long[] longArray = (Long[])object;
                    Long[] longArray2 = new Long[longArray.length];
                    for (int i = 0; i < longArray.length; ++i) {
                        longArray2[i] = longArray[i];
                    }
                    this.data_ = longArray2;
                    break;
                }
                if ("long".equals(string)) {
                    long[] lArray = (long[])object;
                    Long[] longArray = new Long[lArray.length];
                    for (int i = 0; i < lArray.length; ++i) {
                        longArray[i] = new Long(lArray[i]);
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(string)) {
                    BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                    Long[] longArray = new Long[bigDecimalArray.length];
                    for (int i = 0; i < bigDecimalArray.length; ++i) {
                        if (bigDecimalArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        BigInteger bigInteger = bigDecimalArray[i].toBigInteger();
                        long l = bigInteger.longValue();
                        if (l >= Long.MIN_VALUE && l <= Long.MAX_VALUE) {
                            longArray[i] = new Long((int)l);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is BIGINT but value at index " + i + " is " + l);
                        }
                        JDError.throwSQLException("07006", "BIGINT(" + l + ")");
                        return;
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.Boolean".equals(string)) {
                    Boolean[] booleanArray = (Boolean[])object;
                    Long[] longArray = new Long[booleanArray.length];
                    for (int i = 0; i < booleanArray.length; ++i) {
                        boolean bl;
                        longArray[i] = booleanArray[i] == null ? null : ((bl = booleanArray[i].booleanValue()) ? new Long(1L) : new Long(0L));
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.Float".equals(string)) {
                    Float[] floatArray = (Float[])object;
                    Long[] longArray = new Long[floatArray.length];
                    for (int i = 0; i < floatArray.length; ++i) {
                        if (floatArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        float f = floatArray[i].floatValue();
                        if (f >= -9.223372E18f && f <= 9.223372E18f) {
                            longArray[i] = new Long((int)f);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is LONG but value at index " + i + " is " + f);
                        }
                        JDError.throwSQLException("07006", "BIGINT(" + f + ")");
                        return;
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.Double".equals(string)) {
                    Double[] doubleArray = (Double[])object;
                    Long[] longArray = new Long[doubleArray.length];
                    for (int i = 0; i < doubleArray.length; ++i) {
                        if (doubleArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        double d = doubleArray[i];
                        if (d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                            longArray[i] = new Long((int)d);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is BIGINT but value at index " + i + " is " + d);
                        }
                        JDError.throwSQLException("07006", "BIGINT(" + d + ")");
                        return;
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.Byte".equals(string)) {
                    Byte[] byteArray = (Byte[])object;
                    Long[] longArray = new Long[byteArray.length];
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (byteArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        byte by = byteArray[i];
                        longArray[i] = new Long(by);
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.Short".equals(string)) {
                    Short[] shortArray = (Short[])object;
                    Long[] longArray = new Long[shortArray.length];
                    for (int i = 0; i < shortArray.length; ++i) {
                        if (shortArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        short s = shortArray[i];
                        longArray[i] = new Long(s);
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.Integer".equals(string)) {
                    Integer[] integerArray = (Integer[])object;
                    Long[] longArray = new Long[integerArray.length];
                    for (int i = 0; i < integerArray.length; ++i) {
                        if (integerArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        int n = integerArray[i];
                        longArray[i] = new Long(n);
                    }
                    this.data_ = longArray;
                    break;
                }
                if ("java.lang.String".equals(string)) {
                    String[] stringArray = (String[])object;
                    Long[] longArray = new Long[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i] == null) {
                            longArray[i] = null;
                            continue;
                        }
                        try {
                            longArray[i] = new Long(Long.parseLong(stringArray[i]));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is BIGINT but NumberFormatException thrown for string " + stringArray[i]);
                            }
                            JDError.throwSQLException("07006", "BIGINT(" + stringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = longArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is BIGINT but array types is " + string);
                }
                JDError.throwSQLException("07006", "BIGINT<>" + string);
                return;
            }
            case 7: {
                if ("java.lang.Float".equals(string)) {
                    Float[] floatArray = (Float[])object;
                    Float[] floatArray2 = new Float[floatArray.length];
                    for (int i = 0; i < floatArray.length; ++i) {
                        floatArray2[i] = floatArray[i];
                    }
                    this.data_ = floatArray2;
                    break;
                }
                if ("float".equals(string)) {
                    float[] fArray = (float[])object;
                    Float[] floatArray = new Float[fArray.length];
                    for (int i = 0; i < fArray.length; ++i) {
                        floatArray[i] = new Float(fArray[i]);
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Short".equals(string)) {
                    Short[] shortArray = (Short[])object;
                    Float[] floatArray = new Float[shortArray.length];
                    for (int i = 0; i < shortArray.length; ++i) {
                        floatArray[i] = shortArray[i] == null ? null : new Float(shortArray[i].shortValue());
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("short".equals(string)) {
                    short[] sArray = (short[])object;
                    Float[] floatArray = new Float[sArray.length];
                    for (int i = 0; i < sArray.length; ++i) {
                        floatArray[i] = new Float(sArray[i]);
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Integer".equals(string)) {
                    Integer[] integerArray = (Integer[])object;
                    Float[] floatArray = new Float[integerArray.length];
                    for (int i = 0; i < integerArray.length; ++i) {
                        floatArray[i] = integerArray[i] == null ? null : new Float(integerArray[i].floatValue());
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("int".equals(string)) {
                    int[] nArray = (int[])object;
                    Float[] floatArray = new Float[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        floatArray[i] = new Float(nArray[i]);
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Long".equals(string)) {
                    Long[] longArray = (Long[])object;
                    Float[] floatArray = new Float[longArray.length];
                    for (int i = 0; i < longArray.length; ++i) {
                        if (longArray[i] == null) {
                            floatArray[i] = null;
                            continue;
                        }
                        long l = longArray[i];
                        if ((float)l >= -3.4028235E38f && (float)l <= Float.MAX_VALUE) {
                            floatArray[i] = new Float(l);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is REAL but value at index " + i + " is " + l);
                        }
                        JDError.throwSQLException("07006", "REAL(" + l + ")");
                        return;
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Float".equals(string)) {
                    Float[] floatArray = (Float[])object;
                    Float[] floatArray3 = new Float[floatArray.length];
                    for (int i = 0; i < floatArray.length; ++i) {
                        if (floatArray[i] == null) {
                            floatArray3[i] = null;
                            continue;
                        }
                        float f = floatArray[i].floatValue();
                        if (f >= -3.4028235E38f && f <= Float.MAX_VALUE) {
                            floatArray3[i] = new Float(f);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is REAL but value at index " + i + " is " + f);
                        }
                        JDError.throwSQLException("07006", "REAL(" + f + ")");
                        return;
                    }
                    this.data_ = floatArray3;
                    break;
                }
                if ("java.lang.Double".equals(string)) {
                    Double[] doubleArray = (Double[])object;
                    Float[] floatArray = new Float[doubleArray.length];
                    for (int i = 0; i < doubleArray.length; ++i) {
                        if (doubleArray[i] == null) {
                            floatArray[i] = null;
                            continue;
                        }
                        double d = doubleArray[i];
                        if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
                            floatArray[i] = new Float(d);
                            continue;
                        }
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "DB2Array.setArray 07006 type is REAL but value at index " + i + " is " + d);
                        }
                        JDError.throwSQLException("07006", "REAL(" + d + ")");
                        return;
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(string)) {
                    BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                    Float[] floatArray = new Float[bigDecimalArray.length];
                    for (int i = 0; i < bigDecimalArray.length; ++i) {
                        if (bigDecimalArray[i] == null) {
                            floatArray[i] = null;
                            continue;
                        }
                        float f = bigDecimalArray[i].floatValue();
                        if (f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.setArray 07006 type is REAL but value at index " + i + " is " + f);
                            }
                            JDError.throwSQLException("07006", "REAL(" + f + ")");
                            return;
                        }
                        floatArray[i] = new Float(f);
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Boolean".equals(string)) {
                    Boolean[] booleanArray = (Boolean[])object;
                    Float[] floatArray = new Float[booleanArray.length];
                    for (int i = 0; i < booleanArray.length; ++i) {
                        boolean bl;
                        floatArray[i] = booleanArray[i] == null ? null : ((bl = booleanArray[i].booleanValue()) ? new Float(1.0f) : new Float(0.0f));
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.Byte".equals(string)) {
                    Byte[] byteArray = (Byte[])object;
                    Float[] floatArray = new Float[byteArray.length];
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (byteArray[i] == null) {
                            floatArray[i] = null;
                            continue;
                        }
                        byte by = byteArray[i];
                        floatArray[i] = new Float(by);
                    }
                    this.data_ = floatArray;
                    break;
                }
                if ("java.lang.String".equals(string)) {
                    String[] stringArray = (String[])object;
                    Float[] floatArray = new Float[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i] == null) {
                            floatArray[i] = null;
                            continue;
                        }
                        try {
                            floatArray[i] = new Float(Float.parseFloat(stringArray[i]));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is REAL but NumberFormatException thrown for string " + stringArray[i]);
                            }
                            JDError.throwSQLException("07006", "REAL(" + stringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = floatArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is REAL but array types is " + string);
                }
                JDError.throwSQLException("07006", "REAL<>" + string);
                break;
            }
            case 6: {
                if ("java.lang.Double".equals(string)) {
                    Double[] doubleArray = (Double[])object;
                    Double[] doubleArray2 = new Double[doubleArray.length];
                    for (int i = 0; i < doubleArray.length; ++i) {
                        doubleArray2[i] = doubleArray[i];
                    }
                    this.data_ = doubleArray2;
                    break;
                }
                if ("double".equals(string)) {
                    double[] dArray = (double[])object;
                    Double[] doubleArray = new Double[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        doubleArray[i] = new Double(dArray[i]);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Float".equals(string)) {
                    Float[] floatArray = (Float[])object;
                    Double[] doubleArray = new Double[floatArray.length];
                    for (int i = 0; i < floatArray.length; ++i) {
                        doubleArray[i] = floatArray[i] == null ? null : new Double(floatArray[i].doubleValue());
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("float".equals(string)) {
                    float[] fArray = (float[])object;
                    Double[] doubleArray = new Double[fArray.length];
                    for (int i = 0; i < fArray.length; ++i) {
                        doubleArray[i] = new Double(fArray[i]);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Short".equals(string)) {
                    Short[] shortArray = (Short[])object;
                    Double[] doubleArray = new Double[shortArray.length];
                    for (int i = 0; i < shortArray.length; ++i) {
                        doubleArray[i] = shortArray[i] == null ? null : new Double(shortArray[i].shortValue());
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("short".equals(string)) {
                    short[] sArray = (short[])object;
                    Double[] doubleArray = new Double[sArray.length];
                    for (int i = 0; i < sArray.length; ++i) {
                        doubleArray[i] = new Double(sArray[i]);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Integer".equals(string)) {
                    Integer[] integerArray = (Integer[])object;
                    Double[] doubleArray = new Double[integerArray.length];
                    for (int i = 0; i < integerArray.length; ++i) {
                        doubleArray[i] = integerArray[i] == null ? null : new Double(integerArray[i].doubleValue());
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("int".equals(string)) {
                    int[] nArray = (int[])object;
                    Double[] doubleArray = new Double[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        doubleArray[i] = new Double(nArray[i]);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Long".equals(string)) {
                    Long[] longArray = (Long[])object;
                    Double[] doubleArray = new Double[longArray.length];
                    for (int i = 0; i < longArray.length; ++i) {
                        if (longArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        long l = longArray[i];
                        doubleArray[i] = new Double(l);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(string)) {
                    BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                    Double[] doubleArray = new Double[bigDecimalArray.length];
                    for (int i = 0; i < bigDecimalArray.length; ++i) {
                        if (bigDecimalArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        double d = bigDecimalArray[i].doubleValue();
                        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.setArray 07006 type is Double but value at index " + i + " is " + d);
                            }
                            JDError.throwSQLException("07006", "DOUBLE(" + d + ")");
                            return;
                        }
                        doubleArray[i] = new Double(d);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Boolean".equals(string)) {
                    Boolean[] booleanArray = (Boolean[])object;
                    Double[] doubleArray = new Double[booleanArray.length];
                    for (int i = 0; i < booleanArray.length; ++i) {
                        boolean bl;
                        doubleArray[i] = booleanArray[i] == null ? null : ((bl = booleanArray[i].booleanValue()) ? new Double(1.0) : new Double(0.0));
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Byte".equals(string)) {
                    Byte[] byteArray = (Byte[])object;
                    Double[] doubleArray = new Double[byteArray.length];
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (byteArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        byte by = byteArray[i];
                        doubleArray[i] = new Double(by);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.String".equals(string)) {
                    String[] stringArray = (String[])object;
                    Double[] doubleArray = new Double[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        try {
                            doubleArray[i] = new Double(Double.parseDouble(stringArray[i]));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is Double but NumberFormatException thrown for string " + stringArray[i]);
                            }
                            JDError.throwSQLException("07006", "DOUBLE(" + stringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is DOUBLE but array types is " + string);
                }
                JDError.throwSQLException("07006", "DOUBLE<>" + string);
                break;
            }
            case 8: {
                if ("java.lang.Double".equals(string)) {
                    Double[] doubleArray = (Double[])object;
                    Double[] doubleArray3 = new Double[doubleArray.length];
                    for (int i = 0; i < doubleArray.length; ++i) {
                        doubleArray3[i] = doubleArray[i];
                    }
                    this.data_ = doubleArray3;
                    break;
                }
                if ("double".equals(string)) {
                    double[] dArray = (double[])object;
                    Double[] doubleArray = new Double[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        doubleArray[i] = new Double(dArray[i]);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Float".equals(string)) {
                    Float[] floatArray = (Float[])object;
                    Double[] doubleArray = new Double[floatArray.length];
                    for (int i = 0; i < floatArray.length; ++i) {
                        doubleArray[i] = floatArray[i] == null ? null : new Double(floatArray[i].doubleValue());
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("float".equals(string)) {
                    float[] fArray = (float[])object;
                    Double[] doubleArray = new Double[fArray.length];
                    for (int i = 0; i < fArray.length; ++i) {
                        doubleArray[i] = new Double(fArray[i]);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Short".equals(string)) {
                    Short[] shortArray = (Short[])object;
                    Double[] doubleArray = new Double[shortArray.length];
                    for (int i = 0; i < shortArray.length; ++i) {
                        doubleArray[i] = shortArray[i] == null ? null : new Double(shortArray[i].shortValue());
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("short".equals(string)) {
                    short[] sArray = (short[])object;
                    Double[] doubleArray = new Double[sArray.length];
                    for (int i = 0; i < sArray.length; ++i) {
                        doubleArray[i] = new Double(sArray[i]);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Integer".equals(string)) {
                    Integer[] integerArray = (Integer[])object;
                    Double[] doubleArray = new Double[integerArray.length];
                    for (int i = 0; i < integerArray.length; ++i) {
                        doubleArray[i] = integerArray[i] == null ? null : new Double(integerArray[i].doubleValue());
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("int".equals(string)) {
                    int[] nArray = (int[])object;
                    Double[] doubleArray = new Double[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        doubleArray[i] = new Double(nArray[i]);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Long".equals(string)) {
                    Long[] longArray = (Long[])object;
                    Double[] doubleArray = new Double[longArray.length];
                    for (int i = 0; i < longArray.length; ++i) {
                        if (longArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        long l = longArray[i];
                        doubleArray[i] = new Double(l);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(string)) {
                    BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                    Double[] doubleArray = new Double[bigDecimalArray.length];
                    for (int i = 0; i < bigDecimalArray.length; ++i) {
                        if (bigDecimalArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        double d = bigDecimalArray[i].doubleValue();
                        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.setArray 07006 type is Double but value at index " + i + " is " + d);
                            }
                            JDError.throwSQLException("07006", "DOUBLE(" + d + ")");
                            return;
                        }
                        doubleArray[i] = new Double(d);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Boolean".equals(string)) {
                    Boolean[] booleanArray = (Boolean[])object;
                    Double[] doubleArray = new Double[booleanArray.length];
                    for (int i = 0; i < booleanArray.length; ++i) {
                        boolean bl;
                        doubleArray[i] = booleanArray[i] == null ? null : ((bl = booleanArray[i].booleanValue()) ? new Double(1.0) : new Double(0.0));
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.Byte".equals(string)) {
                    Byte[] byteArray = (Byte[])object;
                    Double[] doubleArray = new Double[byteArray.length];
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (byteArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        byte by = byteArray[i];
                        doubleArray[i] = new Double(by);
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if ("java.lang.String".equals(string)) {
                    String[] stringArray = (String[])object;
                    Double[] doubleArray = new Double[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i] == null) {
                            doubleArray[i] = null;
                            continue;
                        }
                        try {
                            doubleArray[i] = new Double(Double.parseDouble(stringArray[i]));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is Double but NumberFormatException thrown for string " + stringArray[i]);
                            }
                            JDError.throwSQLException("07006", "DOUBLE(" + stringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = doubleArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is DOUBLE/FLOAT but array types is " + string);
                }
                JDError.throwSQLException("07006", "DOUBLE<>" + string);
                break;
            }
            case -360: 
            case 2: 
            case 3: {
                if (JDUtilities.classIsInstanceOf(clazz, "java.math.BigDecimal")) {
                    BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                    BigDecimal[] bigDecimalArray2 = new BigDecimal[bigDecimalArray.length];
                    for (int i = 0; i < bigDecimalArray.length; ++i) {
                        bigDecimalArray2[i] = bigDecimalArray[i];
                    }
                    this.data_ = bigDecimalArray2;
                    break;
                }
                if ("java.lang.Double".equals(string)) {
                    Double[] doubleArray = (Double[])object;
                    BigDecimal[] bigDecimalArray = new BigDecimal[doubleArray.length];
                    for (int i = 0; i < doubleArray.length; ++i) {
                        bigDecimalArray[i] = doubleArray[i] == null ? null : new BigDecimal(doubleArray[i]);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("double".equals(string)) {
                    double[] dArray = (double[])object;
                    BigDecimal[] bigDecimalArray = new BigDecimal[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        bigDecimalArray[i] = new BigDecimal(dArray[i]);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.Float".equals(string)) {
                    Float[] floatArray = (Float[])object;
                    BigDecimal[] bigDecimalArray = new BigDecimal[floatArray.length];
                    for (int i = 0; i < floatArray.length; ++i) {
                        bigDecimalArray[i] = floatArray[i] == null ? null : new BigDecimal(floatArray[i].doubleValue());
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("float".equals(string)) {
                    float[] fArray = (float[])object;
                    BigDecimal[] bigDecimalArray = new BigDecimal[fArray.length];
                    for (int i = 0; i < fArray.length; ++i) {
                        bigDecimalArray[i] = new BigDecimal(fArray[i]);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.Short".equals(string)) {
                    Short[] shortArray = (Short[])object;
                    BigDecimal[] bigDecimalArray = new BigDecimal[shortArray.length];
                    for (int i = 0; i < shortArray.length; ++i) {
                        bigDecimalArray[i] = shortArray[i] == null ? null : new BigDecimal(shortArray[i].doubleValue());
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("short".equals(string)) {
                    short[] sArray = (short[])object;
                    BigDecimal[] bigDecimalArray = new BigDecimal[sArray.length];
                    for (int i = 0; i < sArray.length; ++i) {
                        bigDecimalArray[i] = new BigDecimal((double)sArray[i]);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.Integer".equals(string)) {
                    Integer[] integerArray = (Integer[])object;
                    BigDecimal[] bigDecimalArray = new BigDecimal[integerArray.length];
                    for (int i = 0; i < integerArray.length; ++i) {
                        bigDecimalArray[i] = integerArray[i] == null ? null : new BigDecimal(integerArray[i].doubleValue());
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("int".equals(string)) {
                    int[] nArray = (int[])object;
                    BigDecimal[] bigDecimalArray = new BigDecimal[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        bigDecimalArray[i] = new BigDecimal((double)nArray[i]);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.Long".equals(string)) {
                    Long[] longArray = (Long[])object;
                    BigDecimal[] bigDecimalArray = new BigDecimal[longArray.length];
                    for (int i = 0; i < longArray.length; ++i) {
                        if (longArray[i] == null) {
                            bigDecimalArray[i] = null;
                            continue;
                        }
                        long l = longArray[i];
                        bigDecimalArray[i] = new BigDecimal((double)l);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.Boolean".equals(string)) {
                    Boolean[] booleanArray = (Boolean[])object;
                    BigDecimal[] bigDecimalArray = new BigDecimal[booleanArray.length];
                    for (int i = 0; i < booleanArray.length; ++i) {
                        boolean bl;
                        bigDecimalArray[i] = booleanArray[i] == null ? null : ((bl = booleanArray[i].booleanValue()) ? new BigDecimal(1.0) : new BigDecimal(0.0));
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.Byte".equals(string)) {
                    Byte[] byteArray = (Byte[])object;
                    BigDecimal[] bigDecimalArray = new BigDecimal[byteArray.length];
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (byteArray[i] == null) {
                            bigDecimalArray[i] = null;
                            continue;
                        }
                        byte by = byteArray[i];
                        bigDecimalArray[i] = new BigDecimal((double)by);
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if ("java.lang.String".equals(string)) {
                    String[] stringArray = (String[])object;
                    BigDecimal[] bigDecimalArray = new BigDecimal[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i] == null) {
                            bigDecimalArray[i] = null;
                            continue;
                        }
                        try {
                            bigDecimalArray[i] = new BigDecimal(stringArray[i]);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "DB2Array.validate 07006 type is DECIMAL/NUMERIC/DECFLOAT but NumberFormatException thrown for string " + stringArray[i]);
                            }
                            JDError.throwSQLException("07006", "DECIMAL[" + i + "](" + stringArray[i] + ")");
                            return;
                        }
                    }
                    this.data_ = bigDecimalArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is DECIMAL/NUMERIC/DECFLOAT but array types is " + string);
                }
                JDError.throwSQLException("07006", "DECIMAL<>" + string);
                return;
            }
            case -3: 
            case -2: {
                if ("[B".equals(string)) {
                    byte[][] byArray = (byte[][])object;
                    byte[][] byArrayArray = new byte[byArray.length][];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArrayArray[i] = byArray[i];
                    }
                    this.data_ = (Object[])byArrayArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is BINARY/VARBINARY but array types is " + string);
                }
                JDError.throwSQLException("07006", "BINARY<>" + string);
                break;
            }
            case 2004: {
                if (JDUtilities.classIsInstanceOf(clazz, "java.sql.Blob")) {
                    Blob[] blobArray = (Blob[])object;
                    Blob[] blobArray2 = new Blob[blobArray.length];
                    for (int i = 0; i < blobArray.length; ++i) {
                        blobArray2[i] = blobArray[i];
                    }
                    this.data_ = blobArray2;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is BLOB but array types is " + string);
                }
                JDError.throwSQLException("07006", "BLOB<>" + string);
                break;
            }
            case 2005: 
            case 2011: {
                if (JDUtilities.classIsInstanceOf(clazz, "java.sql.Clob")) {
                    Clob[] clobArray = (Clob[])object;
                    Clob[] clobArray2 = new Clob[clobArray.length];
                    for (int i = 0; i < clobArray.length; ++i) {
                        clobArray2[i] = clobArray[i];
                    }
                    this.data_ = clobArray2;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is CLOB but array types is " + string);
                }
                JDError.throwSQLException("07006", "CLOB<>" + string);
                break;
            }
            case 91: {
                if (JDUtilities.classIsInstanceOf(clazz, "java.sql.Date")) {
                    Date[] dateArray = (Date[])object;
                    Date[] dateArray2 = new Date[dateArray.length];
                    for (int i = 0; i < dateArray.length; ++i) {
                        dateArray2[i] = dateArray[i];
                    }
                    this.data_ = dateArray2;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is DATE but array types is " + string);
                }
                JDError.throwSQLException("07006", "DATE<>" + string);
                break;
            }
            case 2009: {
                boolean bl = true;
                String string2 = "";
                Object[] objectArray = (Object[])object;
                SQLXML[] sQLXMLArray = new SQLXML[objectArray.length];
                for (int i = 0; bl && i < objectArray.length; ++i) {
                    if (objectArray[i] == null) {
                        sQLXMLArray[i] = null;
                        continue;
                    }
                    if (objectArray[i] instanceof SQLXML) {
                        sQLXMLArray[i] = (SQLXML)objectArray[i];
                        continue;
                    }
                    string2 = objectArray[i].getClass().getName();
                    bl = false;
                }
                if (bl) {
                    this.data_ = sQLXMLArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is SQLXML but array types is " + string + " subArrayType = " + string2);
                }
                JDError.throwSQLException("07006");
                break;
            }
            case 92: {
                if (JDUtilities.classIsInstanceOf(clazz, "java.sql.Time")) {
                    Time[] timeArray = (Time[])object;
                    Time[] timeArray2 = new Time[timeArray.length];
                    for (int i = 0; i < timeArray.length; ++i) {
                        timeArray2[i] = timeArray[i];
                    }
                    this.data_ = timeArray2;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is TIME but array types is " + string);
                }
                JDError.throwSQLException("07006", "TIME<>" + string);
                break;
            }
            case 93: {
                if (JDUtilities.classIsInstanceOf(clazz, "java.sql.Timestamp")) {
                    Timestamp[] timestampArray = (Timestamp[])object;
                    Timestamp[] timestampArray2 = new Timestamp[timestampArray.length];
                    for (int i = 0; i < timestampArray.length; ++i) {
                        timestampArray2[i] = timestampArray[i];
                    }
                    this.data_ = timestampArray2;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is TIMESTAMP but array types is " + string);
                }
                JDError.throwSQLException("07006", "TIMESTAMP<>" + string);
                break;
            }
            case 16: {
                if ("java.lang.Boolean".equals(string)) {
                    Boolean[] booleanArray = (Boolean[])object;
                    Boolean[] booleanArray2 = new Boolean[booleanArray.length];
                    for (int i = 0; i < booleanArray.length; ++i) {
                        booleanArray2[i] = booleanArray[i];
                    }
                    this.data_ = booleanArray2;
                    break;
                }
                if ("boolean".equals(string)) {
                    boolean[] blArray = (boolean[])object;
                    Boolean[] booleanArray = new Boolean[blArray.length];
                    for (int i = 0; i < blArray.length; ++i) {
                        booleanArray[i] = new Boolean(blArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.Integer".equals(string)) {
                    Integer[] integerArray = (Integer[])object;
                    Boolean[] booleanArray = new Boolean[integerArray.length];
                    for (int i = 0; i < integerArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, integerArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("int".equals(string)) {
                    int[] nArray = (int[])object;
                    Boolean[] booleanArray = new Boolean[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        booleanArray[i] = new Boolean(SQLBoolean.getBoolean((Object)this, nArray[i]));
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.math.BigDecimal".equals(string)) {
                    BigDecimal[] bigDecimalArray = (BigDecimal[])object;
                    Boolean[] booleanArray = new Boolean[bigDecimalArray.length];
                    for (int i = 0; i < bigDecimalArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, bigDecimalArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.Long".equals(string)) {
                    Long[] longArray = (Long[])object;
                    Boolean[] booleanArray = new Boolean[longArray.length];
                    for (int i = 0; i < longArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, longArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.Float".equals(string)) {
                    Float[] floatArray = (Float[])object;
                    Boolean[] booleanArray = new Boolean[floatArray.length];
                    for (int i = 0; i < floatArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, floatArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.Double".equals(string)) {
                    Double[] doubleArray = (Double[])object;
                    Boolean[] booleanArray = new Boolean[doubleArray.length];
                    for (int i = 0; i < doubleArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, doubleArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.Byte".equals(string)) {
                    Byte[] byteArray = (Byte[])object;
                    Boolean[] booleanArray = new Boolean[byteArray.length];
                    for (int i = 0; i < byteArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, byteArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.Short".equals(string)) {
                    Short[] shortArray = (Short[])object;
                    Boolean[] booleanArray = new Boolean[shortArray.length];
                    for (int i = 0; i < shortArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, shortArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if ("java.lang.String".equals(string)) {
                    String[] stringArray = (String[])object;
                    Boolean[] booleanArray = new Boolean[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        booleanArray[i] = SQLBoolean.getBooleanObject((Object)this, stringArray[i]);
                    }
                    this.data_ = booleanArray;
                    break;
                }
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 type is INTEGER but array types is " + string);
                }
                JDError.throwSQLException("07006", "INTEGER<>" + string);
                break;
            }
            default: {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "DB2Array.validate 07006 invalid type " + this.typeCode_ + " array type is " + string);
                }
                JDError.throwSQLException("07006", this.typeCode_ + "<>" + string);
            }
        }
    }
}

