/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import com.ibm.as400.access.SQLInteger;
import com.ibm.as400.access.ToolboxWrapper;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class AS400JDBCArrayResultSet
extends ToolboxWrapper
implements ResultSet {
    private int holdability_;
    private int concurrency_;
    private int fetchDirection_;
    private int fetchSize_;
    private int type_;
    private Object[][] data_;
    private int numberOfColumns_;
    private int numberOfRows_;
    private HashMap columnNameToIndexCache_;
    private SQLData contentTemplate_;
    private boolean isSQLData_;
    private int vrm_;
    private boolean openOnClient_;
    private int currentRowInRowset_;
    private int wasNull_;
    private Calendar calendar_;
    private Class byteArrayClass_;
    private static final int WAS_NULL_UNSET = 0;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;

    AS400JDBCArrayResultSet(Object[] objectArray, SQLData sQLData, boolean bl, int n, int n2) {
        int n3;
        Object[][] objectArray2 = new Object[2][];
        if (bl) {
            objectArray2[0] = new SQLInteger[objectArray.length];
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                try {
                    SQLInteger sQLInteger = (SQLInteger)SQLDataFactory.newData("INTEGER", Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 37, null, this.vrm_, null);
                    objectArray2[0][n3] = sQLInteger;
                    ((SQLInteger)objectArray2[0][n3]).set(n3 + 1);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            objectArray2[0] = new Integer[objectArray.length];
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                try {
                    objectArray2[0][n3] = new Integer(n3 + 1);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        objectArray2[1] = objectArray;
        this.contentTemplate_ = sQLData;
        this.isSQLData_ = bl;
        this.vrm_ = n2;
        String[] stringArray = new String[]{"INDEX", "VALUE"};
        this.init(1007, 1004, 1000, 1, objectArray2, stringArray);
    }

    void init(int n, int n2, int n3, int n4, Object[][] objectArray, String[] stringArray) {
        this.holdability_ = 1;
        this.concurrency_ = n;
        this.fetchDirection_ = n3;
        this.fetchSize_ = n4;
        this.type_ = n2;
        this.data_ = objectArray;
        this.numberOfColumns_ = objectArray.length;
        if (this.numberOfColumns_ > 0) {
            this.numberOfRows_ = objectArray[0].length;
        }
        this.columnNameToIndexCache_ = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            this.columnNameToIndexCache_.put(stringArray[i], new Integer(i + 1));
        }
        this.openOnClient_ = true;
        this.currentRowInRowset_ = -1;
    }

    @Override
    public void close() throws SQLException {
        this.openOnClient_ = false;
    }

    private Calendar getCalendar(TimeZone timeZone) {
        this.calendar_ = this.calendar_ != null ? this.calendar_ : new GregorianCalendar();
        this.calendar_.setTimeZone(timeZone);
        return this.calendar_;
    }

    private final void checkThatResultSetTypeIsScrollable() throws SQLException {
        if (this.type_ == 1003) {
            JDError.throwSQLException("24000");
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl2 = bl = this.currentRowInRowset_ == -1;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isBeforeFirst");
        }
        return bl;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl2 = bl = this.currentRowInRowset_ == this.numberOfRows_;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isAfterLast");
        }
        return bl;
    }

    @Override
    public boolean isFirst() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl2 = bl = this.currentRowInRowset_ == 0;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isFirst");
        }
        return bl;
    }

    @Override
    public boolean isLast() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        boolean bl2 = bl = this.currentRowInRowset_ == this.numberOfRows_ - 1;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isLast");
        }
        return bl;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "beforeFirst");
        }
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        this.currentRowInRowset_ = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "afterLast");
        }
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        this.currentRowInRowset_ = this.numberOfRows_;
    }

    @Override
    public boolean first() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        if (this.numberOfRows_ == 0) {
            bl = false;
        } else {
            bl = true;
            this.currentRowInRowset_ = 0;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "first");
        }
        return bl;
    }

    @Override
    public boolean last() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        if (this.numberOfRows_ == 0) {
            bl = false;
        } else {
            bl = true;
            this.currentRowInRowset_ = this.numberOfRows_ - 1;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "last");
        }
        return bl;
    }

    @Override
    public boolean previous() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        --this.currentRowInRowset_;
        if (this.currentRowInRowset_ >= 0) {
            bl = true;
        } else {
            bl = false;
            this.currentRowInRowset_ = -1;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "previous");
        }
        return bl;
    }

    @Override
    public boolean next() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.wasNull_ = 0;
        ++this.currentRowInRowset_;
        if (this.currentRowInRowset_ <= this.numberOfRows_ - 1) {
            bl = true;
        } else {
            bl = false;
            this.currentRowInRowset_ = this.numberOfRows_;
        }
        if (!bl && this.type_ == 1003) {
            this.close();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "next");
        }
        return bl;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        this.currentRowInRowset_ = n >= 0 ? n - 1 : n + this.numberOfRows_;
        if (this.currentRowInRowset_ >= 0 && this.currentRowInRowset_ <= this.numberOfRows_ - 1) {
            bl = true;
        } else {
            bl = false;
            this.currentRowInRowset_ = this.currentRowInRowset_ < 0 ? -1 : this.numberOfRows_;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "absolute");
        }
        return bl;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        this.checkThatResultSetTypeIsScrollable();
        this.wasNull_ = 0;
        this.currentRowInRowset_ += n;
        if (this.currentRowInRowset_ >= 0 && this.currentRowInRowset_ <= this.numberOfRows_ - 1) {
            bl = true;
        } else {
            bl = false;
            this.currentRowInRowset_ = this.currentRowInRowset_ < 0 ? -1 : this.numberOfRows_;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "relative");
        }
        return bl;
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getConcurrency");
        }
        this.checkForClosedResultSet();
        return this.concurrency_;
    }

    @Override
    public int getType() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getType");
        }
        this.checkForClosedResultSet();
        return this.type_;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getFetchDirection");
        }
        this.checkForClosedResultSet();
        return this.fetchDirection_;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setFetchDirection");
        }
        this.checkForClosedResultSet();
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection_ = n;
                break;
            }
            default: {
                JDError.throwSQLException("HY024");
            }
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getFetchSize");
        }
        this.checkForClosedResultSet();
        return this.fetchSize_;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setFetchSize");
        }
        this.checkForClosedResultSet();
        if (n < 0) {
            JDError.throwSQLException("HY024");
        }
        this.fetchSize_ = n;
    }

    @Override
    public String getCursorName() throws SQLException {
        String string = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getCursorName");
        }
        this.checkForClosedResultSet();
        return string;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getMetaData");
        }
        this.checkForClosedResultSet();
        return resultSetMetaData;
    }

    @Override
    public Statement getStatement() throws SQLException {
        Statement statement = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getStatement");
        }
        this.checkForClosedResultSet();
        return statement;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = null;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getWarnings");
        }
        this.checkForClosedResultSet();
        return sQLWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "clearWarnings");
        }
        this.checkForClosedResultSet();
    }

    @Override
    public int findColumn(String string) throws SQLException {
        this.checkForClosedResultSet();
        int n = this.findColumnX(string);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "findColumn");
        }
        return n;
    }

    private final int findColumnX(String string) throws SQLException {
        Integer n = (Integer)this.columnNameToIndexCache_.get(string.toUpperCase());
        if (n != null) {
            return n;
        }
        JDError.throwSQLException("HY024");
        return -1;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkForClosedResultSet();
        int n = this.currentRowInRowset_ >= 0 && this.currentRowInRowset_ <= this.numberOfRows_ - 1 ? this.currentRowInRowset_ + 1 : 0;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getRow");
        }
        return n;
    }

    @Override
    public boolean wasNull() throws SQLException {
        boolean bl;
        this.checkForClosedResultSet();
        if (this.wasNull_ == 0) {
            JDError.throwSQLException("HY109");
        }
        boolean bl2 = bl = this.wasNull_ == 1;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "wasNull");
        }
        return bl;
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Object[] objectArray = this.data_[n - 1];
        boolean bl = false;
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                bl = ((SQLData)objectArray[this.currentRowInRowset_]).getBoolean();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            bl = this.contentTemplate_.getBoolean();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBoolean");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return bl;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBoolean");
        }
        return this.getBoolean(this.findColumnX(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Object[] objectArray = this.data_[n - 1];
        byte by = 0;
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                by = ((SQLData)objectArray[this.currentRowInRowset_]).getByte();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            by = this.contentTemplate_.getByte();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getByte");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return by;
    }

    @Override
    public byte getByte(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getByte");
        }
        return this.getByte(this.findColumnX(string));
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        short s = 0;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                s = ((SQLData)objectArray[this.currentRowInRowset_]).getShort();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            s = this.contentTemplate_.getShort();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getShort");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return s;
    }

    @Override
    public short getShort(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getShort");
        }
        return this.getShort(this.findColumnX(string));
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        int n2 = 0;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                n2 = ((SQLData)objectArray[this.currentRowInRowset_]).getInt();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            n2 = this.contentTemplate_.getInt();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getInt");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return n2;
    }

    @Override
    public int getInt(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getInt");
        }
        return this.getInt(this.findColumnX(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        long l = 0L;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                l = ((SQLData)objectArray[this.currentRowInRowset_]).getLong();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            l = this.contentTemplate_.getLong();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getLong");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return l;
    }

    @Override
    public long getLong(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getLong");
        }
        return this.getLong(this.findColumnX(string));
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        float f = 0.0f;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                f = ((SQLData)objectArray[this.currentRowInRowset_]).getFloat();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            f = this.contentTemplate_.getFloat();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getFloat");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return f;
    }

    @Override
    public float getFloat(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getFloat");
        }
        return this.getFloat(this.findColumnX(string));
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        double d = 0.0;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                d = ((SQLData)objectArray[this.currentRowInRowset_]).getDouble();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            d = this.contentTemplate_.getDouble();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDouble");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return d;
    }

    @Override
    public double getDouble(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDouble");
        }
        return this.getDouble(this.findColumnX(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        BigDecimal bigDecimal = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                bigDecimal = ((SQLData)objectArray[this.currentRowInRowset_]).getBigDecimal(-1);
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            bigDecimal = this.contentTemplate_.getBigDecimal(-1);
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBigDecimal");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBigDecimal");
        }
        return this.getBigDecimal(this.findColumnX(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBigDecimal " + n + " " + n2);
        }
        return this.getBigDecimal(n).setScale(n2);
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBigDecimal " + string + " " + n);
        }
        return this.getBigDecimal(this.findColumnX(string), n);
    }

    @Override
    public synchronized Date getDate(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate");
        }
        return this.getDateX(n, TimeZone.getDefault());
    }

    @Override
    public Date getDate(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate");
        }
        return this.getDate(this.findColumnX(string));
    }

    @Override
    public synchronized Time getTime(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTime");
        }
        return this.getTimeX(n, TimeZone.getDefault());
    }

    @Override
    public Time getTime(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTime");
        }
        return this.getTime(this.findColumnX(string));
    }

    @Override
    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTimestamp");
        }
        return this.getTimestampX(n, TimeZone.getDefault());
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTimestamp");
        }
        return this.getTimestamp(this.findColumnX(string));
    }

    @Override
    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate " + n);
        }
        Date date = this.getDateX(n, calendar.getTimeZone());
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate");
        }
        return date;
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getDate " + string);
        }
        return this.getDate(this.findColumnX(string), calendar);
    }

    private Date getDateX(int n, TimeZone timeZone) throws SQLException {
        this.checkGetterPreconditions(n);
        Date date = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                date = ((SQLData)objectArray[this.currentRowInRowset_]).getDate(this.getCalendar(timeZone));
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.getCalendar(timeZone), -1);
            date = this.contentTemplate_.getDate(this.getCalendar(timeZone));
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return date;
    }

    @Override
    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTimeX(n, calendar.getTimeZone());
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTime");
        }
        return time;
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTime");
        }
        return this.getTime(this.findColumnX(string), calendar);
    }

    private Time getTimeX(int n, TimeZone timeZone) throws SQLException {
        this.checkGetterPreconditions(n);
        Time time = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                time = ((SQLData)objectArray[this.currentRowInRowset_]).getTime(this.getCalendar(timeZone));
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.getCalendar(timeZone), -1);
            time = this.contentTemplate_.getTime(this.getCalendar(timeZone));
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return time;
    }

    @Override
    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestampX(n, calendar.getTimeZone());
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTimestamp");
        }
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getTimestamp");
        }
        return this.getTimestamp(this.findColumnX(string), calendar);
    }

    private Timestamp getTimestampX(int n, TimeZone timeZone) throws SQLException {
        this.checkGetterPreconditions(n);
        Timestamp timestamp = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                timestamp = ((SQLData)objectArray[this.currentRowInRowset_]).getTimestamp(this.getCalendar(timeZone));
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.getCalendar(timeZone), -1);
            timestamp = this.contentTemplate_.getTimestamp(this.getCalendar(timeZone));
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return timestamp;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        byte[] byArray = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                byArray = ((SQLData)objectArray[this.currentRowInRowset_]).getBytes();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            byArray = this.contentTemplate_.getBytes();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBytes");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return byArray;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBytes");
        }
        return this.getBytes(this.findColumnX(string));
    }

    @Override
    public synchronized String getString(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        String string = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                string = ((SQLData)objectArray[this.currentRowInRowset_]).getString();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            string = this.contentTemplate_.getString();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getString");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return string;
    }

    @Override
    public String getString(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getString");
        }
        return this.getString(this.findColumnX(string));
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        InputStream inputStream = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                inputStream = ((SQLData)objectArray[this.currentRowInRowset_]).getBinaryStream();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            inputStream = this.contentTemplate_.getBinaryStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBinaryStream");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return inputStream;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBinaryStream");
        }
        return this.getBinaryStream(this.findColumnX(string));
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        InputStream inputStream = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                inputStream = ((SQLData)objectArray[this.currentRowInRowset_]).getAsciiStream();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            inputStream = this.contentTemplate_.getAsciiStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getAsciiStream");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return inputStream;
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getAsciiStream");
        }
        return this.getAsciiStream(this.findColumnX(string));
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        InputStream inputStream = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                inputStream = ((SQLData)objectArray[this.currentRowInRowset_]).getUnicodeStream();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            inputStream = this.contentTemplate_.getUnicodeStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getUnicodeStream");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return inputStream;
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getUnicodeStream");
        }
        return this.getUnicodeStream(this.findColumnX(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Reader reader = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                reader = ((SQLData)objectArray[this.currentRowInRowset_]).getCharacterStream();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            reader = this.contentTemplate_.getCharacterStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getCharacterStream");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return reader;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getCharacterStream");
        }
        return this.getCharacterStream(this.findColumnX(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Blob blob = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                blob = ((SQLData)objectArray[this.currentRowInRowset_]).getBlob();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            blob = this.contentTemplate_.getBlob();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBlob");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return blob;
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getBlob");
        }
        return this.getBlob(this.findColumnX(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Clob clob = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                clob = ((SQLData)objectArray[this.currentRowInRowset_]).getClob();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            clob = this.contentTemplate_.getClob();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getClob");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return clob;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getClob");
        }
        return this.getClob(this.findColumnX(string));
    }

    @Override
    public Array getArray(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public Array getArray(String string) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public URL getURL(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        URL uRL = null;
        Object[] objectArray = this.data_[n - 1];
        String string = null;
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                string = ((SQLData)objectArray[this.currentRowInRowset_]).getString();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            string = this.contentTemplate_.getString();
        }
        try {
            uRL = string == null ? null : new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            JDError.throwSQLException("HY105", malformedURLException);
            uRL = null;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getURL");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return uRL;
    }

    @Override
    public URL getURL(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getURL");
        }
        return this.getURL(this.findColumnX(string));
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Object[] objectArray = this.data_[n - 1];
        Object object = null;
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                object = ((SQLData)objectArray[this.currentRowInRowset_]).getObject();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            object = this.contentTemplate_.getObject();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getObject");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getObject");
        }
        return this.getObject(this.findColumnX(string));
    }

    public Object getObject(int n, Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    public Object getObject(String string, Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    @Override
    public void updateNull(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNull");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNull");
        }
        this.updateNull(this.findColumnX(string));
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateByte");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateByte");
        }
        this.updateByte(this.findColumnX(string), by);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBoolean");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBoolean");
        }
        this.updateBoolean(this.findColumnX(string), bl);
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateShort");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateShort");
        }
        this.updateShort(this.findColumnX(string), s);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateInt");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateInt");
        }
        this.updateInt(this.findColumnX(string), n);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateLong");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateLong");
        }
        this.updateLong(this.findColumnX(string), l);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateFloat");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateFloat");
        }
        this.updateFloat(this.findColumnX(string), f);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateDouble");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateDouble");
        }
        this.updateDouble(this.findColumnX(string), d);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBigDecimal");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBigDecimal");
        }
        this.updateBigDecimal(this.findColumnX(string), bigDecimal);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateDate");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateDate");
        }
        this.updateDate(this.findColumnX(string), date);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateTime");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateTime");
        }
        this.updateTime(this.findColumnX(string), time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateTimestamp");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateTimestamp");
        }
        this.updateTimestamp(this.findColumnX(string), timestamp);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBytes");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBytes");
        }
        this.updateBytes(this.findColumnX(string), byArray);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateString");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateString");
        }
        this.updateString(this.findColumnX(string), string2);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.updateBinaryStream(this.findColumnX(string), inputStream, n);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.updateAsciiStream(this.findColumnX(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.updateCharacterStream(this.findColumnX(string), reader, n);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.updateBlob(this.findColumnX(string), blob);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.updateClob(this.findColumnX(string), clob);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateArray");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateArray");
        }
        this.updateArray(this.findColumnX(string), array);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateRef");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateRef");
        }
        this.updateRef(this.findColumnX(string), ref);
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateObject");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateObject");
        }
        this.updateObject(this.findColumnX(string), object);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateObject");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateObject");
        }
        this.updateObject(this.findColumnX(string), object, n);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001");
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "rowInserted()");
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "rowDeleted()");
        return false;
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "updateRow()");
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "deleteRow()");
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "refreshRow()");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "cancelRowUpdates()");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "moveToInsertRow()");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkUpdatePreconditions();
        JDError.throwSQLException((Object)this, "IM001", "moveToCurrentRow()");
    }

    private final void checkForClosedResultSet() throws SQLException {
        if (!this.openOnClient_) {
            JDError.throwSQLException("24000");
        }
    }

    private final void checkForValidColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.numberOfColumns_) {
            JDError.throwSQLException("24000");
        }
    }

    private final void checkForValidPosition() throws SQLException {
        if (this.currentRowInRowset_ < 0 || this.currentRowInRowset_ > this.numberOfRows_ - 1) {
            JDError.throwSQLException("24000");
        }
    }

    private final void checkForConcurrency() throws SQLException {
        if (this.concurrency_ != 1008) {
            JDError.throwSQLException("24000");
        }
    }

    private final void checkGetterPreconditions(int n) throws SQLException {
        this.checkForClosedResultSet();
        this.checkForValidColumnIndex(n);
        this.checkForValidPosition();
    }

    private final void checkUpdatePreconditions(int n) throws SQLException {
        this.checkForClosedResultSet();
        this.checkForValidColumnIndex(n);
        this.checkForConcurrency();
    }

    private final void checkUpdatePreconditions() throws SQLException {
        this.checkForClosedResultSet();
        this.checkForConcurrency();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.openOnClient_;
    }

    @Override
    public int getHoldability() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getHoldability");
        }
        this.checkForClosedResultSet();
        return this.holdability_;
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        Reader reader = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                reader = ((SQLData)objectArray[this.currentRowInRowset_]).getNCharacterStream();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            reader = this.contentTemplate_.getNCharacterStream();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNCharacterStream");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return reader;
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNCharacterStream");
        }
        return this.getNCharacterStream(this.findColumnX(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        NClob nClob = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                nClob = ((SQLData)objectArray[this.currentRowInRowset_]).getNClob();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            nClob = this.contentTemplate_.getNClob();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNClob");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return nClob;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNClob");
        }
        return this.getNClob(this.findColumnX(string));
    }

    @Override
    public String getNString(int n) throws SQLException {
        this.checkGetterPreconditions(n);
        String string = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                string = ((SQLData)objectArray[this.currentRowInRowset_]).getNString();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            string = this.contentTemplate_.getNString();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNString");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return string;
    }

    @Override
    public String getNString(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getNString");
        }
        return this.getNString(this.findColumnX(string));
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getRowId");
        }
        this.checkGetterPreconditions(n);
        RowId rowId = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                rowId = ((SQLData)objectArray[this.currentRowInRowset_]).getRowId();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            rowId = this.contentTemplate_.getRowId();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getRowId");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return rowId;
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getRowId");
        }
        return this.getRowId(this.findColumnX(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getSQLXML");
        }
        this.checkGetterPreconditions(n);
        SQLXML sQLXML = null;
        Object[] objectArray = this.data_[n - 1];
        if (this.isSQLData_) {
            if (objectArray[this.currentRowInRowset_] != null) {
                sQLXML = ((SQLData)objectArray[this.currentRowInRowset_]).getSQLXML();
            }
        } else if (objectArray[this.currentRowInRowset_] != null) {
            this.contentTemplate_.set(objectArray[this.currentRowInRowset_], this.calendar_, -1);
            sQLXML = this.contentTemplate_.getSQLXML();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getSQLXML");
        }
        this.wasNull_ = objectArray[this.currentRowInRowset_] == null ? 1 : 2;
        return sQLXML;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "getSQLXML");
        }
        return this.getSQLXML(this.findColumnX(string));
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.updateAsciiStream(this.findColumnX(string), inputStream);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateAsciiStream");
        }
        this.updateAsciiStream(this.findColumnX(string), inputStream, l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.updateBinaryStream(this.findColumnX(string), inputStream);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBinaryStream");
        }
        this.updateBinaryStream(this.findColumnX(string), inputStream, l);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.updateBlob(this.findColumnX(string), inputStream);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateBlob");
        }
        this.updateBlob(this.findColumnX(string), inputStream, l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.updateCharacterStream(this.findColumnX(string), reader);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateCharacterStream");
        }
        this.updateCharacterStream(this.findColumnX(string), reader, l);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.updateClob(this.findColumnX(string), reader);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateClob");
        }
        this.updateClob(this.findColumnX(string), reader, l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNCharacterStream");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNCharacterStream");
        }
        this.updateNCharacterStream(this.findColumnX(string), reader);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNCharacterStream");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNCharacterStream");
        }
        this.updateNCharacterStream(this.findColumnX(string), reader, l);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.updateNClob(this.findColumnX(string), nClob);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.updateNClob(this.findColumnX(string), reader);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNClob");
        }
        this.updateNClob(this.findColumnX(string), reader, l);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNString");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateNString");
        }
        this.updateNString(this.findColumnX(string), string2);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateRowId");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateRowId");
        }
        this.updateRowId(this.findColumnX(string), rowId);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateSQLXML");
        }
        this.checkUpdatePreconditions(n);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.findColumnX(string), sQLXML);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "updateSQLXML");
        }
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        if (clazz == null) {
            JDError.throwSQLException("HY105");
        }
        if (this.byteArrayClass_ == null) {
            byte[] byArray = new byte[1];
            this.byteArrayClass_ = byArray.getClass();
        }
        if (clazz == String.class) {
            return this.getString(n);
        }
        if (clazz == Byte.class) {
            byte by = this.getByte(n);
            if (by == 0 && this.wasNull()) {
                return null;
            }
            return new Byte(by);
        }
        if (clazz == Short.class) {
            short s = this.getShort(n);
            if (s == 0 && this.wasNull()) {
                return null;
            }
            return new Short(s);
        }
        if (clazz == Integer.class) {
            int n2 = this.getInt(n);
            if (n2 == 0 && this.wasNull()) {
                return null;
            }
            return new Integer(n2);
        }
        if (clazz == Long.class) {
            long l = this.getLong(n);
            if (l == 0L && this.wasNull()) {
                return null;
            }
            return new Long(l);
        }
        if (clazz == Float.class) {
            float f = this.getFloat(n);
            if (f == 0.0f && this.wasNull()) {
                return null;
            }
            return new Float(f);
        }
        if (clazz == Double.class) {
            double d = this.getDouble(n);
            if (d == 0.0 && this.wasNull()) {
                return null;
            }
            return new Double(d);
        }
        if (clazz == BigDecimal.class) {
            return this.getBigDecimal(n);
        }
        if (clazz == Boolean.class) {
            boolean bl = this.getBoolean(n);
            if (!bl && this.wasNull()) {
                return null;
            }
            return new Boolean(bl);
        }
        if (clazz == Date.class) {
            return this.getDate(n);
        }
        if (clazz == Time.class) {
            return this.getTime(n);
        }
        if (clazz == Timestamp.class) {
            return this.getTimestamp(n);
        }
        if (clazz == this.byteArrayClass_) {
            return this.getBytes(n);
        }
        if (clazz == InputStream.class) {
            return this.getBinaryStream(n);
        }
        if (clazz == Reader.class) {
            return this.getCharacterStream(n);
        }
        if (clazz == Clob.class) {
            return this.getClob(n);
        }
        if (clazz == Blob.class) {
            return this.getBlob(n);
        }
        if (clazz == Array.class) {
            return this.getArray(n);
        }
        if (clazz == Ref.class) {
            return this.getRef(n);
        }
        if (clazz == URL.class) {
            return this.getURL(n);
        }
        if (clazz == NClob.class) {
            return this.getNClob(n);
        }
        if (clazz == RowId.class) {
            return this.getRowId(n);
        }
        if (clazz == SQLXML.class) {
            return this.getSQLXML(n);
        }
        if (clazz == Object.class) {
            return this.getObject(n);
        }
        JDError.throwSQLException("HY004");
        return null;
    }

    public Object getObject(String string, Class clazz) throws SQLException {
        return this.getObject(this.findColumnX(string), clazz);
    }

    @Override
    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCArrayResultSet", "java.sql.ResultSet"};
    }
}

