/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCParameterMetaData;
import com.ibm.as400.access.AS400JDBCPreparedStatement;
import com.ibm.as400.access.AS400JDBCResultSetMetaData;
import com.ibm.as400.access.AS400JDBCStatementLock;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBData;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.DBExtendedData;
import com.ibm.as400.access.DBExtendedDataFormat;
import com.ibm.as400.access.DBOriginalData;
import com.ibm.as400.access.DBOriginalDataFormat;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBSQLDescriptorDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.DBVariableData;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDPackageManager;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLArray;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLInteger;
import com.ibm.as400.access.SQLLocator;
import com.ibm.as400.access.SQLVariableCompressible;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;

public class AS400JDBCPreparedStatementImpl
extends AS400JDBCPreparedStatement {
    static final String copyright2 = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private int descriptorHandle_;
    boolean executed_;
    private boolean outputParametersExpected_;
    int parameterCount_;
    int parameterInputCount_;
    boolean batchExecute_;
    private boolean executingBatchedStatement_ = false;
    private int[] parameterLengths_;
    private int[] parameterOffsets_;
    private boolean[] parameterNulls_;
    private boolean[] parameterDefaults_;
    private boolean[] parameterUnassigned_;
    private String[] parameterNames_;
    Vector batchParameterRows_;
    private int parameterTotalSize_;
    private int indicatorTotalSize_;
    private int headerTotalSize_;
    boolean[] parameterSet_;
    private boolean prepared_;
    private JDServerRow resultRow_;
    SQLInteger returnValueParameter_;
    JDSQLStatement sqlStatement_;
    boolean useReturnValueParameter_;
    private int maxToLog_ = 10000;
    private boolean containsArrayParameter_ = false;
    private boolean preserveParameters_ = false;
    private boolean saveParameterValues_ = false;
    private int containsLocator_ = -1;
    private static final int LOCATOR_UNKNOWN = -1;
    private static final int LOCATOR_NOT_FOUND = 0;
    private static final int LOCATOR_FOUND = 1;
    private static final short INDICATOR_NULL = -1;
    private static final short INDICATOR_DEFAULT = -5;
    private static final short INDICATOR_UNASSIGNED = -7;
    private boolean isjvm16Synchronizer;
    private static boolean isjvm16SynchronizerStatic;
    OutputStream dummyOutputStream = new OutputStream(){
        int b1 = 0;

        @Override
        public synchronized void write(int n) throws IOException {
            this.b1 = n;
        }
    };

    AS400JDBCPreparedStatementImpl(AS400JDBCConnection aS400JDBCConnection, int n, JDTransactionManager jDTransactionManager, JDPackageManager jDPackageManager, String string, int n2, boolean bl, JDSQLStatement jDSQLStatement, boolean bl2, String string2, int n3, int n4, int n5, int n6) throws SQLException {
        super(aS400JDBCConnection, n, jDTransactionManager, jDPackageManager, string, n2, bl, string2, n3, n4, n5, n6);
        this.isjvm16Synchronizer = isjvm16SynchronizerStatic;
        if (this.connection_.getProperties().getBoolean(80)) {
            this.isjvm16Synchronizer = true;
        }
        this.batchExecute_ = false;
        this.outputParametersExpected_ = bl2;
        this.parameterCount_ = jDSQLStatement.countParameters();
        this.parameterInputCount_ = 0;
        this.parameterLengths_ = new int[this.parameterCount_];
        this.parameterNulls_ = new boolean[this.parameterCount_];
        this.parameterDefaults_ = new boolean[this.parameterCount_];
        this.parameterUnassigned_ = new boolean[this.parameterCount_];
        this.parameterOffsets_ = new int[this.parameterCount_];
        this.parameterSet_ = new boolean[this.parameterCount_];
        this.sqlStatement_ = jDSQLStatement;
        this.useReturnValueParameter_ = jDSQLStatement.hasReturnValueParameter();
        if (this.useReturnValueParameter_) {
            this.returnValueParameter_ = new SQLInteger(this.connection_.getVRM(), this.settings_);
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "isjvm16Synchronizer=" + this.isjvm16Synchronizer);
            JDTrace.logInformation(this, "Preparing [" + this.sqlStatement_ + "]");
            if (this.useReturnValueParameter_) {
                JDTrace.logInformation(this, "Suppressing return value parameter (?=CALL)");
            }
        }
        this.allowImmediate_ = false;
        this.prepared_ = true;
        try {
            this.resultRow_ = this.commonPrepare(this.sqlStatement_);
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw sQLException;
        }
        this.executed_ = false;
        this.clearParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            Object[] objectArray = new Object[this.parameterCount_];
            for (int i = 0; i < this.parameterCount_; ++i) {
                int n;
                if (this.parameterRow_.isOutput(i + 1)) {
                    JDError.throwSQLException((Object)this, "HY105");
                }
                if (!this.parameterSet_[i]) {
                    JDError.throwSQLException((Object)this, "07001");
                }
                SQLData sQLData = this.parameterRow_.getSQLData(i + 1);
                if (!this.parameterNulls_[i]) {
                    objectArray[i] = this.parameterDefaults_[i] ? new Byte("1") : (this.parameterUnassigned_[i] ? new Byte("2") : sQLData.getBatchableObject());
                }
                if (this.containsLocator_ != -1 || (n = sQLData.getSQLType()) != 8 && n != 4 && n != 12 && n != 34 && n != 40) continue;
                this.containsLocator_ = 1;
            }
            if (this.containsLocator_ == -1) {
                this.containsLocator_ = 0;
            }
            if (this.batch_ == null) {
                this.batch_ = new Vector();
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "addBatch()");
            }
            this.batch_.addElement(objectArray);
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeDescriptor() throws SQLException {
        DBBaseRequestDS dBBaseRequestDS = null;
        try {
            this.descriptorHandle_ = this.id_;
            dBBaseRequestDS = DBDSPool.getDBSQLDescriptorDS(7680, this.id_, 0, this.descriptorHandle_);
            DBDataFormat dBDataFormat = this.connection_.useExtendedFormats() ? new DBExtendedDataFormat(this.parameterCount_) : new DBOriginalDataFormat(this.parameterCount_);
            ((DBSQLDescriptorDS)dBBaseRequestDS).setParameterMarkerDataFormat(dBDataFormat);
            dBDataFormat.setConsistencyToken(1);
            dBDataFormat.setRecordSize(this.parameterTotalSize_);
            if (this.isjvm16Synchronizer) {
                try {
                    this.dummyOutputStream.write(("!!!changeDescriptor:  totalParameterLength_ = " + this.parameterTotalSize_).getBytes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (int i = 0; i < this.parameterCount_; ++i) {
                SQLData sQLData = this.parameterRow_.getSQLData(i + 1);
                dBDataFormat.setFieldDescriptionLength(i);
                if (sQLData.getNativeType() == 10000) {
                    int n = ((SQLArray)sQLData).getArrayCount();
                    if (n > 0) {
                        dBDataFormat.setFieldLength(i, this.parameterLengths_[i] / n);
                    } else {
                        dBDataFormat.setFieldLength(i, this.parameterLengths_[i]);
                    }
                } else {
                    dBDataFormat.setFieldLength(i, this.parameterLengths_[i]);
                }
                dBDataFormat.setFieldCCSID(i, this.parameterRow_.getCCSID(i + 1));
                dBDataFormat.setFieldNameLength(i, 0);
                dBDataFormat.setFieldNameCCSID(i, 0);
                dBDataFormat.setFieldName(i, "", this.connection_.getConverter());
                if (sQLData.getNativeType() == 10000) {
                    dBDataFormat.setFieldSQLType(i, (short)(((SQLArray)sQLData).getElementNativeType() | 1));
                } else {
                    dBDataFormat.setFieldSQLType(i, (short)(sQLData.getNativeType() | 1));
                }
                dBDataFormat.setFieldScale(i, (short)sQLData.getScale());
                dBDataFormat.setFieldPrecision(i, (short)sQLData.getPrecision());
                if (!this.isjvm16Synchronizer) continue;
                try {
                    this.dummyOutputStream.write(("!!!changeDescriptor:  Parameter " + (i + 1) + " length = " + this.parameterLengths_[i]).getBytes());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.connection_.send(dBBaseRequestDS, this.descriptorHandle_);
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Descriptor " + this.descriptorHandle_ + " created or changed");
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException((Object)this, "HY000", dBDataStreamException);
        }
        finally {
            if (this.isjvm16Synchronizer && dBBaseRequestDS != null) {
                try {
                    this.dummyOutputStream.write(("!!!changeDescriptor.inUser_(false): request2-id=" + dBBaseRequestDS.hashCode()).getBytes());
                }
                catch (Exception exception) {}
            }
            if (dBBaseRequestDS != null) {
                dBBaseRequestDS.returnToPool();
                dBBaseRequestDS = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            for (int i = 0; i < this.parameterCount_; ++i) {
                this.parameterNulls_[i] = false;
                this.parameterDefaults_[i] = false;
                this.parameterUnassigned_[i] = false;
                this.parameterSet_[i] = false;
            }
            if (this.useReturnValueParameter_) {
                this.returnValueParameter_.set(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            if (this.isClosed()) {
                return;
            }
            if (this.descriptorHandle_ != 0) {
                DBSQLDescriptorDS dBSQLDescriptorDS = null;
                try {
                    dBSQLDescriptorDS = DBDSPool.getDBSQLDescriptorDS(7681, this.id_, 0, this.descriptorHandle_);
                    this.connection_.send(dBSQLDescriptorDS, this.descriptorHandle_);
                }
                finally {
                    if (this.isjvm16Synchronizer) {
                        try {
                            if (dBSQLDescriptorDS != null) {
                                this.dummyOutputStream.write(("!!!close.inUser_(false): request-id=" + dBSQLDescriptorDS.hashCode()).getBytes());
                            }
                        }
                        catch (Exception exception) {}
                    }
                    if (dBSQLDescriptorDS != null) {
                        dBSQLDescriptorDS.returnToPool();
                        dBSQLDescriptorDS = null;
                    }
                }
                this.descriptorHandle_ = 0;
            }
            super.close();
        }
    }

    @Override
    void commonExecuteAfter(JDSQLStatement jDSQLStatement, DBReplyRequestedDS dBReplyRequestedDS) throws SQLException {
        super.commonExecuteAfter(jDSQLStatement, dBReplyRequestedDS);
        if (this.prepared_) {
            DBData dBData = null;
            if (this.outputParametersExpected_) {
                dBData = dBReplyRequestedDS.getResultData();
            }
            if (this.outputParametersExpected_ && dBData != null) {
                this.parameterRow_.setServerData(dBData);
                this.parameterRow_.setRowIndex(0);
            }
            try {
                if (this.useReturnValueParameter_) {
                    this.returnValueParameter_.set(dBReplyRequestedDS.getSQLCA().getErrd(1));
                }
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException((Object)this, "HY000", dBDataStreamException);
            }
        }
    }

    @Override
    void commonExecuteBefore(JDSQLStatement jDSQLStatement, DBSQLRequestDS dBSQLRequestDS) throws SQLException {
        super.commonExecuteBefore(jDSQLStatement, dBSQLRequestDS);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.disableRllCompression_ = false;
        if (this.prepared_) {
            int n4;
            int n5;
            Object object;
            int n6;
            this.closeResultSet(241);
            boolean bl = false;
            this.parameterInputCount_ = 0;
            for (n6 = 0; n6 < this.parameterCount_; ++n6) {
                if (!this.executingBatchedStatement_ && !this.parameterSet_[n6] && this.parameterRow_.isInput(n6 + 1)) {
                    JDError.throwSQLException((Object)this, "07001");
                }
                if (this.parameterRow_.isOutput(n6 + 1)) {
                    bl = true;
                }
                if (!this.parameterRow_.isInput(n6 + 1)) continue;
                ++this.parameterInputCount_;
            }
            if (!bl) {
                this.outputParametersExpected_ = false;
            }
            if (this.parameterCount_ > 0 && this.descriptorHandle_ == 0 || this.parameterCount_ > 0 && this.containsArrayParameter_) {
                this.parameterRow_.setRowIndex(-1);
                this.parameterTotalSize_ = 0;
                this.indicatorTotalSize_ = 0;
                this.headerTotalSize_ = 2;
                for (n6 = 0; n6 < this.parameterCount_; ++n6) {
                    if (!this.parameterRow_.containsArray_ || this.parameterRow_.isInput(n6 + 1)) {
                        object = this.parameterRow_.getSQLData(n6 + 1);
                        if (object.getType() == 2003) {
                            this.containsArrayParameter_ = true;
                            n5 = ((SQLArray)object).getArrayCount();
                            n4 = this.parameterRow_.getArrayDataLength(n6 + 1);
                            this.headerTotalSize_ = this.parameterNulls_[n6] || this.parameterDefaults_[n6] || this.parameterUnassigned_[n6] ? (this.headerTotalSize_ += 4) : (this.headerTotalSize_ += 12);
                            this.parameterLengths_[n6] = n4 * n5;
                            this.indicatorTotalSize_ += n5 * 2;
                        } else {
                            this.headerTotalSize_ += 8;
                            this.parameterLengths_[n6] = this.parameterRow_.getLength(n6 + 1);
                            this.indicatorTotalSize_ += 2;
                        }
                        this.parameterOffsets_[n6] = this.parameterTotalSize_;
                        this.parameterTotalSize_ += this.parameterLengths_[n6];
                    }
                    if (!this.isjvm16Synchronizer) continue;
                    try {
                        this.dummyOutputStream.write(("!!!commonExecuteBefore:  Parameter " + (n6 + 1) + " length = " + this.parameterLengths_[n6]).getBytes());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.isjvm16Synchronizer) {
                    try {
                        this.dummyOutputStream.write(("!!!commonExecuteBefore:  totalParameterLength_ = " + this.parameterTotalSize_).getBytes());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.changeDescriptor();
            }
            try {
                dBSQLRequestDS.setStatementType(jDSQLStatement.getNativeType());
                dBSQLRequestDS.setParameterMarkerDescriptorHandle(this.descriptorHandle_);
                if (this.parameterCount_ > 0) {
                    if (this.saveParameterValues_ && this.parameterRow_ != null) {
                        this.parameterRow_.saveValues();
                    }
                    n6 = 0;
                    do {
                        int n7;
                        n6 = 0;
                        n5 = this.batchExecute_ ? this.batchParameterRows_.size() : 1;
                        n4 = 0;
                        if (this.batchExecute_ && n5 > 0 && this.useVariableFieldInsertCompression()) {
                            n4 = 1;
                        }
                        if (this.parameterRow_.containsArray_) {
                            object = new DBVariableData(this.parameterInputCount_, 2, this.headerTotalSize_, this.indicatorTotalSize_, this.parameterTotalSize_);
                            if (n4 != 0) {
                                n4 = 0;
                            }
                        } else if (this.connection_.useExtendedFormats()) {
                            object = new DBExtendedData(n5, this.parameterCount_, 2, this.parameterTotalSize_);
                        } else {
                            object = new DBOriginalData(n5, this.parameterCount_, 2, this.parameterTotalSize_);
                            if (n4 != 0) {
                                n4 = 0;
                            }
                        }
                        int n8 = 0;
                        int n9 = 0;
                        for (n7 = 0; n7 < n5; ++n7) {
                            Object[] objectArray = null;
                            if (this.batchExecute_) {
                                objectArray = (Object[])this.batchParameterRows_.get(n7);
                            }
                            if (n7 == 0) {
                                if (n4 != 0) {
                                    n = dBSQLRequestDS.setParameterMarkerDataReserve((DBData)object);
                                    ((DBExtendedData)object).setParameterMarkerInputCompression(true);
                                } else {
                                    dBSQLRequestDS.setParameterMarkerData((DBData)object);
                                }
                                object.setConsistencyToken(1);
                            }
                            if (n7 == 0) {
                                if (n4 != 0) {
                                    n2 = ((DBExtendedData)object).getRawOffset();
                                }
                                n9 = object.getRowDataOffset(n7);
                            } else {
                                n9 = n4 != 0 ? (n9 += n8) : object.getRowDataOffset(n7);
                            }
                            n8 = 0;
                            for (int i = 0; i < this.parameterCount_; ++i) {
                                int n10;
                                int n11;
                                Object object2;
                                if (this.batchExecute_ && objectArray != null && (objectArray[i] == null || objectArray[i] instanceof Byte) || !this.batchExecute_ && (this.parameterNulls_[i] || this.parameterDefaults_[i] || this.parameterUnassigned_[i])) {
                                    int n12;
                                    short s = -1;
                                    if (this.batchExecute_ && objectArray != null) {
                                        if (objectArray[i] == null) {
                                            s = -1;
                                        } else if ((Byte)objectArray[i] == 1) {
                                            s = -5;
                                        } else if ((Byte)objectArray[i] == 2) {
                                            s = -7;
                                        }
                                    } else if (this.parameterNulls_[i]) {
                                        s = -1;
                                    } else if (this.parameterDefaults_[i]) {
                                        s = -5;
                                    } else if (this.parameterUnassigned_[i]) {
                                        s = -7;
                                    }
                                    object2 = this.parameterRow_.getSQLType(i + 1);
                                    if (object2.getType() != 2003) {
                                        object.setIndicator(n7, i, s);
                                    }
                                    if (object2.getType() != 2003) {
                                        byte[] byArray = object.getRawBytes();
                                        if (n4 != 0) {
                                            if (object2 instanceof SQLVariableCompressible) {
                                                byArray[n9 + n8] = 0;
                                                byArray[n9 + ++n8] = 0;
                                                ++n8;
                                                n3 += 2;
                                            } else {
                                                n12 = n9 + n8;
                                                n11 = this.parameterLengths_[i] + n12;
                                                n10 = n12;
                                                while (n10 < n11) {
                                                    byArray[n10++] = 0;
                                                }
                                                n8 += this.parameterLengths_[i];
                                            }
                                        } else {
                                            int n13 = n9 + this.parameterOffsets_[i];
                                            n11 = this.parameterLengths_[i] + n13;
                                            n10 = n13;
                                            while (n10 < n11) {
                                                byArray[n10++] = 0;
                                            }
                                        }
                                    }
                                    if (!this.parameterRow_.containsArray_ || !this.parameterRow_.isInput(i + 1)) continue;
                                    int n14 = -1;
                                    n12 = -1;
                                    n11 = -1;
                                    if (object2.getType() == 2003) {
                                        n14 = ((SQLArray)object2).getArrayCount();
                                        n12 = ((SQLArray)object2).getElementNativeType();
                                        n11 = this.parameterRow_.getArrayDataLength(i + 1);
                                    } else {
                                        n11 = this.parameterRow_.getLength(i + 1);
                                    }
                                    ((DBVariableData)object).setHeaderColumnInfo(i, (short)object2.getNativeType(), s, (short)n12, n11, (short)n14);
                                    continue;
                                }
                                SQLData sQLData = this.parameterRow_.getSQLType(i + 1);
                                if (!this.parameterRow_.containsArray_ || this.parameterRow_.isInput(i + 1)) {
                                    if (sQLData.getType() == 2003) {
                                        for (int j = 0; j < ((SQLArray)sQLData).getArrayCount(); ++j) {
                                            if (((SQLArray)sQLData).isElementNull(j)) {
                                                object.setIndicator(0, i, -1);
                                                continue;
                                            }
                                            object.setIndicator(0, i, 0);
                                        }
                                    } else {
                                        object.setIndicator(n7, i, 0);
                                    }
                                }
                                object2 = this.connection_.getConverter(this.parameterRow_.getCCSID(i + 1));
                                int n15 = -1;
                                if (this.batchExecute_ && objectArray != null) {
                                    this.setValue(i + 1, objectArray[i], null, -1);
                                }
                                try {
                                    if (!this.parameterRow_.containsArray_ || this.parameterRow_.isInput(i + 1)) {
                                        int n16 = 0;
                                        if (n4 != 0) {
                                            if (sQLData instanceof SQLVariableCompressible) {
                                                n16 = n9 + n8;
                                                n11 = ((SQLVariableCompressible)((Object)sQLData)).convertToCompressedBytes(object.getRawBytes(), n16, (ConvTable)object2);
                                                n3 += n11;
                                                n8 += n11;
                                            } else {
                                                n16 = n9 + n8;
                                                sQLData.convertToRawBytes(object.getRawBytes(), n16, (ConvTable)object2);
                                                n8 += this.parameterLengths_[i];
                                            }
                                        } else {
                                            n16 = n9 + this.parameterOffsets_[i];
                                            sQLData.convertToRawBytes(object.getRawBytes(), n16, (ConvTable)object2);
                                        }
                                        n11 = this.testDataTruncation(i + 1, sQLData) ? 1 : 0;
                                        if (n11 != 0) {
                                            sQLData.validateRawTruncatedData(object.getRawBytes(), n16, (ConvTable)object2);
                                        }
                                    }
                                    if (this.parameterRow_.containsArray_ && this.parameterRow_.isInput(i + 1)) {
                                        int n17 = -1;
                                        n11 = -1;
                                        if (sQLData.getType() == 2003) {
                                            n10 = this.parameterRow_.getArrayDataLength(i + 1);
                                            n17 = ((SQLArray)sQLData).getArrayCount();
                                            n11 = ((SQLArray)sQLData).getElementNativeType();
                                        } else {
                                            n10 = this.parameterRow_.getLength(i + 1);
                                        }
                                        ((DBVariableData)object).setHeaderColumnInfo(i, (short)sQLData.getNativeType(), (short)0, (short)n11, n10, (short)n17);
                                    }
                                }
                                catch (SQLException sQLException) {
                                    if (sQLException.getSQLState().trim().equals("HY000")) {
                                        if (this.parameterRow_.containsArray_) {
                                            throw sQLException;
                                        }
                                        if (sQLException.getMessage().indexOf("Change Descriptor") != -1) {
                                            n15 = sQLData.getPrecision();
                                        }
                                        throw sQLException;
                                    }
                                    throw sQLException;
                                }
                                if (n15 < 0) continue;
                                n6 = 1;
                                this.parameterLengths_[i] = n15;
                                this.parameterTotalSize_ = this.parameterOffsets_[i] + n15;
                                if (i + 1 >= this.parameterCount_) continue;
                                for (int j = i + 1; j < this.parameterCount_; ++j) {
                                    this.parameterOffsets_[j] = this.parameterTotalSize_;
                                    this.parameterTotalSize_ += this.parameterLengths_[j];
                                }
                            }
                            if (n6 == 0) continue;
                            this.changeDescriptor();
                        }
                        if (n4 == 0) continue;
                        n7 = (n9 += n8) - n2;
                        dBSQLRequestDS.updateLength(n, n7);
                        if (n3 <= 80 * n7 / 100) continue;
                        this.disableRllCompression_ = true;
                    } while (n6 != 0);
                    dBSQLRequestDS.setParameterMarkerBlockIndicator(0);
                }
                if (this.outputParametersExpected_) {
                    dBSQLRequestDS.addOperationResultBitmap(0x4000000);
                }
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException((Object)this, "HY000", dBDataStreamException);
            }
        }
    }

    private boolean useVariableFieldInsertCompression() throws SQLException {
        if (this.useVariableFieldInsertCompression_) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.parameterCount_; ++i) {
                int n3 = this.parameterRow_.getLength(i + 1);
                SQLData sQLData = this.parameterRow_.getSQLType(i + 1);
                if (sQLData instanceof SQLVariableCompressible) {
                    n2 += n3;
                }
                n += n3;
            }
            return n2 > n / 3;
        }
        return false;
    }

    @Override
    void commonPrepareAfter(JDSQLStatement jDSQLStatement, DBReplyRequestedDS dBReplyRequestedDS) throws SQLException {
        super.commonPrepareAfter(jDSQLStatement, dBReplyRequestedDS);
        if (this.prepared_) {
            JDServerRow jDServerRow = new JDServerRow(this.connection_, this.id_, dBReplyRequestedDS.getParameterMarkerFormat(), this.settings_);
            if (this.preserveParameters_ && this.parameterRow_ != null) {
                jDServerRow.restoreSavedParameters(this.parameterRow_);
            }
            this.parameterRow_ = jDServerRow;
        }
    }

    @Override
    void commonPrepareBefore(JDSQLStatement jDSQLStatement, DBSQLRequestDS dBSQLRequestDS) throws SQLException {
        super.commonPrepareBefore(jDSQLStatement, dBSQLRequestDS);
        if (this.prepared_) {
            dBSQLRequestDS.addOperationResultBitmap(0x800000);
        }
    }

    @Override
    void commonPrepareBypass(JDSQLStatement jDSQLStatement, int n) throws SQLException {
        super.commonPrepareBypass(jDSQLStatement, n);
        if (this.prepared_) {
            this.parameterRow_ = new JDServerRow(this.connection_, this.id_, this.packageManager_.getCachedParameterMarkerFormat(n), this.settings_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (!this.prepared_) {
                this.resultRow_ = this.commonPrepare(this.sqlStatement_);
                this.prepared_ = true;
            }
            this.commonExecute(this.sqlStatement_, this.resultRow_);
            this.executed_ = true;
            return this.resultSet_ != null;
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return false;
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return false;
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return false;
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.batch_ == null || this.batch_.size() == 0) {
                return new int[0];
            }
            this.batchParameterRows_ = new Vector();
            int n = this.batch_.size();
            int[] nArray = new int[n];
            int n2 = 0;
            boolean bl = true;
            try {
                if (!this.sqlStatement_.canBatch()) {
                    bl = false;
                }
                if (this.containsLocator_ == 1) {
                    bl = false;
                }
                this.batchExecute_ = true;
                this.rowsInserted_ = 0;
                if (!this.prepared_) {
                    this.resultRow_ = this.commonPrepare(this.sqlStatement_);
                    this.prepared_ = true;
                    if (this.resultSet_ != null) {
                        this.closeResultSet(241);
                        JDError.throwSQLException((Object)this, "24000");
                    }
                }
                if (bl) {
                    int n3 = this.connection_.getMaximumBlockedInputRows();
                    Enumeration enumeration = this.batch_.elements();
                    int n4 = 0;
                    int n5 = 0;
                    while (enumeration.hasMoreElements()) {
                        this.batchParameterRows_.add(enumeration.nextElement());
                        if (++n4 != n3 || !enumeration.hasMoreElements()) continue;
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "Begin batching via server-side with " + this.batchParameterRows_.size() + " rows.");
                        }
                        this.executingBatchedStatement_ = true;
                        this.commonExecute(this.sqlStatement_, this.resultRow_);
                        this.executingBatchedStatement_ = false;
                        n5 += this.updateCount_;
                        this.batchParameterRows_.clear();
                        if (this.resultSet_ != null) {
                            this.closeResultSet(241);
                            JDError.throwSQLException((Object)this, "24000");
                        }
                        n4 = 0;
                    }
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Begin batching via server-side with " + this.batchParameterRows_.size() + " rows.");
                    }
                    this.executingBatchedStatement_ = true;
                    this.commonExecute(this.sqlStatement_, this.resultRow_);
                    this.executingBatchedStatement_ = false;
                    n5 += this.updateCount_;
                    this.batchParameterRows_.clear();
                    if (this.resultSet_ != null) {
                        this.closeResultSet(241);
                        JDError.throwSQLException((Object)this, "24000");
                    }
                    n2 = n;
                    int n6 = -2;
                    if (n == n5 && this.sqlStatement_.isInsert_) {
                        n6 = 1;
                    }
                    for (int i = 0; i < n; ++i) {
                        nArray[i] = n6;
                    }
                } else {
                    Enumeration enumeration = this.batch_.elements();
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Begin batching via client-side multiple executes.");
                    }
                    while (enumeration.hasMoreElements()) {
                        this.batchParameterRows_.addElement(enumeration.nextElement());
                        this.executingBatchedStatement_ = true;
                        this.commonExecute(this.sqlStatement_, this.resultRow_);
                        this.executingBatchedStatement_ = false;
                        this.batchParameterRows_.removeAllElements();
                        if (this.resultSet_ != null) {
                            this.closeResultSet(241);
                            JDError.throwSQLException((Object)this, "24000");
                        }
                        nArray[n2++] = this.rowsInserted_;
                    }
                }
                this.executed_ = true;
            }
            catch (SQLException sQLException) {
                int[] nArray2 = null;
                if (bl) {
                    nArray2 = new int[this.rowsInserted_];
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = -2;
                    }
                } else {
                    nArray2 = new int[n2];
                    System.arraycopy(nArray, 0, nArray2, 0, n2);
                }
                BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
                try {
                    batchUpdateException.initCause(sQLException);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                throw batchUpdateException;
            }
            finally {
                this.batch_.removeAllElements();
                this.batchExecute_ = false;
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "Done batching.");
                }
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (!this.prepared_) {
                this.resultRow_ = this.commonPrepare(this.sqlStatement_);
                this.prepared_ = true;
            }
            this.commonExecute(this.sqlStatement_, this.resultRow_);
            this.executed_ = true;
            if (this.resultSet_ == null && (this.behaviorOverride_ & 1) == 0) {
                JDError.throwSQLException((Object)this, "24000");
            }
            return this.resultSet_;
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (!this.prepared_) {
                this.resultRow_ = this.commonPrepare(this.sqlStatement_);
                this.prepared_ = true;
                if (this.resultRow_ != null) {
                    JDError.throwSQLException((Object)this, "24000");
                }
            }
            this.commonExecute(this.sqlStatement_, this.resultRow_);
            this.executed_ = true;
            if (this.resultSet_ != null) {
                this.closeResultSet(241);
                JDError.throwSQLException((Object)this, "24000");
            }
            return this.updateCount_;
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0;
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0;
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0;
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.resultRow_ == null) {
                return null;
            }
            ConvTable convTable = null;
            DBExtendedColumnDescriptors dBExtendedColumnDescriptors = this.extendedColumnDescriptors_;
            if (dBExtendedColumnDescriptors != null) {
                convTable = this.connection_.getConverter();
            }
            return new AS400JDBCResultSetMetaData(this.connection_.getCatalog(), this.resultSetConcurrency_, this.cursor_.getName(), this.resultRow_, dBExtendedColumnDescriptors, convTable, this.connection_);
        }
    }

    void validatePSParameterIndex(int n) throws SQLException {
        int n2 = this.getParameterCount();
        if (n > n2) {
            JDError.throwSQLException((Object)this, "07009", n + ">" + n2);
        }
        if (n < 1) {
            JDError.throwSQLException((Object)this, "07009", n + "<1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getParameterClassName(int n) throws SQLException {
        this.validatePSParameterIndex(n);
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return this.returnValueParameter_.getJavaClassName();
                }
                --n;
            }
            return this.parameterRow_.getSQLData(n).getJavaClassName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getParameterCount() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                return this.parameterCount_ + 1;
            }
            return this.parameterCount_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            return new AS400JDBCParameterMetaData(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getParameterMode(int n) throws SQLException {
        this.validatePSParameterIndex(n);
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return 4;
                }
                --n;
            }
            boolean bl = this.parameterRow_.isInput(n);
            boolean bl2 = this.parameterRow_.isOutput(n);
            if (bl && bl2) {
                return 2;
            }
            if (bl) {
                return 1;
            }
            if (bl2) {
                return 4;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getParameterType(int n) throws SQLException {
        this.validatePSParameterIndex(n);
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return this.returnValueParameter_.getType();
                }
                --n;
            }
            return this.parameterRow_.getSQLData(n).getType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getParameterCcsid(int n) throws SQLException {
        this.validatePSParameterIndex(n);
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return 0;
                }
                --n;
            }
            return this.parameterRow_.getCCSID(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String getParameterTypeName(int n) throws SQLException {
        this.validatePSParameterIndex(n);
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return this.returnValueParameter_.getTypeName();
                }
                --n;
            }
            return this.parameterRow_.getSQLData(n).getTypeName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getPrecision(int n) throws SQLException {
        this.validatePSParameterIndex(n);
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return this.returnValueParameter_.getPrecision();
                }
                --n;
            }
            return this.parameterRow_.getSQLData(n).getPrecision();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int getScale(int n) throws SQLException {
        this.validatePSParameterIndex(n);
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return this.returnValueParameter_.getScale();
                }
                --n;
            }
            return this.parameterRow_.getSQLData(n).getScale();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int isNullable(int n) throws SQLException {
        this.validatePSParameterIndex(n);
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return 0;
                }
                --n;
            }
            return this.parameterRow_.isNullable(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isSigned(int n) throws SQLException {
        this.validatePSParameterIndex(n);
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    return this.returnValueParameter_.isSigned();
                }
                --n;
            }
            return this.parameterRow_.getSQLData(n).isSigned();
        }
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setArray()");
            if (array == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: Array type " + array.getBaseTypeName());
            }
        }
        if (!this.sqlStatement_.isProcedureCall()) {
            JDError.throwSQLException((Object)this, "HY105");
        }
        this.setValue(n, array, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setAsciiStream()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + n2);
            }
        }
        if (n2 < 0) {
            JDError.throwSQLException((Object)this, "HY090");
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            this.validatePSParameterIndex(n);
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --n;
                }
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sQLData = this.parameterRow_.getSQLType(n);
            if (inputStream != null) {
                try {
                    int n3 = sQLData.getSQLType();
                    if (n3 == 8 || n3 == 4 || n3 == 12 || n3 == 34 || n3 == 40) {
                        SQLLocator sQLLocator = (SQLLocator)sQLData;
                        sQLLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(n));
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(n));
                        }
                        sQLData.set(new ConvTableReader(inputStream, 819, 0, 1000000), null, n2);
                    } else if (n3 == 41) {
                        JDError.throwSQLException((Object)this, "07006");
                    } else {
                        sQLData.set(JDUtilities.readerToString(new ConvTableReader(inputStream, 819, 0, 1000000), n2), null, -1);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.testDataTruncation(n, sQLData);
            }
            this.parameterNulls_[n - 1] = inputStream == null;
            this.parameterDefaults_[n - 1] = false;
            this.parameterUnassigned_[n - 1] = false;
            this.parameterSet_[n - 1] = true;
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBigDecimal()");
            if (bigDecimal == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + bigDecimal.toString());
            }
        }
        this.setValue(n, bigDecimal, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBinaryStream()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + n2);
            }
        }
        if (n2 < 0) {
            JDError.throwSQLException((Object)this, "HY090");
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            this.validatePSParameterIndex(n);
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --n;
                }
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sQLData = this.parameterRow_.getSQLType(n);
            if (inputStream != null) {
                if (sQLData instanceof SQLLocator) {
                    SQLLocator sQLLocator = (SQLLocator)sQLData;
                    sQLLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(n));
                    sQLData.set(inputStream, null, n2);
                } else {
                    sQLData.set(JDUtilities.streamToBytes(inputStream, n2), null, n2);
                }
                this.testDataTruncation(n, sQLData);
            }
            this.parameterNulls_[n - 1] = inputStream == null;
            this.parameterDefaults_[n - 1] = false;
            this.parameterUnassigned_[n - 1] = false;
            this.parameterSet_[n - 1] = true;
        }
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob()");
            if (blob == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + blob.length());
            }
        }
        this.setValue(n, blob, null, -1);
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBoolean()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + bl);
        }
        this.setValue(n, new Short((short)(bl ? 1 : 0)), null, -1);
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setByte()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + by);
        }
        this.setValue(n, new Short(by), null, -1);
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBytes()");
            if (byArray == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else if (byArray.length > this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + byArray.length);
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + byArray.length + " value: " + Trace.toHexString(byArray));
            }
        }
        this.setValue(n, byArray, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setCharacterStream()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + n2);
            }
        }
        if (n2 < 0) {
            JDError.throwSQLException((Object)this, "HY090");
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            this.validatePSParameterIndex(n);
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --n;
                }
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sQLData = this.parameterRow_.getSQLType(n);
            if (reader != null) {
                int n3 = sQLData.getSQLType();
                if (n3 == 8 || n3 == 4 || n3 == 12 || n3 == 34 || n3 == 40) {
                    SQLLocator sQLLocator = (SQLLocator)sQLData;
                    sQLLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(n));
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(n));
                    }
                    sQLData.set(JDUtilities.readerToString(reader, n2), null, -1);
                } else if (n3 == 41) {
                    JDError.throwSQLException((Object)this, "07006");
                } else {
                    sQLData.set(JDUtilities.readerToString(reader, n2), null, -1);
                }
                this.testDataTruncation(n, sQLData);
            }
            this.parameterNulls_[n - 1] = reader == null;
            this.parameterDefaults_[n - 1] = false;
            this.parameterUnassigned_[n - 1] = false;
            this.parameterSet_[n - 1] = true;
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob()");
            if (clob == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else if (clob.length() > (long)this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + clob.getSubString(1L, (int)clob.length()));
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + clob.length());
            }
        }
        this.setValue(n, clob, null, -1);
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDate()");
            if (date == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + date.toString());
            }
        }
        this.setValue(n, date, null, -1);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDate()");
            if (date == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + date.toString());
            }
        }
        if (calendar == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        this.setValue(n, date, calendar, -1);
    }

    @Override
    public void setDB2Default(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDB2Default()");
            JDTrace.logInformation(this, "parameter index: " + n);
        }
        this.setValueExtendedIndicator(n, 1);
    }

    @Override
    public void setDBDefault(int n) throws SQLException {
        this.setDB2Default(n);
    }

    @Override
    public void setDB2Unassigned(int n) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDB2Unassigned()");
            JDTrace.logInformation(this, "parameter index: " + n);
        }
        this.setValueExtendedIndicator(n, 2);
    }

    @Override
    public void setDBUnassigned(int n) throws SQLException {
        this.setDB2Unassigned(n);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setDouble()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + d);
        }
        this.setValue(n, new Double(d), null, -1);
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setFloat()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + f);
        }
        this.setValue(n, new Float(f), null, -1);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setInt()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + n2);
        }
        this.setValue(n, new Integer(n2), null, -1);
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setLong()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + l);
        }
        this.setValue(n, new Long(l), null, -1);
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNull()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
        }
        this.setValue(n, null, null, -1);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNull()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
        }
        this.setNull(n, n2);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (object == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " type: " + object.getClass().getName() + " toString():" + object.toString());
            }
        }
        this.setValue(n, object, null, -1);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (object == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " type: " + object.getClass().getName() + " toString():" + object.toString());
            }
        }
        this.setValue(n, object, null, -1);
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setObject()");
            if (object == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " type: " + object.getClass().getName() + " toString():" + object.toString());
            }
        }
        if (n3 < 0) {
            JDError.throwSQLException((Object)this, "HY094");
        }
        if (object instanceof SQLXML) {
            this.setSQLXML(n, (SQLXML)object);
        } else {
            this.setValue(n, object, null, n3);
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        JDError.throwSQLException((Object)this, "HY105");
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setShort()");
            JDTrace.logInformation(this, "parameter index: " + n + " value: " + s);
        }
        this.setValue(n, new Short(s), null, -1);
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setString()");
            if (string == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else if (string.length() > this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + string.length());
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + string);
            }
        }
        this.setValue(n, string, null, -1);
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTime()");
            if (time == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + time.toString());
            }
        }
        this.setValue(n, time, null, -1);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTime()");
            if (time == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + time.toString());
            }
        }
        if (calendar == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        this.setValue(n, time, calendar, -1);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTimeStamp()");
            if (timestamp == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + timestamp.toString());
            }
        }
        this.setValue(n, timestamp, null, -1);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setTimeStamp()");
            if (timestamp == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + timestamp.toString());
            }
        }
        if (calendar == null) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        this.setValue(n, timestamp, calendar, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setUnicodeStream()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + n2);
            }
        }
        if (n2 < 0) {
            JDError.throwSQLException((Object)this, "HY090");
        }
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            this.validatePSParameterIndex(n);
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --n;
                }
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sQLData = this.parameterRow_.getSQLType(n);
            if (inputStream != null) {
                try {
                    int n3 = sQLData.getSQLType();
                    if (n3 == 8 || n3 == 4 || n3 == 12 || n3 == 34 || n3 == 40) {
                        SQLLocator sQLLocator = (SQLLocator)sQLData;
                        sQLLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(n));
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(n));
                        }
                        sQLData.set(new ConvTableReader(inputStream, 13488, 0, 1000000), null, n2 / 2);
                    } else if (n3 == 41) {
                        JDError.throwSQLException((Object)this, "07006");
                    } else {
                        sQLData.set(JDUtilities.readerToString(new ConvTableReader(inputStream, 13488, 0, 1000000), n2 / 2), null, -1);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.testDataTruncation(n, sQLData);
            }
            this.parameterNulls_[n - 1] = inputStream == null;
            this.parameterDefaults_[n - 1] = false;
            this.parameterUnassigned_[n - 1] = false;
            this.parameterSet_[n - 1] = true;
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setURL()");
            if (uRL == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + uRL.toString());
            }
        }
        this.setValue(n, uRL, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setValue(int n, Object object, Calendar calendar, int n2) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            this.validatePSParameterIndex(n);
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --n;
                }
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sQLData = this.parameterRow_.getSQLType(n);
            if (object != null) {
                int n3 = sQLData.getSQLType();
                if (n3 == 8 || n3 == 4 || n3 == 12 || n3 == 34 || n3 == 40) {
                    SQLLocator sQLLocator = (SQLLocator)sQLData;
                    sQLLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(n));
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(n));
                    }
                }
                sQLData.set(object, calendar, n2);
                this.testDataTruncation(n, sQLData);
            }
            this.parameterNulls_[n - 1] = object == null;
            this.parameterDefaults_[n - 1] = false;
            this.parameterUnassigned_[n - 1] = false;
            this.parameterSet_[n - 1] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setValueExtendedIndicator(int n, int n2) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            this.validatePSParameterIndex(n);
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --n;
                }
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            this.parameterNulls_[n - 1] = false;
            this.parameterDefaults_[n - 1] = n2 == 1;
            this.parameterUnassigned_[n - 1] = n2 == 2;
            this.parameterSet_[n - 1] = true;
        }
    }

    private boolean testDataTruncation(int n, SQLData sQLData) throws SQLException {
        return this.connection_.testDataTruncation(this, null, n, true, sQLData, this.sqlStatement_);
    }

    void testSQLType(int n, int n2) throws SQLException {
        int n3 = this.parameterRow_.getSQLType(n2).getType();
        if (n != n3 && (n != 1 && n != 12 || n3 != 1 && n3 != 12)) {
            JDError.throwSQLException((Object)this, "HY105");
        }
    }

    @Override
    JDServerRow getResultRow() {
        return this.resultRow_;
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setRowId()");
            if (rowId == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + rowId.toString());
            }
        }
        this.setValue(n, rowId, null, -1);
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNString()");
            if (string == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else if (string.length() > this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + string.length());
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + string);
            }
        }
        this.setString(n, string);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNCharacterStream()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + l);
            }
        }
        this.setCharacterStream(n, reader, (int)l);
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNClob()");
            if (nClob == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else if (nClob.length() > (long)this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + nClob.getSubString(1L, (int)nClob.length()));
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + nClob.length());
            }
        }
        this.setClob(n, nClob);
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + l);
            }
        }
        this.setCharacterStream(n, reader, (int)l);
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob()");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + l);
            }
        }
        this.setBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNClob()");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + l);
            }
        }
        this.setCharacterStream(n, reader, (int)l);
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        if (JDTrace.isTraceOn()) {
            int n2 = sQLXML == null ? 0 : sQLXML.getString().length();
            JDTrace.logInformation(this, "setSQLXML()");
            if (sQLXML == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            } else if (n2 < this.maxToLog_) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: " + sQLXML.getString());
            } else {
                JDTrace.logInformation(this, "parameter index: " + n + " length: " + n2);
            }
        }
        if (sQLXML == null) {
            this.setValue(n, sQLXML, null, -1);
            return;
        }
        SQLData sQLData = this.parameterRow_.getSQLType(n);
        int n3 = sQLData.getType();
        switch (n3) {
            case 2005: {
                this.setCharacterStream(n, sQLXML.getCharacterStream());
                break;
            }
            case 2004: {
                this.setBinaryStream(n, sQLXML.getBinaryStream());
                break;
            }
            default: {
                this.setValue(n, sQLXML, null, -1);
            }
        }
    }

    @Override
    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCPreparedStatement", "java.sql.PreparedStatement"};
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.setAsciiStream(n, inputStream, (int)l);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.setBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, (int)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeParameterNames() throws SQLException {
        boolean bl = this.sqlStatement_.getProcedure() != null;
        int n = 0;
        if (this.parameterNames_ == null) {
            Object object;
            this.parameterNames_ = new String[this.parameterCount_];
            boolean bl2 = true;
            for (int i = 0; bl2 && i < this.parameterCount_; ++i) {
                try {
                    object = this.parameterRow_.getFieldName(i + 1);
                    if (object != null) {
                        this.parameterNames_[i] = object;
                        continue;
                    }
                    if (!bl) continue;
                    bl2 = false;
                    continue;
                }
                catch (SQLException sQLException) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logException(this, "exception while retrieving field names", sQLException);
                    }
                    bl2 = false;
                }
            }
            if (!bl2) {
                Statement statement = null;
                object = null;
                try {
                    Object object2;
                    Object object3;
                    statement = this.connection_.createStatement();
                    String string = "";
                    string = this.connection_.getProperties().equals(9, "sql") ? "." : "/";
                    String string2 = this.sqlStatement_.getSchema();
                    if ((string2 == null || string2.equals("")) && (string2 = this.connection_.getDefaultSchema(true)) == null) {
                        if (string.equals(".")) {
                            string2 = this.connection_.getUserName();
                        } else {
                            object3 = JDUtilities.getLibraries(this, this.connection_, null, true);
                            object2 = new Vector<String>();
                            while (object3.next()) {
                                ((Vector)object2).addElement(object3.getString(1));
                            }
                            object3.close();
                            String[] stringArray = new String[((Vector)object2).size()];
                            ((Vector)object2).toArray(stringArray);
                            Statement statement2 = this.connection_.createStatement(1004, 1007);
                            object = statement2.executeQuery("SELECT ROUTINE_SCHEMA FROM QSYS2" + string + "SYSPROCS WHERE ROUTINE_NAME='" + AS400JDBCPreparedStatementImpl.unquote(this.sqlStatement_.getProcedure()) + "' AND IN_PARMS + OUT_PARMS + INOUT_PARMS = " + this.parameterCount_);
                            if (!object.next()) {
                                JDError.throwSQLException((Object)this, "HY000");
                            }
                            boolean bl3 = false;
                            for (int i = 0; i < stringArray.length && !bl3; ++i) {
                                if (stringArray[i].length() == 0) continue;
                                object.beforeFirst();
                                while (object.next() && !bl3) {
                                    if (!object.getString(1).equals(stringArray[i])) continue;
                                    string2 = object.getString(1);
                                    bl3 = true;
                                }
                            }
                            object.close();
                            statement2.close();
                            if (!bl3) {
                                JDError.throwSQLException((Object)this, "HY000");
                            }
                        }
                    }
                    if (!(object = statement.executeQuery("SELECT SPECIFIC_NAME FROM QSYS2" + string + "SYSPROCS WHERE ROUTINE_SCHEMA = '" + AS400JDBCPreparedStatementImpl.unquote(string2) + "' AND ROUTINE_NAME = '" + AS400JDBCPreparedStatementImpl.unquote(this.sqlStatement_.getProcedure()) + "' AND IN_PARMS + OUT_PARMS + INOUT_PARMS = " + this.parameterCount_)).next()) {
                        JDError.throwSQLException((Object)this, "HY000");
                    }
                    object3 = object.getString(1);
                    object.close();
                    object = statement.executeQuery("SELECT PARAMETER_NAME, ORDINAL_POSITION FROM QSYS2" + string + "SYSPARMS WHERE  SPECIFIC_NAME = '" + AS400JDBCPreparedStatementImpl.unquoteNoUppercase((String)object3) + "' AND SPECIFIC_SCHEMA = '" + AS400JDBCPreparedStatementImpl.unquote(string2) + "'");
                    while (object.next()) {
                        ++n;
                        object2 = object.getString(1);
                        int n2 = object.getInt(2);
                        this.parameterNames_[n2 - 1] = object2;
                    }
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                if (n != this.parameterCount_) {
                    JDError.throwSQLException((Object)this, "HY000");
                }
            }
        }
    }

    @Override
    int findParameterIndex(String string) throws SQLException {
        if (string == null) {
            throw JDError.throwSQLException((Object)this, "HY024");
        }
        if (this.isClosed()) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = JDUtilities.stripOuterDoubleQuotes(string);
            bl = true;
        }
        if (this.parameterNames_ == null) {
            this.initializeParameterNames();
        }
        while (n < this.parameterNames_.length) {
            if (this.parameterNames_[n] != null && (bl && this.parameterNames_[n].equals(string) || !bl && this.parameterNames_[n].equalsIgnoreCase(string))) {
                n2 = n + 1;
                break;
            }
            ++n;
        }
        if (n2 == 0) {
            JDError.throwSQLException((Object)this, "42703");
        }
        if (this.useReturnValueParameter_) {
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDB2ParameterName(int n) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            this.validatePSParameterIndex(n);
            --n;
            if (this.useReturnValueParameter_) {
                --n;
            }
            if (this.parameterNames_ == null) {
                this.initializeParameterNames();
            }
            if (n >= 0 && n < this.parameterNames_.length) {
                return this.parameterNames_[n];
            }
            JDError.throwSQLException((Object)this, "07009", "INTERNAL_ERROR");
            return null;
        }
    }

    private static final String unquote(String string) {
        return JDUtilities.prepareForSingleQuotes(string, true);
    }

    private static final String unquoteNoUppercase(String string) {
        return JDUtilities.prepareForSingleQuotes(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInputStream(int n, InputStream inputStream) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            this.validatePSParameterIndex(n);
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --n;
                }
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sQLData = this.parameterRow_.getSQLType(n);
            if (inputStream != null) {
                int n2 = sQLData.getSQLType();
                if (n2 == 8 || n2 == 4 || n2 == 12 || n2 == 34 || n2 == 40) {
                    SQLLocator sQLLocator = (SQLLocator)sQLData;
                    sQLLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(n));
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(n));
                    }
                    sQLData.set(inputStream, null, -2);
                } else {
                    sQLData.set(inputStream, null, -2);
                }
                this.testDataTruncation(n, sQLData);
            }
            this.parameterNulls_[n - 1] = inputStream == null;
            this.parameterSet_[n - 1] = true;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setAsciiStream(int, InputStream)");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            }
        }
        this.setInputStream(n, inputStream);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBinaryStream(int, InputStream)");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            }
        }
        this.setInputStream(n, inputStream);
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setBlob(int, InputStream)");
            if (inputStream == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            }
        }
        this.setInputStream(n, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReader(int n, Reader reader) throws SQLException {
        AS400JDBCStatementLock aS400JDBCStatementLock = this.internalLock_;
        synchronized (aS400JDBCStatementLock) {
            this.checkOpen();
            this.validatePSParameterIndex(n);
            if (this.useReturnValueParameter_) {
                if (n == 1) {
                    JDError.throwSQLException((Object)this, "HY105");
                } else {
                    --n;
                }
            }
            if (!this.parameterRow_.isInput(n)) {
                JDError.throwSQLException((Object)this, "HY105");
            }
            SQLData sQLData = this.parameterRow_.getSQLType(n);
            if (reader != null) {
                int n2 = sQLData.getSQLType();
                if (n2 == 8 || n2 == 4 || n2 == 12 || n2 == 34 || n2 == 40) {
                    SQLLocator sQLLocator = (SQLLocator)sQLData;
                    sQLLocator.setHandle(this.parameterRow_.getFieldLOBLocatorHandle(n));
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "locator handle: " + this.parameterRow_.getFieldLOBLocatorHandle(n));
                    }
                    sQLData.set(reader, null, -2);
                } else if (n2 == 41) {
                    JDError.throwSQLException((Object)this, "07006");
                } else {
                    sQLData.set(JDUtilities.readerToString(reader), null, -1);
                }
                this.testDataTruncation(n, sQLData);
            }
            this.parameterNulls_[n - 1] = reader == null;
            this.parameterSet_[n - 1] = true;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setCharacterStream(int, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            }
        }
        this.setReader(n, reader);
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setClob(int, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            }
        }
        this.setReader(n, reader);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNCharacterStream(int, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            }
        }
        this.setReader(n, reader);
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "setNClob(int, Reader)");
            if (reader == null) {
                JDTrace.logInformation(this, "parameter index: " + n + " value: NULL");
            }
        }
        this.setReader(n, reader);
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        int n3 = this.mapSQLType(sQLType);
        this.setObject(n, object, n3, n2);
    }

    int mapSQLType(SQLType sQLType) throws SQLException {
        if (sQLType instanceof JDBCType) {
            return sQLType.getVendorTypeNumber();
        }
        throw new SQLFeatureNotSupportedException("targetSqlType=" + sQLType);
    }

    @Override
    public void setObject(int n, Object object, SQLType sQLType) throws SQLException {
        int n2 = this.mapSQLType(sQLType);
        this.setObject(n, object, n2);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.executeUpdate();
    }

    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String string, int n) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0L;
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        JDError.throwSQLException((Object)this, "HY010");
        return 0L;
    }

    @Override
    void checkOpen() throws SQLException {
        super.checkOpen();
        if (this.connectionReset_) {
            this.preserveParameters_ = true;
            if (this.parameterRow_ != null) {
                this.parameterRow_.saveValues();
            }
            this.resultRow_ = this.commonPrepare(this.sqlStatement_);
            this.connectionReset_ = false;
        }
    }

    @Override
    void setConnectionReset(boolean bl) {
        this.descriptorHandle_ = 0;
        super.setConnectionReset(bl);
    }

    @Override
    void setSaveParameterValues(boolean bl) {
        this.saveParameterValues_ = bl;
    }

    static {
        String string = SystemProperties.getProperty("com.ibm.as400.access.JDBC.jvm16Synchronize");
        isjvm16SynchronizerStatic = false;
        if (string != null && Boolean.valueOf(string.trim()).booleanValue()) {
            try {
                Class.forName("java.sql.SQLXML");
                isjvm16SynchronizerStatic = true;
            }
            catch (Exception exception) {
                isjvm16SynchronizerStatic = false;
            }
        } else {
            isjvm16SynchronizerStatic = false;
        }
    }
}

