/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;

public class AS400Text
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private int length_;
    private int ccsid_ = 65535;
    private transient String encoding_ = null;
    private AS400 system_;
    transient ConverterImpl tableImpl_;
    private static final String defaultValue_ = "";
    private byte[] padding_ = null;

    public AS400Text(int n) {
        if (n < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n);
            throw new ExtendedIllegalArgumentException("length (" + n + ")", 2);
        }
        this.length_ = n;
    }

    public AS400Text(int n, int n2) {
        if (n < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n);
            throw new ExtendedIllegalArgumentException("length (" + n + ")", 2);
        }
        if (n2 < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("ccsid (" + n2 + ")", 2);
        }
        this.length_ = n;
        this.ccsid_ = n2;
    }

    public AS400Text(int n, String string) {
        if (n < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n);
            throw new ExtendedIllegalArgumentException("length (" + n + ")", 2);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'encoding' is null.");
            throw new NullPointerException("encoding");
        }
        this.length_ = n;
        this.encoding_ = string;
    }

    public AS400Text(int n, AS400 aS400) {
        this(n, 65535, aS400);
    }

    public AS400Text(int n, int n2, AS400 aS400) {
        if (n < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n);
            throw new ExtendedIllegalArgumentException("length (" + n + ")", 2);
        }
        if (n2 < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("ccsid (" + n2 + ")", 2);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.length_ = n;
        this.ccsid_ = n2;
        this.system_ = aS400;
    }

    AS400Text(int n, int n2, AS400Impl aS400Impl) {
        if (n < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n);
            throw new ExtendedIllegalArgumentException("length (" + n + ")", 2);
        }
        if (n2 < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("ccsid (" + n2 + ")", 2);
        }
        if (aS400Impl == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.length_ = n;
        this.ccsid_ = n2;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected CloneNotSupportedException:", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(10);
        }
    }

    @Override
    public int getByteLength() {
        return this.length_;
    }

    public int getCcsid() {
        if (this.ccsid_ == 65535) {
            this.setTable();
        }
        return this.ccsid_;
    }

    ConverterImpl getConverter() {
        this.setTable();
        return this.tableImpl_;
    }

    @Override
    public Object getDefaultValue() {
        return defaultValue_;
    }

    public String getEncoding() {
        if (this.encoding_ == null) {
            this.setTable();
        }
        return this.encoding_;
    }

    @Override
    public int getInstanceType() {
        return 9;
    }

    @Override
    public Class getJavaType() {
        return String.class;
    }

    void setConverter(AS400 aS400) {
        this.system_ = aS400;
        this.setTable();
    }

    void setConverter(ConverterImpl converterImpl) {
        this.tableImpl_ = converterImpl;
        this.ccsid_ = this.tableImpl_.getCcsid();
    }

    private void setTable() {
        if (this.tableImpl_ == null) {
            if (Trace.traceOn_) {
                Trace.log(5, "AS400Text object initializing, encoding: " + this.encoding_ + ", CCSID: " + this.ccsid_ + ", system: " + this.system_);
            }
            if (this.encoding_ != null) {
                try {
                    Converter converter = new Converter(this.encoding_);
                    this.ccsid_ = converter.getCcsid();
                    this.tableImpl_ = converter.impl;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ExtendedIllegalArgumentException("encoding (" + this.encoding_ + ")", 2);
                }
            }
            try {
                if (this.system_ == null) {
                    Converter converter;
                    if (this.ccsid_ == 65535) {
                        converter = new Converter();
                        this.ccsid_ = converter.getCcsid();
                    } else {
                        converter = new Converter(this.ccsid_);
                    }
                    this.tableImpl_ = converter.impl;
                } else {
                    if (this.ccsid_ == 65535) {
                        this.ccsid_ = this.system_.getCcsid();
                    }
                    Converter converter = new Converter(this.ccsid_, this.system_);
                    this.tableImpl_ = converter.impl;
                }
                this.encoding_ = this.tableImpl_.getEncoding();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Trace.log(2, "Value of parameter 'ccsid' is not valid:", this.ccsid_);
                throw new ExtendedIllegalArgumentException("ccsid (" + this.ccsid_ + ")", 2);
            }
            if (Trace.traceOn_) {
                Trace.log(5, "AS400Text object initialized, encoding: " + this.encoding_ + ", CCSID: " + this.ccsid_ + ", system: " + this.system_ + ", table: " + this.tableImpl_);
            }
        }
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] byArray = new byte[this.length_];
        this.toBytes(object, byArray, 0);
        return byArray;
    }

    @Override
    public int toBytes(Object object, byte[] byArray) {
        return this.toBytes(object, byArray, 0);
    }

    @Override
    public int toBytes(Object object, byte[] byArray, int n) {
        if (this.system_ != null && !this.system_.bidiAS400Text) {
            return this.toBytes(object, byArray, n, new BidiConversionProperties(AS400BidiTransform.getStringType(this.system_.getCcsid())));
        }
        return this.toBytes(object, byArray, n, new BidiConversionProperties(this.getSystemBidiType()));
    }

    public int toBytes(Object object, byte[] byArray, int n, int n2) {
        return this.toBytes(object, byArray, n, new BidiConversionProperties(n2));
    }

    public int toBytes(Object object, byte[] byArray, int n, BidiConversionProperties bidiConversionProperties) {
        byte[] byArray2;
        int n2;
        if (object == null) {
            Trace.log(2, "Parameter 'javaValue' is null.");
            throw new NullPointerException("javaValue");
        }
        this.setTable();
        String string = (String)object;
        if (AS400BidiTransform.isBidiCcsid(this.ccsid_)) {
            int n3 = string.length();
            if (this.ccsid_ == 13488 || this.ccsid_ == 61952) {
                n3 *= 2;
            }
            n2 = this.length_ - n3;
            if (this.ccsid_ == 13488 || this.ccsid_ == 61952) {
                n2 /= 2;
            }
            if (n2 > 0) {
                char[] cArray = string.toCharArray();
                char[] cArray2 = new char[cArray.length + n2];
                System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                for (int i = cArray.length; i < cArray2.length; ++i) {
                    cArray2[i] = 32;
                }
                string = new String(cArray2);
                if (Trace.traceOn_) {
                    Trace.log(5, "Pre-padded Bidi String with " + n2 + " spaces from '" + object + "' to '" + string + "'");
                }
            }
        }
        if ((byArray2 = this.tableImpl_.stringToByteArray(string, bidiConversionProperties)).length > this.length_) {
            Trace.log(2, "Length of parameter 'javaValue' is not valid: '" + object + "'");
            throw new ExtendedIllegalArgumentException("javaValue (" + string + ")", 1);
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        n2 = n + byArray2.length;
        if (n2 < byArray.length && n2 < n + this.length_) {
            if (this.padding_ == null) {
                this.padding_ = this.tableImpl_.stringToByteArray(" ");
                switch (this.padding_.length) {
                    case 0: {
                        this.padding_ = this.tableImpl_.stringToByteArray("\u3000");
                        break;
                    }
                    case 1: {
                        if (this.padding_[0] != 63 && this.padding_[0] != 127 && this.padding_[0] != 26) break;
                        this.padding_ = this.tableImpl_.stringToByteArray("\u3000");
                        break;
                    }
                    case 2: {
                        int n4 = 0xFFFF & BinaryConverter.byteArrayToShort(this.padding_, 0);
                        if (n4 != 65278 && n4 != 65533 && n4 != 63 && n4 != 127 && n4 != 26) break;
                        this.padding_ = this.tableImpl_.stringToByteArray("\u3000");
                        break;
                    }
                    default: {
                        if (Trace.traceOn_) {
                            Trace.log(4, "AS400Text.toBytes(): Padding character not found for 0x0020 or 0x3000 under CCSID " + this.tableImpl_.getCcsid(), this.padding_, 0, this.padding_.length);
                            Trace.log(4, "Using 0x40 as default padding character.");
                        }
                        this.padding_ = new byte[]{64};
                    }
                }
            }
            int n5 = n + this.length_ < byArray.length ? n + this.length_ : byArray.length;
            for (int i = 0; i < n5 - n2; ++i) {
                byArray[i + n2] = this.padding_[i % this.padding_.length];
            }
        }
        int n6 = n + this.length_ < byArray.length ? n + this.length_ : byArray.length;
        for (int i = 0; i < n6 - n2; ++i) {
            byArray[i + n2] = this.padding_[i % this.padding_.length];
        }
        if (Trace.traceOn_) {
            Trace.log(5, "AS400Text.toBytes(): Converted javaValue (" + string + ") to:", byArray, n, this.length_);
        }
        return this.length_;
    }

    @Override
    public Object toObject(byte[] byArray) {
        if (byArray == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        this.setTable();
        return this.tableImpl_.byteArrayToString(byArray, 0, this.length_, new BidiConversionProperties(this.getSystemBidiType()));
    }

    @Override
    public Object toObject(byte[] byArray, int n) {
        if (byArray == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        this.setTable();
        return this.tableImpl_.byteArrayToString(byArray, n, this.length_, new BidiConversionProperties(this.getSystemBidiType()));
    }

    public Object toObject(byte[] byArray, int n, int n2) {
        return this.toObject(byArray, n, new BidiConversionProperties(n2));
    }

    public Object toObject(byte[] byArray, int n, BidiConversionProperties bidiConversionProperties) {
        if (byArray == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        this.setTable();
        return this.tableImpl_.byteArrayToString(byArray, n, this.length_, bidiConversionProperties);
    }

    private int getSystemBidiType() {
        if (this.system_ == null) {
            return 0;
        }
        return this.system_.getBidiStringType();
    }
}

