/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400AbstractTime;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class AS400Timestamp
extends AS400AbstractTime {
    private static final long serialVersionUID = 1L;
    private static final BigInteger ONE_THOUSAND = new BigInteger("1000");
    private static final BigInteger ONE_MILLION = new BigInteger("1000000");
    private static final BigInteger DTS_CONVERSION_FACTOR = new BigInteger("946684800000000");
    private static final String PARSING_PATTERN = "yyyy-MM-dd-HH.mm.ss";
    private Timestamp defaultValue_;
    private transient SimpleDateFormat dateFormatterWithMillis_;
    public static final int FORMAT_DEFAULT = 0;
    static final int FORMAT_DTS = 1;

    public AS400Timestamp() {
        this.setFormat(0, HYPHEN);
    }

    public AS400Timestamp(TimeZone timeZone) {
        super(timeZone);
        this.setFormat(0, HYPHEN);
    }

    public AS400Timestamp(TimeZone timeZone, int n) {
        super(timeZone);
        this.setFormat(0, HYPHEN);
        this.setDataLength(n);
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValue_ == null) {
            this.defaultValue_ = new Timestamp(0L);
        }
        return this.defaultValue_;
    }

    @Override
    public int getInstanceType() {
        return 19;
    }

    @Override
    public Class getJavaType() {
        return Timestamp.class;
    }

    @Override
    void setFormat(int n) {
        super.setFormat(n);
    }

    @Override
    public int toBytes(Object object, byte[] byArray, int n) {
        return super.toBytes(object, byArray, n);
    }

    @Override
    public Object toObject(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("as400Value");
        }
        Timestamp timestamp = null;
        switch (this.getFormat()) {
            case 0: {
                String string = this.getCharConverter().byteArrayToString(byArray, n, this.getLength());
                timestamp = this.parse(string);
                break;
            }
            case 1: {
                byte[] byArray2 = new byte[9];
                System.arraycopy(byArray, n, byArray2, 1, 8);
                BigInteger bigInteger = new BigInteger(byArray2);
                byte[] byArray3 = new byte[]{0, -128, 0, 0, 0, 0, 0, 0, 0};
                BigInteger bigInteger2 = bigInteger.subtract(new BigInteger(byArray3));
                BigInteger bigInteger3 = bigInteger2.shiftRight(12);
                BigInteger bigInteger4 = bigInteger3.add(DTS_CONVERSION_FACTOR);
                long l = bigInteger4.divide(ONE_THOUSAND).longValue();
                timestamp = new Timestamp(l);
                int n2 = bigInteger4.mod(ONE_MILLION).intValue();
                timestamp.setNanos(1000 * n2);
                break;
            }
            default: {
                throw new InternalErrorException(6, "Unrecognized format: " + this.getFormat(), null);
            }
        }
        return timestamp;
    }

    public Timestamp toTimestamp(byte[] byArray) {
        return (Timestamp)this.toObject(byArray, 0);
    }

    public Timestamp toTimestamp(byte[] byArray, int n) {
        return (Timestamp)this.toObject(byArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date toDate(Timestamp timestamp, TimeZone timeZone) {
        Date date;
        if (timestamp == null) {
            throw new NullPointerException("timestamp");
        }
        if (timeZone == null) {
            throw new NullPointerException("timezone");
        }
        if (timeZone.equals(AS400AbstractTime.TIMEZONE_GMT)) {
            return timestamp;
        }
        long l = timestamp.getTime();
        int n = timestamp.getNanos();
        int n2 = n % 1000000;
        if (n2 >= 500000) {
            ++l;
        }
        Object object = this;
        synchronized (object) {
            this.getCalendar().setTimeInMillis(l);
            date = this.getCalendar().getTime();
        }
        object = this.getDateFormatterWithMillis(AS400AbstractTime.TIMEZONE_GMT).format(date);
        try {
            return this.getDateFormatterWithMillis(timeZone).parse((String)object);
        }
        catch (ParseException parseException) {
            Trace.log(2, parseException);
            throw new InternalErrorException(10, (Throwable)parseException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString(Object object) {
        int n;
        int n2;
        Timestamp timestamp;
        if (object == null) {
            throw new NullPointerException("javaValue");
        }
        try {
            timestamp = (Timestamp)object;
        }
        catch (ClassCastException classCastException) {
            Trace.log(2, "javaValue is of type " + object.getClass().getName());
            throw classCastException;
        }
        int n3 = timestamp.getNanos();
        int n4 = n3 / 1000;
        int n5 = n3 % 1000;
        if (n5 >= 500 && ++n4 > 999999) {
            Timestamp timestamp2;
            timestamp = timestamp2 = new Timestamp(timestamp.getTime() + 1000L);
            n4 = 0;
        }
        Object object2 = this;
        synchronized (object2) {
            GregorianCalendar gregorianCalendar = this.getCalendar(timestamp);
            n2 = gregorianCalendar.get(1);
            n = gregorianCalendar.get(0);
        }
        if (n2 < 1 || n2 > 9999) {
            throw new ExtendedIllegalArgumentException("javaValue (year=" + n2 + ")", 4);
        }
        if (n == 0) {
            throw new ExtendedIllegalArgumentException("javaValue (era=0)", 4);
        }
        object2 = AS400Timestamp.to6Digits(n4);
        return this.getDateFormatter().format(timestamp) + "." + (String)object2;
    }

    public Timestamp parse(String object) {
        if (object == null) {
            throw new NullPointerException("source");
        }
        if (((String)object).length() < 19) {
            Trace.log(2, "Timestamp string is expected to be in format: " + this.patternFor(this.getFormat(), this.getSeparator()) + ".ssssss");
            throw new ExtendedIllegalArgumentException("source (" + (String)object + ")", 2);
        }
        try {
            Date date = this.getDateFormatter().parse(((String)object).substring(0, 19));
            Timestamp timestamp = new Timestamp(date.getTime());
            if (((String)object).length() > 19) {
                while (((String)object).length() < 26) {
                    object = (String)object + "0";
                }
                int n = Integer.parseInt(((String)object).substring(20));
                timestamp.setNanos(1000 * n);
            }
            return timestamp;
        }
        catch (Exception exception) {
            Trace.log(2, exception.getMessage(), (String)object);
            Trace.log(2, "Timestamp string is expected to be in format: " + this.patternFor(this.getFormat(), this.getSeparator()) + ".ssssss");
            throw new ExtendedIllegalArgumentException("source (" + (String)object + ")", 2, exception);
        }
    }

    public static Timestamp parseXsdString(String string) {
        return AS400Timestamp.parseXsdString(string, AS400AbstractTime.TIMEZONE_GMT);
    }

    public static Timestamp parseXsdString(String string, TimeZone timeZone) {
        if (string == null) {
            throw new NullPointerException("source");
        }
        try {
            Comparable<Date> comparable;
            int n = 0;
            String string2 = string.substring(0, 19);
            if (string.length() > 20) {
                comparable = new StringBuffer(string.substring(20));
                int n2 = 9 - ((StringBuffer)comparable).length();
                for (int i = 0; i < n2; ++i) {
                    ((StringBuffer)comparable).append('0');
                }
                n = Integer.parseInt(((StringBuffer)comparable).toString());
            }
            comparable = AS400Timestamp.getTimestampFormatterXSD(timeZone).parse(string2);
            Timestamp timestamp = new Timestamp(((Date)comparable).getTime());
            timestamp.setNanos(n);
            return timestamp;
        }
        catch (ParseException parseException) {
            Trace.log(2, parseException.getMessage(), string);
            Trace.log(2, "Timestamp string is expected to be in standard XML Schema 'timestamp' format: yyyy-MM-dd'T'HH:mm:ss.sssssssss");
            throw new ExtendedIllegalArgumentException("source (" + string + ")", 2, parseException);
        }
    }

    public static String toXsdString(Object object) {
        return AS400Timestamp.toXsdString(object, TIMEZONE_GMT);
    }

    public static String toXsdString(Object object, TimeZone timeZone) {
        Timestamp timestamp;
        if (object == null) {
            throw new NullPointerException("javaValue");
        }
        try {
            timestamp = (Timestamp)object;
        }
        catch (ClassCastException classCastException) {
            Trace.log(2, "javaValue is of type " + object.getClass().getName());
            throw classCastException;
        }
        StringBuffer stringBuffer = new StringBuffer(AS400Timestamp.getTimestampFormatterXSD(timeZone).format(timestamp));
        stringBuffer.append('.');
        stringBuffer.append(AS400Timestamp.to9Digits(timestamp.getNanos()));
        return stringBuffer.toString();
    }

    @Override
    String patternFor(int n, Character c) {
        return PARSING_PATTERN;
    }

    @Override
    Character defaultSeparatorFor(int n) {
        return HYPHEN;
    }

    private synchronized SimpleDateFormat getDateFormatterWithMillis(TimeZone timeZone) {
        if (this.dateFormatterWithMillis_ == null) {
            this.dateFormatterWithMillis_ = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss.SSS");
            this.dateFormatterWithMillis_.setTimeZone(timeZone);
        } else if (!this.dateFormatterWithMillis_.getTimeZone().equals(timeZone)) {
            this.dateFormatterWithMillis_.setTimeZone(timeZone);
        }
        return this.dateFormatterWithMillis_;
    }

    @Override
    boolean isValidFormat(int n) {
        return AS400Timestamp.validateFormat(n);
    }

    static boolean validateFormat(int n) {
        return n >= 0 && n <= 1;
    }

    static int getByteLength(int n) {
        switch (n) {
            case 1: {
                return 8;
            }
        }
        return 26;
    }

    @Override
    int lengthFor(int n) {
        return AS400Timestamp.getByteLength(n);
    }

    static final String to6Digits(int n) {
        if (n < 0 || n > 999999) {
            throw new InternalErrorException(6, "to6Digits(" + n + ")", null);
        }
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(n));
        int n2 = 6 - stringBuffer.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    static final String to9Digits(int n) {
        if (n < 0 || n > 999999999) {
            throw new InternalErrorException(6, "to9Digits(" + n + ")", null);
        }
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(n));
        int n2 = 9 - stringBuffer.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }
}

