/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;

public class AS400Varchar
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private int length_;
    private int ccsid_ = 65535;
    private transient String encoding_ = null;
    private AS400 system_;
    transient ConverterImpl tableImpl_;
    private static final String defaultValue_ = "";
    private int varlensize_ = 2;

    public AS400Varchar(int n, int n2) {
        if (n2 < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("length (" + n2 + ")", 2);
        }
        if (n < 0) {
            Trace.log(2, "Value of parameter 'varlensize' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("varlensize (" + n + ")", 2);
        }
        this.varlensize_ = n;
        this.length_ = n2;
    }

    public AS400Varchar(int n, int n2, int n3) {
        if (n2 < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("length (" + n2 + ")", 2);
        }
        if (n3 < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n3);
            throw new ExtendedIllegalArgumentException("ccsid (" + n3 + ")", 2);
        }
        if (n < 0) {
            Trace.log(2, "Value of parameter 'varlensize' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("varlensize (" + n + ")", 2);
        }
        this.varlensize_ = n;
        this.length_ = n2;
        this.ccsid_ = n3;
    }

    public AS400Varchar(int n, int n2, String string) {
        if (n2 < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("length (" + n2 + ")", 2);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'encoding' is null.");
            throw new NullPointerException("encoding");
        }
        if (n < 0) {
            Trace.log(2, "Value of parameter 'varlensize' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("varlensize (" + n + ")", 2);
        }
        this.varlensize_ = n;
        this.length_ = n2;
        this.encoding_ = string;
    }

    public AS400Varchar(int n, int n2, AS400 aS400) {
        this(n, n2, 65535, aS400);
    }

    public AS400Varchar(int n, int n2, int n3, AS400 aS400) {
        if (n2 < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("length (" + n2 + ")", 2);
        }
        if (n3 < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n3);
            throw new ExtendedIllegalArgumentException("ccsid (" + n3 + ")", 2);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (n < 0) {
            Trace.log(2, "Value of parameter 'varlensize' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("varlensize (" + n + ")", 2);
        }
        this.varlensize_ = n;
        this.length_ = n2;
        this.ccsid_ = n3;
        this.system_ = aS400;
    }

    AS400Varchar(int n, int n2, AS400Impl aS400Impl) {
        if (n < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n);
            throw new ExtendedIllegalArgumentException("length (" + n + ")", 2);
        }
        if (n2 < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("ccsid (" + n2 + ")", 2);
        }
        if (aS400Impl == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.length_ = n;
        this.ccsid_ = n2;
    }

    AS400Varchar(int n, int n2, int n3, AS400Impl aS400Impl) {
        if (n2 < 0) {
            Trace.log(2, "Value of parameter 'length' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("length (" + n2 + ")", 2);
        }
        if (n3 < 0) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n3);
            throw new ExtendedIllegalArgumentException("ccsid (" + n3 + ")", 2);
        }
        if (aS400Impl == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (n < 0) {
            Trace.log(2, "Value of parameter 'varlensize' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("varlensize (" + n + ")", 2);
        }
        this.varlensize_ = n;
        this.length_ = n2;
        this.ccsid_ = n3;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected CloneNotSupportedException:", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(10);
        }
    }

    @Override
    public int getByteLength() {
        return this.length_ + this.varlensize_;
    }

    public int getVarLengthSize() {
        return this.varlensize_;
    }

    public int getCcsid() {
        if (this.ccsid_ == 65535) {
            this.setTable();
        }
        return this.ccsid_;
    }

    ConverterImpl getConverter() {
        this.setTable();
        return this.tableImpl_;
    }

    @Override
    public Object getDefaultValue() {
        return defaultValue_;
    }

    public String getEncoding() {
        if (this.encoding_ == null) {
            this.setTable();
        }
        return this.encoding_;
    }

    @Override
    public int getInstanceType() {
        return 20;
    }

    @Override
    public Class getJavaType() {
        return String.class;
    }

    void setConverter(AS400 aS400) {
        this.system_ = aS400;
        this.setTable();
    }

    void setConverter(ConverterImpl converterImpl) {
        this.tableImpl_ = converterImpl;
        this.ccsid_ = this.tableImpl_.getCcsid();
    }

    private void setTable() {
        if (this.tableImpl_ == null) {
            if (Trace.traceOn_) {
                Trace.log(5, "AS400Varchar object initializing, encoding: " + this.encoding_ + ", CCSID: " + this.ccsid_ + ", system: " + this.system_);
            }
            if (this.encoding_ != null) {
                try {
                    Converter converter = new Converter(this.encoding_);
                    this.ccsid_ = converter.getCcsid();
                    this.tableImpl_ = converter.impl;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ExtendedIllegalArgumentException("encoding (" + this.encoding_ + ")", 2);
                }
            }
            try {
                if (this.system_ == null) {
                    Converter converter;
                    if (this.ccsid_ == 65535) {
                        converter = new Converter();
                        this.ccsid_ = converter.getCcsid();
                    } else {
                        converter = new Converter(this.ccsid_);
                    }
                    this.tableImpl_ = converter.impl;
                } else {
                    if (this.ccsid_ == 65535) {
                        this.ccsid_ = this.system_.getCcsid();
                    }
                    Converter converter = new Converter(this.ccsid_, this.system_);
                    this.tableImpl_ = converter.impl;
                }
                this.encoding_ = this.tableImpl_.getEncoding();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Trace.log(2, "Value of parameter 'ccsid' is not valid:", this.ccsid_);
                throw new ExtendedIllegalArgumentException("ccsid (" + this.ccsid_ + ")", 2);
            }
            if (Trace.traceOn_) {
                Trace.log(5, "AS400Varchar object initialized, encoding: " + this.encoding_ + ", CCSID: " + this.ccsid_ + ", system: " + this.system_ + ", table: " + this.tableImpl_);
            }
        }
    }

    @Override
    public byte[] toBytes(Object object) {
        byte[] byArray = new byte[this.length_ + this.varlensize_];
        this.toBytes(object, byArray, 2);
        return byArray;
    }

    @Override
    public int toBytes(Object object, byte[] byArray) {
        return this.toBytes(object, byArray, 0);
    }

    @Override
    public int toBytes(Object object, byte[] byArray, int n) {
        if (this.system_ != null && !this.system_.bidiAS400Varchar) {
            return this.toBytes(object, byArray, n, new BidiConversionProperties(AS400BidiTransform.getStringType(this.system_.getCcsid())));
        }
        return this.toBytes(object, byArray, n, new BidiConversionProperties(this.getSystemBidiType()));
    }

    public int toBytes(Object object, byte[] byArray, int n, int n2) {
        return this.toBytes(object, byArray, n, new BidiConversionProperties(n2));
    }

    public int toBytes(Object object, byte[] byArray, int n, BidiConversionProperties bidiConversionProperties) {
        int n2;
        if (object == null) {
            Trace.log(2, "Parameter 'javaValue' is null.");
            throw new NullPointerException("javaValue");
        }
        this.setTable();
        String string = (String)object;
        byte[] byArray2 = this.tableImpl_.stringToByteArray(string, bidiConversionProperties);
        int n3 = n2 = byArray2 != null ? byArray2.length : 0;
        if (n2 > this.length_) {
            Trace.log(2, "Length of parameter 'javaValue' is not valid: '" + object + "'");
            throw new ExtendedIllegalArgumentException("javaValue (" + string + ")", 1);
        }
        int n4 = n + this.varlensize_;
        if (this.varlensize_ == 2) {
            BinaryConverter.shortToByteArray((short)n2, byArray, 0);
        } else {
            BinaryConverter.intToByteArray(n2, byArray, 0);
        }
        System.arraycopy(byArray2, 0, byArray, n4, byArray2.length);
        if (Trace.traceOn_) {
            Trace.log(5, "AS400Varchar.toBytes(): Converted javaValue (" + string + ") to:", byArray, n4, this.length_);
        }
        return this.length_ + this.varlensize_;
    }

    @Override
    public Object toObject(byte[] byArray) {
        if (byArray == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        if (byArray.length > this.length_) {
            Trace.log(2, "Length of parameter serverValue is not valid: '" + byArray.length + "'");
            throw new ExtendedIllegalArgumentException("serverValue ", 1);
        }
        this.setTable();
        return this.tableImpl_.byteArrayToString(byArray, this.varlensize_, this.length_, new BidiConversionProperties(this.getSystemBidiType()));
    }

    @Override
    public Object toObject(byte[] byArray, int n) {
        if (byArray == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        if (byArray.length > this.length_) {
            Trace.log(2, "Length of parameter serverValue is not valid: '" + byArray.length + "'");
            throw new ExtendedIllegalArgumentException("serverValue ", 1);
        }
        this.setTable();
        return this.tableImpl_.byteArrayToString(byArray, n + this.varlensize_, this.length_, new BidiConversionProperties(this.getSystemBidiType()));
    }

    public Object toObject(byte[] byArray, int n, int n2) {
        return this.toObject(byArray, n + this.varlensize_, new BidiConversionProperties(n2));
    }

    public Object toObject(byte[] byArray, int n, BidiConversionProperties bidiConversionProperties) {
        if (byArray == null) {
            Trace.log(2, "Parameter 'serverValue' is null.");
            throw new NullPointerException("serverValue");
        }
        if (byArray.length > this.length_) {
            Trace.log(2, "Length of parameter serverValue is not valid: '" + byArray.length + "'");
            throw new ExtendedIllegalArgumentException("serverValue ", 1);
        }
        this.setTable();
        return this.tableImpl_.byteArrayToString(byArray, n + this.varlensize_, this.length_, bidiConversionProperties);
    }

    private int getSystemBidiType() {
        if (this.system_ == null) {
            return 0;
        }
        return this.system_.getBidiStringType();
    }
}

