/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.DataArea;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class CharacterDataArea
extends DataArea
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2007 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int DEFAULT_LENGTH = 32;
    static final int UNKNOWN_LENGTH = 0;
    private String initialValue_ = " ";

    public CharacterDataArea() {
        this.length_ = 0;
        this.dataAreaType_ = 1;
    }

    public CharacterDataArea(AS400 aS400, String string) {
        super(aS400, string);
        this.length_ = 0;
        this.dataAreaType_ = 1;
    }

    public void clear() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.clear();
        this.fireCleared();
    }

    public void create() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (this.length_ == 0) {
            this.length_ = 32;
        }
        this.impl_.create(this.length_, this.initialValue_, this.textDescription_, this.authority_);
        this.fireCreated();
    }

    public void create(int n, String string, String string2, String string3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (n < 1 || n > 2000) {
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        if (string == null) {
            throw new NullPointerException("initialValue");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("initialValue", 1);
        }
        if (string2 == null) {
            throw new NullPointerException("textDescription");
        }
        if (string2.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription", 1);
        }
        if (string3 == null) {
            throw new NullPointerException("authority");
        }
        if (string3.length() == 0 || string3.length() > 10) {
            throw new ExtendedIllegalArgumentException("authority", 1);
        }
        this.length_ = n;
        this.initialValue_ = string;
        this.textDescription_ = string2;
        this.authority_ = string3;
        this.create();
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        super.delete0();
    }

    @Override
    public String getPath() {
        return super.getPath();
    }

    public String read() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (this.length_ == 0) {
            this.length_ = this.getLength();
        }
        String string = this.impl_.retrieve(-1, this.length_);
        this.fireRead();
        return string;
    }

    public String read(int n) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (this.length_ == 0) {
            this.length_ = this.getLength();
        }
        String string = this.impl_.retrieve(-1, this.length_, n);
        this.fireRead();
        return string;
    }

    public String read(int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.length_ == 0) {
            this.length_ = this.getLength();
        }
        if (n < 0 || n >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (n2 < 1 || n2 > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (n + n2 > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        String string = this.impl_.retrieve(n, n2);
        this.fireRead();
        return string;
    }

    public String read(int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.length_ == 0) {
            this.length_ = this.getLength();
        }
        if (n < 0 || n >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (n2 < 1 || n2 > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (n + n2 > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        String string = this.impl_.retrieve(n, n2, n3);
        this.fireRead();
        return string;
    }

    @Override
    public int read(byte[] byArray, int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        return super.read(byArray, n, n2, n3);
    }

    @Override
    public void setPath(String string) throws PropertyVetoException {
        super.setPath(string);
    }

    public void write(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (string == null) {
            throw new NullPointerException("data");
        }
        if (string.length() < 1) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(string, 0);
        this.fireWritten();
    }

    public void write(String string, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        block7: {
            if (string == null) {
                throw new NullPointerException("data");
            }
            if (string.length() < 1) {
                throw new ExtendedIllegalArgumentException("data", 1);
            }
            if (this.length_ == 0) {
                try {
                    this.length_ = this.getLength();
                }
                catch (IllegalObjectTypeException illegalObjectTypeException) {
                    if (!Trace.isTraceOn() || !Trace.isTraceWarningOn()) break block7;
                    Trace.log(4, "Unexpected exception when retrieving length for character data area.", (Throwable)illegalObjectTypeException);
                }
            }
        }
        if (n < 0 || n >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(string, n);
        this.fireWritten();
    }

    public void write(String string, int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        block7: {
            if (string == null) {
                throw new NullPointerException("data");
            }
            if (this.length_ == 0) {
                try {
                    this.length_ = this.getLength();
                }
                catch (IllegalObjectTypeException illegalObjectTypeException) {
                    if (!Trace.isTraceOn() || !Trace.isTraceWarningOn()) break block7;
                    Trace.log(4, "Unexpected exception when retrieving length for character data area.", (Throwable)illegalObjectTypeException);
                }
            }
        }
        if (string.length() < 1) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (n < 0 || n >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(string, n, n2);
        this.fireWritten();
    }

    @Override
    public void write(byte[] byArray, int n, int n2, int n3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        super.write(byArray, n, n2, n3);
    }
}

