/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.CADSPool;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.NPDataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class ClientAccessDataStream
extends DataStream {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    protected static final int HEADER_LENGTH = 20;
    private static final CADSPool basePool_ = new CADSPool();
    private InUseLock inUseLock_ = new InUseLock();
    boolean inUse_;
    private CADSPool fromPool_ = null;
    private int fromPoolIndex_ = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ClientAccessDataStream construct(InputStream inputStream, Hashtable hashtable, Hashtable hashtable2, AS400ImplRemote aS400ImplRemote, int n) throws IOException {
        ClientAccessDataStream clientAccessDataStream = basePool_.getUnusedStream();
        try {
            ClientAccessDataStream clientAccessDataStream2;
            byte[] byArray = clientAccessDataStream.data_;
            if (ClientAccessDataStream.readFromStream(inputStream, byArray, 0, 20, n) < 20) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Failed to read all of the data stream header.");
                }
                clientAccessDataStream.returnToPool();
                clientAccessDataStream = null;
                throw new ConnectionDroppedException(2);
            }
            int n2 = clientAccessDataStream.getLength();
            if (clientAccessDataStream.data_[6] != -32) {
                if (Trace.traceOn_) {
                    Trace.log(2, "Incorrect data stream header detected.", clientAccessDataStream.data_, 0, 20);
                }
                clientAccessDataStream.returnToPool();
                clientAccessDataStream = null;
                inputStream.skip(inputStream.available());
                throw new InternalErrorException(2);
            }
            ClientAccessDataStream clientAccessDataStream3 = (ClientAccessDataStream)hashtable.get(clientAccessDataStream);
            if (clientAccessDataStream3 != null && clientAccessDataStream3 instanceof NPDataStream) {
                clientAccessDataStream2 = (NPDataStream)clientAccessDataStream3;
                if (clientAccessDataStream.getCorrelation() == ((NPDataStream)clientAccessDataStream2).getCorrelationID()) {
                    hashtable.remove(clientAccessDataStream);
                }
            }
            if (clientAccessDataStream3 != null && !(clientAccessDataStream3 instanceof NPDataStream)) {
                clientAccessDataStream3 = (ClientAccessDataStream)hashtable.remove(clientAccessDataStream);
            }
            if (clientAccessDataStream3 == null) {
                clientAccessDataStream2 = (ClientAccessDataStream)hashtable2.get(clientAccessDataStream);
                if (clientAccessDataStream2 == null) {
                    clientAccessDataStream3 = new ClientAccessDataStream();
                } else {
                    clientAccessDataStream3 = (ClientAccessDataStream)clientAccessDataStream2.getNewDataStream();
                    if (clientAccessDataStream3 == null) {
                        clientAccessDataStream3 = new ClientAccessDataStream();
                    }
                }
            }
            clientAccessDataStream3.system_ = aS400ImplRemote;
            if (Trace.traceOn_) {
                clientAccessDataStream3.setConnectionID(n);
            }
            int n3 = clientAccessDataStream.getLength();
            clientAccessDataStream3.data_ = new byte[n3];
            System.arraycopy(clientAccessDataStream.data_, 0, clientAccessDataStream3.data_, 0, 20);
            if (clientAccessDataStream3.data_.length - 20 > 0) {
                clientAccessDataStream3.readAfterHeader(inputStream);
            }
            ClientAccessDataStream clientAccessDataStream4 = clientAccessDataStream3;
            return clientAccessDataStream4;
        }
        finally {
            if (clientAccessDataStream != null) {
                clientAccessDataStream.returnToPool();
                clientAccessDataStream = null;
            }
        }
    }

    protected ClientAccessDataStream() {
        super(20);
    }

    ClientAccessDataStream(byte[] byArray) {
        super(20, byArray);
    }

    ClientAccessDataStream(CADSPool cADSPool, int n) {
        super(20);
        this.fromPool_ = cADSPool;
        this.fromPoolIndex_ = n;
    }

    @Override
    int getCorrelation() {
        return this.get32bit(12);
    }

    int getCSInstance() {
        return this.get32bit(8);
    }

    int getHeaderID() {
        return this.get16bit(4);
    }

    @Override
    int getLength() {
        return this.get32bit(0);
    }

    int getReqRepID() {
        return ((this.data_[18] & 0xFF) << 8) + (this.data_[19] & 0xFF);
    }

    int getServerID() {
        return this.get16bit(6);
    }

    int getTemplateLen() {
        return this.get16bit(16);
    }

    @Override
    public int hashCode() {
        return ((this.data_[18] & 0xFF) << 8) + (this.data_[19] & 0xFF);
    }

    @Override
    protected void setCorrelation(int n) {
        this.set32bit(n, 12);
    }

    protected void setCSInstance(int n) {
        this.set32bit(n, 8);
    }

    protected void setHeaderID(int n) {
        this.set16bit(n, 4);
    }

    @Override
    protected void setLength(int n) {
        this.data_[0] = (byte)(n >>> 24);
        this.data_[1] = (byte)(n >>> 16);
        this.data_[2] = (byte)(n >>> 8);
        this.data_[3] = (byte)n;
    }

    protected void setReqRepID(int n) {
        this.set16bit(n, 18);
    }

    protected void setServerID(int n) {
        this.set16bit(n, 6);
    }

    protected void setTemplateLen(int n) {
        this.set16bit(n, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnToPool() throws InternalErrorException {
        InUseLock inUseLock = this.inUseLock_;
        synchronized (inUseLock) {
            if (!this.inUse_) {
                throw new InternalErrorException(6);
            }
            this.inUse_ = false;
        }
        if (this.fromPool_ != null) {
            this.fromPool_.returnToPool(this, this.fromPoolIndex_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canUse() {
        InUseLock inUseLock = this.inUseLock_;
        synchronized (inUseLock) {
            if (this.inUse_) {
                return false;
            }
            this.inUse_ = true;
            return true;
        }
    }

    private class InUseLock {
        private InUseLock() {
        }
    }
}

